/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.CodeTesterPanel;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JAFrame;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.JATextArea;
import ch.abacus.lib.ui.JATextField;
import ch.abacus.lib.ui.renderer.common.UIFactoryCodeJumper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class CodeJumperTester
extends JAFrame {
    SuperDesignCockpit theDesignCockpit;
    JATextField theLineNumber = new JATextField(30);
    JATextArea theMessage = new JATextArea(5, 30);
    JAButton theSubmitButton = new JAButton("Go!");

    public CodeJumperTester(SuperDesignCockpit objDesignCockpit) {
        this.setTitle("Code Jumper Tester");
        this.theDesignCockpit = objDesignCockpit;
        this.setSize(200, 250);
        JALabel thePromptText = new JALabel("Enter line number: ");
        Container theContainer = this.getContentPane();
        theContainer.setLayout(new BorderLayout());
        CodeTesterPanel thePanel = new CodeTesterPanel();
        thePanel.add((Component)thePromptText, 0, 0, 1, 1);
        thePanel.add((Component)this.theLineNumber, 0, 1, 1, 1);
        thePanel.add((Component)this.theSubmitButton, 0, 3, 1, 1);
        thePanel.add((Component)this.theMessage, 0, 5, 4, 5);
        this.theSubmitButton.addActionListener((ActionListener)new CodeJumperActionListener());
        theContainer.add((Component)((Object)thePanel), "North");
        this.setSize(240, 360);
        this.show();
    }

    class CodeJumperActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            int iLineNumber = new Integer(CodeJumperTester.this.theLineNumber.getText());
            UIFactoryCodeJumper theCodeJumper = CodeJumperTester.this.theDesignCockpit.theCodeJumper;
            int iJumpClass = theCodeJumper.getJumpPointClass(iLineNumber);
            int iJumpType = theCodeJumper.getJumpPointType(iLineNumber);
            String sClassName = theCodeJumper.getClassName(iLineNumber);
            String sListenerName = "";
            if (iJumpClass == 2) {
                sListenerName = theCodeJumper.getListenerName(iLineNumber);
            }
            String sJumpPointDescription = "";
            switch (iJumpType) {
                case 0: {
                    sJumpPointDescription = "Error!";
                    break;
                }
                case 2: {
                    sJumpPointDescription = "Member Data: " + theCodeJumper.getMemberDataName(iLineNumber);
                    break;
                }
                case 1: {
                    sJumpPointDescription = "Method: " + theCodeJumper.getMethodName(iLineNumber);
                    break;
                }
                case 3: {
                    sJumpPointDescription = "Property: " + theCodeJumper.getPropertyName(iLineNumber);
                }
            }
            String sMessage = "Class: " + sClassName + "\n";
            if (sListenerName.length() != 0) {
                sMessage = sMessage + "Listener: " + sListenerName + "\n";
            }
            sMessage = sMessage + sJumpPointDescription;
            CodeJumperTester.this.theMessage.setText(sMessage);
        }
    }
}

