/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.DesignPanel;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JATabbedPane;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProperty;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DesignTabbedPane
extends JATabbedPane {
    public SuperDesignCockpit theDesignCockpit = null;
    public MetaObject theMetaObject = null;
    public TabbedPaneListener theListener = null;
    public TabbedPaneResizeListener theResizeListener = null;
    boolean bAllowRemoveTab = true;

    public DesignTabbedPane() {
    }

    public DesignTabbedPane(SuperDesignCockpit theDesignCockpit, MetaObject objMetaObject) {
        this.theDesignCockpit = theDesignCockpit;
        this.theMetaObject = objMetaObject;
        this.theListener = new TabbedPaneListener(theDesignCockpit);
        this.theResizeListener = new TabbedPaneResizeListener(theDesignCockpit);
        this.addChangeListener(this.theListener);
        this.addComponentListener(this.theResizeListener);
    }

    public void initalizeTabbedPane(SuperDesignCockpit theDesignCockpit, MetaObject objMetaObject) {
        this.theDesignCockpit = theDesignCockpit;
        this.theMetaObject = objMetaObject;
        this.theListener = new TabbedPaneListener(theDesignCockpit);
        this.theResizeListener = new TabbedPaneResizeListener(theDesignCockpit);
        this.addChangeListener(this.theListener);
        this.addComponentListener(this.theResizeListener);
    }

    public void removeTabAt(int index) {
        super.removeTabAt(index);
        if (this.bAllowRemoveTab) {
            MetaProperty theProperty = this.theMetaObject.theFirstProperty;
            while (theProperty != null && !theProperty.theName.equals("TabTitle")) {
                theProperty = theProperty.theNextProperty;
            }
            if (theProperty != null && theProperty.theIndexedValue.size() > index) {
                theProperty.theIndexedValue.remove(index);
                if (theProperty.theIndexedValue.size() == 0) {
                    theProperty.theIndexedValue.ensureCapacity(1);
                }
            }
        }
    }

    Color getAppropriateColor(Color theColor) {
        Color newColor = new Color((theColor.getRed() + 128) % 256, (theColor.getGreen() + 128) % 256, (theColor.getBlue() + 128) % 256);
        return newColor;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (int i = 0; i < this.getTabCount(); ++i) {
            MetaPropertyValueEx pvTabTitle = this.theMetaObject.getPropertyValue("TabTitle", i);
            String sTabTitle = null;
            if (pvTabTitle != null) {
                sTabTitle = pvTabTitle.getStringValue();
                sTabTitle = this.theMetaObject.theDesignProject.getNLS().getTranslatedValue(sTabTitle, this.theMetaObject.theDesignProject.getCurrentLanguage().theLanguage, false);
            }
            if (sTabTitle == null || sTabTitle.trim().length() == 0) continue;
            this.setTitleAt(i, sTabTitle);
        }
    }

    public void setSelectedIndex(int iTab) {
        super.setSelectedIndex(iTab);
    }

    class TabbedPaneResizeListener
    implements ComponentListener {
        SuperDesignCockpit theDesignCockpit;

        public TabbedPaneResizeListener(SuperDesignCockpit theDesignCockpit) {
            this.theDesignCockpit = theDesignCockpit;
        }

        public void componentHidden(ComponentEvent evt) {
        }

        public void componentMoved(ComponentEvent evt) {
        }

        public void componentShown(ComponentEvent evt) {
        }

        public void componentResized(ComponentEvent evt) {
            DesignTabbedPane tp = (DesignTabbedPane)((Object)evt.getSource());
            MetaObject theSelectedObject = this.theDesignCockpit.getSelectedObject();
            this.theDesignCockpit.setSelectedObject(null);
            this.theDesignCockpit.SelectContainer(null, true);
            this.theDesignCockpit.setSelectedObject(theSelectedObject);
            this.theDesignCockpit.SelectContainer(theSelectedObject, true);
            tp.repaint();
        }
    }

    class TabbedPaneListener
    implements ChangeListener {
        public int selectedIndex = -1;
        DesignTabbedPane tp;
        boolean bRecurse = false;
        SuperDesignCockpit theDesignCockpit = null;

        public TabbedPaneListener(SuperDesignCockpit theDesignCockpit) {
            this.theDesignCockpit = theDesignCockpit;
        }

        public void stateChanged(ChangeEvent evt) {
            this.tp = (DesignTabbedPane)((Object)evt.getSource());
            if (this.selectedIndex == -1 || this.selectedIndex != this.tp.getSelectedIndex()) {
                DesignPanel theTabPage;
                MetaObject theObject;
                int iTabPageSelectedBySwing = this.tp.getSelectedIndex();
                if (iTabPageSelectedBySwing != -1) {
                    this.tp.setEnabledAt(iTabPageSelectedBySwing, false);
                }
                if (this.selectedIndex != -1) {
                    this.tp.setEnabledAt(this.selectedIndex, true);
                }
                if ((theObject = this.tp.theMetaObject) != null && (theTabPage = (DesignPanel)this.tp.getSelectedComponent()) != null) {
                    MetaObject theChild = theTabPage.theMetaObject;
                    while (theChild != null) {
                        MetaObject theSelectedObject;
                        if (theChild.theVisualObject != null && theChild.theVisualObject.equals(theTabPage) && ((theSelectedObject = this.theDesignCockpit.getSelectedObject()) == null || theSelectedObject.equals(theObject)) && iTabPageSelectedBySwing != this.tp.getSelectedIndex()) {
                            this.theDesignCockpit.SelectContainer(theChild, true);
                            this.theDesignCockpit.SelectObject(theChild, false);
                        }
                        theChild = theChild.theNextObject;
                    }
                }
            }
            this.selectedIndex = this.tp.getSelectedIndex();
        }
    }
}

