/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;

public class FramePlacement
extends ComponentAdapter
implements WindowStateListener {
    private final SuperDesignCockpit theDesignCockpit;
    private Dimension normalFrameSize;
    private Point normalFramelocation;
    private Point previousFramelocation;

    public FramePlacement(SuperDesignCockpit objDesignCockpit) {
        this.theDesignCockpit = objDesignCockpit;
    }

    public void componentResized(ComponentEvent evt) {
        super.componentResized(evt);
        Component comp = evt.getComponent();
        Dimension dim = comp.getSize();
        if (comp.equals((Object)this.theDesignCockpit) && this.isNormal()) {
            this.normalFrameSize = dim;
        }
    }

    private void ensureWindowsVisible(Dimension dim) {
    }

    public void componentMoved(ComponentEvent e) {
        if (this.isNormal()) {
            this.previousFramelocation = this.normalFramelocation;
            this.normalFramelocation = this.theDesignCockpit.getLocation();
        }
    }

    public boolean isMaximized() {
        int iWindowState = this.theDesignCockpit.getExtendedState();
        return (iWindowState & 6) == 6;
    }

    public boolean isMinimized() {
        int iWindowState = this.theDesignCockpit.getExtendedState();
        return (iWindowState & 1) == 1;
    }

    public boolean isNormal() {
        int iWindowState = this.theDesignCockpit.getExtendedState();
        return iWindowState == 0;
    }

    public Dimension getNormalSize() {
        if (this.normalFrameSize != null) {
            return this.normalFrameSize;
        }
        return this.getSize();
    }

    public Dimension getSize() {
        return this.theDesignCockpit.getSize();
    }

    public void setNormalFrameSize(Dimension normalFrameSize) {
        this.normalFrameSize = normalFrameSize;
    }

    public Point getNormalLocation() {
        Point location = this.normalFramelocation;
        if (location == null) {
            location = this.theDesignCockpit.getLocation();
        }
        return location;
    }

    public Point getLocation() {
        return this.theDesignCockpit.getLocation();
    }

    public void windowStateChanged(WindowEvent e) {
        if (e.getNewState() == 6) {
            this.normalFramelocation = this.previousFramelocation;
        }
    }
}

