/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class IDEEditorPopupMenu
extends JPopupMenu {
    SuperDesignCockpit theCockpit = null;
    EditorUndoAction theUndoAction = null;
    EditorRedoAction theRedoAction = null;
    EditorCutAction theCutAction = null;
    EditorCopyAction theCopyAction = null;
    EditorPasteAction thePasteAction = null;
    Object theEditor = null;
    EditorSelectAllAction theSelectAllAction = null;

    public IDEEditorPopupMenu(Object objEditor, SuperDesignCockpit objCockpit) {
        this.theCockpit = objCockpit;
        this.theEditor = objEditor;
        this.theUndoAction = new EditorUndoAction("Undo", null, this.theCockpit);
        this.theRedoAction = new EditorRedoAction("Redo", null, this.theCockpit);
        this.theCutAction = new EditorCutAction("Cut", null, this.theCockpit);
        this.theCopyAction = new EditorCopyAction("Copy", null, this.theCockpit);
        this.thePasteAction = new EditorPasteAction("Paste", null, this.theCockpit);
        this.theSelectAllAction = new EditorSelectAllAction("Select All", null, this.theCockpit);
        JMenuItem jmitemUndo = this.add(this.theUndoAction);
        JMenuItem jmitemRedo = this.add(this.theRedoAction);
        this.addSeparator();
        JMenuItem jmitemCut = this.add(this.theCutAction);
        JMenuItem jmitemCopy = this.add(this.theCopyAction);
        JMenuItem jmitemPaste = this.add(this.thePasteAction);
        this.addSeparator();
        JMenuItem jmitemSelectAll = this.add(this.theSelectAllAction);
    }

    public void editorAction(String theActionName, ActionEvent evt) {
        Class<?> clsActiveEditor = this.theEditor.getClass();
        Class[] clsParams = new Class[]{new String().getClass()};
        try {
            Method m = clsActiveEditor.getMethod("getActionByName", clsParams);
            Object[] objParams = new Object[]{theActionName};
            Object obj = m.invoke(this.theEditor, objParams);
            if (obj != null && obj instanceof Action) {
                Action action = (Action)obj;
                action.actionPerformed(evt);
            }
        }
        catch (InvocationTargetException e1) {
            System.out.println("Invocation error");
        }
        catch (NoSuchMethodException e2) {
            System.out.println("No such method error");
        }
        catch (IllegalAccessException e3) {
            System.out.println("Illegal Access error");
        }
    }

    class EditorRedoAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;

        public EditorRedoAction(String label, Icon icon, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            this.theDesignCockpit = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            Class<?> clsActiveEditor = IDEEditorPopupMenu.this.theEditor.getClass();
            Class[] clsParams = new Class[]{};
            try {
                Method m = clsActiveEditor.getMethod("redo", clsParams);
                Object[] objParams = new Object[]{};
                Object obj = m.invoke(IDEEditorPopupMenu.this.theEditor, objParams);
            }
            catch (InvocationTargetException e1) {
                System.out.println("Invocation error");
            }
            catch (NoSuchMethodException e2) {
                System.out.println("No such method error");
            }
            catch (IllegalAccessException e3) {
                System.out.println("Illegal Access error");
            }
        }
    }

    class EditorUndoAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;

        public EditorUndoAction(String label, Icon icon, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            this.theDesignCockpit = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            Class<?> clsActiveEditor = IDEEditorPopupMenu.this.theEditor.getClass();
            Class[] clsParams = new Class[]{};
            try {
                Method m = clsActiveEditor.getMethod("undo", clsParams);
                Object[] objParams = new Object[]{};
                Object obj = m.invoke(IDEEditorPopupMenu.this.theEditor, objParams);
            }
            catch (InvocationTargetException e1) {
                System.out.println("Invocation error");
            }
            catch (NoSuchMethodException e2) {
                System.out.println("No such method error");
            }
            catch (IllegalAccessException e3) {
                System.out.println("Illegal Access error");
            }
        }
    }

    class EditorPasteAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;

        public EditorPasteAction(String label, Icon icon, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            this.theDesignCockpit = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.theDesignCockpit.theClipboardController.getClipboardContent() == 1) {
                IDEEditorPopupMenu.this.editorAction("paste-from-clipboard", evt);
            }
        }
    }

    class EditorCopyAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;

        public EditorCopyAction(String label, Icon icon, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            this.theDesignCockpit = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theDesignCockpit.theClipboardController.setClipboardContent(1);
            IDEEditorPopupMenu.this.editorAction("copy-to-clipboard", evt);
        }
    }

    class EditorSelectAllAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;

        public EditorSelectAllAction(String label, Icon icon, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            this.theDesignCockpit = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theDesignCockpit.theClipboardController.setClipboardContent(1);
            IDEEditorPopupMenu.this.editorAction("select-all", evt);
        }
    }

    class EditorCutAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;

        public EditorCutAction(String label, Icon icon, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            this.theDesignCockpit = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theDesignCockpit.theClipboardController.setClipboardContent(1);
            IDEEditorPopupMenu.this.editorAction("cut-to-clipboard", evt);
        }
    }
}

