/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.DesignProject;
import ch.abacus.designcockpit.ide.LanguageManager;
import ch.abacus.designcockpit.ide.PropertyTable;
import ch.abacus.designcockpit.ide.PropertyTableModel;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.designcockpit.ide.propertyinspector.IDEPropertyInspectorInterface;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProperty;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;

public class IDEPropertyInspectorController {
    private final SuperDesignCockpit m_superDesignCockpit;
    IDEPropertyInspectorInterface m_propertyInspector;
    PropertyTable m_defaultPropertyInspector;
    private LanguageManager m_languageManager;
    private MetaObject[] m_selectedComponents;

    public IDEPropertyInspectorController(SuperDesignCockpit superDesignCockpit) {
        this.m_superDesignCockpit = superDesignCockpit;
        this.m_languageManager = superDesignCockpit.theLanguageManager;
        this.m_propertyInspector = this.createPropertyInspector();
        if (this.m_propertyInspector == null) {
            PropertyTableModel thePropertyTableModel = new PropertyTableModel(this.m_superDesignCockpit);
            this.m_defaultPropertyInspector = new PropertyTable(thePropertyTableModel, this.m_superDesignCockpit);
        }
    }

    public void newObjectsSelected() {
        if (this.m_propertyInspector == null) {
            return;
        }
        DesignProject designProject = this.m_superDesignCockpit.getDesignProject();
        int iSelObjCount = designProject.getSelectedObjectCount();
        Object[] selectedObjects = new MetaObject[iSelObjCount];
        for (int iSelObj = 0; iSelObj < iSelObjCount; ++iSelObj) {
            MetaObject metaObject = designProject.getSelectedObject(iSelObj);
            selectedObjects[iSelObj] = metaObject;
        }
        if (!Arrays.equals(selectedObjects, this.m_selectedComponents)) {
            this.m_selectedComponents = selectedObjects;
            this.m_propertyInspector.clearSelectedObjects();
            this.m_propertyInspector.newObjectsSelected((MetaObject[])selectedObjects);
        } else {
            this.m_propertyInspector.updateSelectedProperties();
        }
    }

    private IDEPropertyInspectorInterface createPropertyInspector() {
        String sPropertyInspector = this.m_superDesignCockpit.getConfigurationManager().getConfigurationVariable("PROPERTY_INSPECTOR", "");
        if (sPropertyInspector.equals("")) {
            return null;
        }
        IDEPropertyInspectorInterface inspectorInterface = null;
        String sErrorMessage = null;
        try {
            Class<?> propertyInspector = Class.forName(sPropertyInspector);
            try {
                Constructor<?> constructor = propertyInspector.getConstructor(null);
                try {
                    inspectorInterface = (IDEPropertyInspectorInterface)constructor.newInstance(null);
                }
                catch (InstantiationException e) {
                    sErrorMessage = e.getMessage();
                    inspectorInterface = null;
                }
                catch (IllegalAccessException e) {
                    sErrorMessage = e.getMessage();
                    inspectorInterface = null;
                }
                catch (InvocationTargetException e) {
                    sErrorMessage = e.getMessage();
                    inspectorInterface = null;
                }
                catch (ClassCastException e) {
                    sErrorMessage = sPropertyInspector + " does not implement the IDEPropertyInspectorInterface, and cannot be used.";
                    inspectorInterface = null;
                }
            }
            catch (NoSuchMethodException e) {
                sErrorMessage = sPropertyInspector + " does not have a default Constructor, and cannot be used.";
                inspectorInterface = null;
            }
        }
        catch (ClassNotFoundException e) {
            sErrorMessage = "the class \"" + sPropertyInspector + "\" cannot be found.";
            inspectorInterface = null;
        }
        if (inspectorInterface != null) {
            inspectorInterface.init(this);
        } else {
            System.out.println("Property Inspector configuration is invalid: " + sErrorMessage);
        }
        return inspectorInterface;
    }

    public void refreshPropertyInspector() {
        if (this.m_propertyInspector != null) {
            this.newObjectsSelected();
        } else {
            this.m_defaultPropertyInspector.Load();
        }
    }

    public SuperDesignCockpit getSuperDesignCockpit() {
        return this.m_superDesignCockpit;
    }

    public Object getPropertyValue(MetaObject theMetaObject, String sPropertyName) {
        Object oValue;
        DesignProject theDesignProject;
        MetaClass metaClass = theMetaObject.theClass;
        MetaPropertyDescriptor theProperty = metaClass.getProperty(sPropertyName, true);
        if (theProperty == null) {
            return null;
        }
        if ((theMetaObject.isFrame() || theMetaObject.isAbalet()) && sPropertyName.startsWith("Location")) {
            return new String("0");
        }
        int iDotPos = sPropertyName.indexOf(".");
        String sKey = sPropertyName;
        if (iDotPos != -1) {
            sKey = sPropertyName.substring(0, iDotPos);
        }
        String sType = theProperty.getClassName();
        MetaProperty theProp = theMetaObject.getPropertyMetadata(sKey);
        if (theProperty.bObjectReference && this.getSuperDesignCockpit().getOpenSourceState()) {
            theDesignProject = this.getSuperDesignCockpit().getDesignProject();
            ArrayList arrObj = theDesignProject.findObjectsByClass(sType);
            theProperty.setObjectReferenceList(arrObj);
        } else if (theProperty.getDataAwareness() && this.getSuperDesignCockpit().getOpenSourceState()) {
            theDesignProject = this.getSuperDesignCockpit().getDesignProject();
            MetaObject mt = theDesignProject.getLastObjectSelected();
            Object objFieldAccess = mt.getSwingObject();
            Class<?> fldAccsClass = objFieldAccess.getClass();
            Method[] availMthds = fldAccsClass.getMethods();
            for (int i = 0; i < availMthds.length; ++i) {
                Method chMth = availMthds[i];
                String methodName = chMth.getName();
                if (!methodName.equalsIgnoreCase("getFieldNames") && !methodName.equalsIgnoreCase("getTableNames")) continue;
                try {
                    ArrayList fields = (ArrayList)chMth.invoke(objFieldAccess, (Object[])null);
                    if (fields != null) {
                        for (int n = 0; n < fields.size(); ++n) {
                            try {
                                theProperty.setValueChoice(n, (Object)fields.get(n).toString());
                                continue;
                            }
                            catch (Exception e) {
                                theProperty.addValueChoice(fields.get(n).toString());
                            }
                        }
                        continue;
                    }
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (theProp == null) {
            if (!sType.endsWith("oolean") && theProperty.getDefaultValue() != null) {
                String sDefault = theProperty.getDefaultValue();
                Object oMatch = theProperty.getExpandedValue(theMetaObject.theDesignProject, sDefault);
                return oMatch;
            }
            return null;
        }
        int iIndex = 0;
        MetaPropertyValueEx pvValue = theMetaObject.getPropertyValue(sPropertyName, iIndex);
        MetaConstantGroup theConstantTable = theMetaObject.theDesignProject.findConstantGroup(theProperty.getIncludeTypeConstants());
        if (theConstantTable != null) {
            if (pvValue != null) {
                String sConstantValue = pvValue.getLocalString();
                String sMatch = theConstantTable.getKey(sConstantValue);
                if (sMatch != null) {
                    if (sType.endsWith("oolean")) {
                        return new Boolean(sMatch);
                    }
                    return sMatch;
                }
                return sConstantValue;
            }
        } else {
            MetaConstantGroupCollection theConstantTableCollection = theMetaObject.theDesignProject.findConstantGroupCollection(theProperty.getIncludeTypeConstants());
            if (theConstantTableCollection != null && pvValue != null) {
                String sConstantValue = pvValue.getLocalString();
                String sMatch = theConstantTableCollection.getKey(sConstantValue);
                if (sMatch != null) {
                    if (sType.endsWith("oolean")) {
                        return new Boolean(sMatch);
                    }
                    return sMatch;
                }
                return sConstantValue;
            }
        }
        if (pvValue == null) {
            oValue = theProperty.getDefaultValue();
            if (oValue == null) {
                oValue = theProperty.getValueChoice(0);
            }
        } else {
            oValue = pvValue.getNativeValue();
            return oValue;
        }
        pvValue = new MetaPropertyValueEx(sType, oValue, true, theMetaObject.theDesignProject, theProperty.bAllowMultipleLanguages);
        String sRetVal = pvValue.getStringValue();
        if (sType.endsWith("oolean")) {
            return new Boolean(sRetVal);
        }
        return sRetVal;
    }

    public void setPropertyValue(MetaObject theMetaObject, String sPropertyName, Object theNewValue) {
        String sMatch;
        MetaClass metaClass = theMetaObject.theClass;
        MetaPropertyDescriptor theProperty = metaClass.getProperty(sPropertyName, true);
        if (theProperty.getName().equalsIgnoreCase("Name")) {
            MetaObject metaObject;
            String sNewName = (String)theNewValue;
            if (sNewName.trim().length() == 0) {
                return;
            }
            if (!this.isNameChangePermitted(sNewName) && !(metaObject = this.m_superDesignCockpit.getDesignProject().findObject(sNewName)).getName().equalsIgnoreCase(theMetaObject.getName())) {
                MetaObject metaObjectParent = metaObject.theParentObject;
                String sMessage = metaObjectParent != null ? this.m_languageManager.expandMessage("DuplcateObjectNames.hasParent.label", "That name is already used by another object, which is a child of \"{0}\"", metaObject.theParentObject.getName()) : this.m_languageManager.getMessage("DuplcateObjectNames.noParent.label", "That name is already used by another object, the project's first object");
                String sTitle = this.m_languageManager.getMessage("DuplcateObjectNames.label", "Duplicate Object Name");
                this.m_superDesignCockpit.theSourceViewer.setMessagesText(sTitle + " - " + sMessage);
                this.m_superDesignCockpit.theSourceViewer.showMessageEditor();
                return;
            }
        }
        MetaConstantGroup theConstantTable = theMetaObject.theDesignProject.findConstantGroup(theProperty.getIncludeTypeConstants());
        MetaConstantGroupCollection theConstantTableGroup = null;
        if (theConstantTable != null) {
            if (theNewValue instanceof String && (sMatch = theConstantTable.get((String)theNewValue)) != null) {
                theNewValue = sMatch;
            }
        } else {
            theConstantTableGroup = theMetaObject.theDesignProject.findConstantGroupCollection(theProperty.getIncludeTypeConstants());
            if (theConstantTableGroup != null && theNewValue instanceof String && (sMatch = theConstantTableGroup.get((String)theNewValue)) != null) {
                theNewValue = sMatch;
            }
        }
        theMetaObject.theDesignProject.setProjectChangedState(true);
        if ((theMetaObject.isFrame() || theMetaObject.isAbalet()) && sPropertyName.startsWith("Location")) {
            theNewValue = new String("0");
        }
        MetaPropertyValueEx pvOldValue = theMetaObject.getPropertyValue(sPropertyName, 0);
        String sOldValue = null;
        if (pvOldValue != null) {
            sOldValue = pvOldValue.getStringValue();
        }
        String sNewReverseLookup = null;
        String sOldReverseLookup = null;
        if (theConstantTable != null) {
            sNewReverseLookup = theConstantTable.getKey((String)theNewValue);
            sOldReverseLookup = theConstantTable.getKey(sOldValue);
        } else if (theConstantTableGroup != null) {
            sNewReverseLookup = theConstantTableGroup.getKey((String)theNewValue);
            sOldReverseLookup = theConstantTableGroup.getKey(sOldValue);
        } else if (!theNewValue.equals(sOldValue)) {
            this.propertyEdited(theMetaObject, sPropertyName, theProperty.getOrder(), theNewValue);
            return;
        }
        if (!theNewValue.equals(sOldValue) && sNewReverseLookup != null && !sNewReverseLookup.equals(sOldReverseLookup)) {
            this.propertyEdited(theMetaObject, sPropertyName, theProperty.getOrder(), theNewValue);
        }
    }

    private boolean isNameChangePermitted(String sNewName) {
        MetaObject mo = this.m_superDesignCockpit.getDesignProject().findObject(sNewName);
        return mo == null;
    }

    public void propertyEdited(MetaObject theMetaObject, String sPropertyName, int iOrder, Object theNewValue) {
        this.m_superDesignCockpit.getDesignProject().theUndoRedoController.createChangePropertyEvent(theMetaObject, sPropertyName, 0, 0);
        theMetaObject.setPropertyValue(sPropertyName, 0, iOrder, theNewValue, false);
        theMetaObject.refresh();
        if (theMetaObject.theClass.getMetadata().containerType.getContainerType() != 3) {
            if (theMetaObject.theVisualObject != null) {
                theMetaObject.theVisualObject.repaint();
            }
        } else if (theMetaObject.iMode == 1) {
            this.m_superDesignCockpit.getDesignProject().getMetaDataUser().propertyEditedRepaint(theMetaObject);
        }
    }

    public void editingCanceled() {
        if (this.m_defaultPropertyInspector != null) {
            this.m_defaultPropertyInspector.editingCanceled(new ChangeEvent(this));
        }
        if (this.m_propertyInspector != null) {
            this.m_propertyInspector.editingCanceled(new ChangeEvent(this));
        }
    }

    public void resetContents() {
        if (this.m_defaultPropertyInspector != null) {
            this.m_defaultPropertyInspector.resetContents();
        }
        if (this.m_propertyInspector != null) {
            this.newObjectsSelected();
        }
    }

    public void repaint() {
        if (this.m_defaultPropertyInspector != null) {
            this.m_defaultPropertyInspector.repaint();
        }
        if (this.m_defaultPropertyInspector != null) {
            this.m_defaultPropertyInspector.repaint();
        }
    }

    public JComponent getEmbeddedPropertyInspector() {
        if (this.m_propertyInspector != null) {
            return this.m_propertyInspector.getPropertyInspectorComponent();
        }
        return this.m_defaultPropertyInspector;
    }

    public void showHelper(MetaObject metaObject, String sPropertyName) {
        this.editingCanceled();
        this.m_superDesignCockpit.showHelper(metaObject, sPropertyName);
    }
}

