/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

class IDEViewDisplayerComponentMouseMotionListener
implements MouseMotionListener {
    MetaObject theDesignObject;
    Component theComponent;
    SuperDesignCockpit theDesignCockpit;

    public IDEViewDisplayerComponentMouseMotionListener(MetaObject objDesignObject, Component objComponent, SuperDesignCockpit theDesignCockpit) {
        this.theDesignObject = objDesignObject;
        this.theComponent = objComponent;
        this.theDesignCockpit = theDesignCockpit;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.theDesignCockpit.getAllowDragging()) {
            return;
        }
        MetaObject parent = this.theDesignObject.theParentObject;
        if (parent != null) {
            boolean bSplitParent;
            boolean bl = bSplitParent = parent.isHorzSplit() || parent.isVertSplit();
            if (bSplitParent) {
                return;
            }
        }
        Point pt = e.getPoint();
        Point ptViewDisplayerScreen = this.theDesignCockpit.theViewDisplayer.getLocationOnScreen();
        Point ptObjectLocation = this.theDesignObject.theVisualObject.getLocationOnScreen();
        if (!this.theDesignObject.bDragged) {
            this.beginDragging(this.theDesignObject);
        }
        this.theDesignCockpit.dragAction(this.theDesignObject, e, ptViewDisplayerScreen, ptObjectLocation, pt);
    }

    void beginResizing(MetaObject theMetaObject) {
        theMetaObject.bResizing = true;
        this.theDesignCockpit.getDesignProject().theUndoRedoController.createChangeSizeEvent(theMetaObject);
    }

    void beginDragging(MetaObject theMetaObject) {
        int iSelectedObjectCount = this.theDesignCockpit.getDesignProject().getSelectedObjectCount();
        ArrayList<MetaObject> theObjects = new ArrayList<MetaObject>(iSelectedObjectCount);
        for (int i = 0; i < iSelectedObjectCount; ++i) {
            theObjects.add(this.theDesignCockpit.getDesignProject().getSelectedObject(i));
        }
        this.theDesignCockpit.getDesignProject().theUndoRedoController.createChangeLocationEvent(theObjects);
        theMetaObject.bDragged = true;
    }

    void endResizing(MetaObject theMetaObject) {
        theMetaObject.bResizing = false;
    }

    void endDragging(MetaObject theMetaObject) {
        theMetaObject.bDragged = false;
    }
}

