/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.IDEObjectPopupMenu;
import ch.abacus.designcockpit.ide.IDETitleBar;
import ch.abacus.designcockpit.ide.ObjectTreeView;
import ch.abacus.designcockpit.ide.ObjectTreeViewKeyListener;
import ch.abacus.designcockpit.ide.ObjectTreeViewModelListener;
import ch.abacus.designcockpit.ide.ObjectTreeViewMouseListener;
import ch.abacus.designcockpit.ide.ObjectTreeViewSelectionListener;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.renderer.common.AbaMetaDataUser;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.ObjectTreeViewNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ObjectTreeViewPane
extends JAPanel {
    protected ObjectTreeViewNode theRootNode = new ObjectTreeViewNode("Program");
    protected DefaultTreeModel theTreeModel = new DefaultTreeModel((TreeNode)this.theRootNode);
    protected ObjectTreeView theTree;
    public SuperDesignCockpit theDesignCockpit = null;
    public IDEObjectPopupMenu thePopupMenu = null;
    public JAScrollPane theScrollPane;

    public ObjectTreeViewPane(SuperDesignCockpit objDesignCockpit) {
        this.theTreeModel.addTreeModelListener(new ObjectTreeViewModelListener(objDesignCockpit));
        this.theDesignCockpit = objDesignCockpit;
        this.theTree = new ObjectTreeView(this.theTreeModel, this.theDesignCockpit);
        this.theTree.setEditable(false);
        this.theTree.getSelectionModel().setSelectionMode(1);
        this.theTree.setShowsRootHandles(true);
        this.theTree.addTreeSelectionListener(new ObjectTreeViewSelectionListener());
        this.theTree.addKeyListener(new ObjectTreeViewKeyListener(this));
        this.theTree.addMouseListener(new ObjectTreeViewMouseListener(this));
        this.theScrollPane = new JAScrollPane((Component)((Object)this.theTree));
        this.setLayout(new BorderLayout());
        String sPaneTitle = this.theDesignCockpit.theLanguageManager.getMessage("ObjectPane.label", "Object Hierarchy");
        this.add((Component)((Object)new IDETitleBar(sPaneTitle)), "North");
        this.add((Component)this.theScrollPane, "Center");
        this.theScrollPane.setBorder(null);
        this.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.GRAY));
        this.add((Component)this.theScrollPane);
    }

    public void initPopupMenu(SuperDesignCockpit theDesignCockpit) {
        this.thePopupMenu = new IDEObjectPopupMenu(theDesignCockpit);
    }

    public void clear() {
        this.theRootNode.removeAllChildren();
        this.theTreeModel.reload();
    }

    public void removeCurrentNode() {
        TreePath currentSelection = this.theTree.getSelectionPath();
        if (currentSelection != null) {
            ObjectTreeViewNode currentNode = (ObjectTreeViewNode)currentSelection.getLastPathComponent();
            MetaObject theMetaObject = currentNode.getMetaObject();
            theMetaObject.DeleteObject(this.theDesignCockpit.theCurrentDesignProject.theMetaProject, (AbaMetaDataUser)this.theDesignCockpit);
            ObjectTreeViewNode parent = (ObjectTreeViewNode)currentNode.getParent();
            if (parent != null) {
                this.theTreeModel.removeNodeFromParent((MutableTreeNode)currentNode);
                return;
            }
        }
    }

    public void removeNode(ObjectTreeViewNode nodeToRemove) {
        MetaObject theMetaObject = nodeToRemove.getMetaObject();
        theMetaObject.DeleteObject(this.theDesignCockpit.theCurrentDesignProject.theMetaProject, (AbaMetaDataUser)this.theDesignCockpit);
        ObjectTreeViewNode parent = (ObjectTreeViewNode)nodeToRemove.getParent();
        if (parent != null) {
            this.theTreeModel.removeNodeFromParent((MutableTreeNode)nodeToRemove);
        }
    }

    public boolean removeObject(MetaObject theMetaObject) {
        ObjectTreeViewNode nodeToRemove = theMetaObject.getTreeNode();
        if (nodeToRemove == null) {
            return false;
        }
        ObjectTreeViewNode parent = (ObjectTreeViewNode)nodeToRemove.getParent();
        if (parent == null) {
            return false;
        }
        this.theTreeModel.removeNodeFromParent((MutableTreeNode)nodeToRemove);
        return true;
    }

    public ObjectTreeViewNode addObject(String theNodeText) {
        ObjectTreeViewNode parentNode = null;
        TreePath parentPath = this.theTree.getSelectionPath();
        parentNode = parentPath == null ? this.theRootNode : (ObjectTreeViewNode)parentPath.getLastPathComponent();
        return this.addObject(parentNode, theNodeText, true);
    }

    public ObjectTreeViewNode addObject(ObjectTreeViewNode parent, String theNodeText) {
        return this.addObject(parent, theNodeText, false);
    }

    public ObjectTreeViewNode addObject(ObjectTreeViewNode parent, String theNodeText, boolean shouldBeVisible) {
        ObjectTreeViewNode childNode = new ObjectTreeViewNode(theNodeText);
        if (parent == null) {
            parent = this.theRootNode;
        }
        this.theTreeModel.insertNodeInto((MutableTreeNode)childNode, (MutableTreeNode)parent, parent.getChildCount());
        if (shouldBeVisible) {
            this.theTree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    protected boolean load(MetaObject theFirstObject, ObjectTreeViewNode thisNode) {
        MetaObject currObj = theFirstObject;
        while (currObj != null) {
            ObjectTreeViewNode theNewNode = new ObjectTreeViewNode(currObj);
            if (thisNode == null) {
                this.theTreeModel.insertNodeInto((MutableTreeNode)theNewNode, (MutableTreeNode)this.theRootNode, this.theRootNode.getChildCount());
            } else {
                this.theTreeModel.insertNodeInto((MutableTreeNode)theNewNode, (MutableTreeNode)thisNode, thisNode.getChildCount());
            }
            currObj.setTreeNode(theNewNode);
            if (currObj.theFirstChild != null) {
                this.load(currObj.theFirstChild, theNewNode);
            }
            currObj = currObj.theNextObject;
        }
        if (this.theDesignCockpit.isCustomizing()) {
            this.theTree.expandAll();
        }
        return true;
    }

    public void moveDown() {
        ObjectTreeViewNode theSelectedNode = (ObjectTreeViewNode)this.theTree.getLastSelectedPathComponent();
        if (theSelectedNode.getMetaObject().isTabPage()) {
            return;
        }
        ObjectTreeViewNode theNextNode = (ObjectTreeViewNode)theSelectedNode.getNextSibling();
        if (theNextNode != null) {
            ObjectTreeViewNode theParent = (ObjectTreeViewNode)theSelectedNode.getParent();
            this.theTree.theModel.removeNodeFromParent((MutableTreeNode)theNextNode);
            this.theTree.theModel.insertNodeInto((MutableTreeNode)theNextNode, (MutableTreeNode)theParent, theParent.getIndex((TreeNode)theSelectedNode));
            MetaObject objParent = theParent.getMetaObject();
            MetaObject objChild1 = theNextNode.getMetaObject();
            MetaObject objChild2 = theSelectedNode.getMetaObject();
            objParent.exchangeChildren(objChild1, objChild2);
        }
    }

    public void moveUp() {
        ObjectTreeViewNode theSelectedNode = (ObjectTreeViewNode)this.theTree.getLastSelectedPathComponent();
        if (theSelectedNode.getMetaObject().isTabPage()) {
            return;
        }
        ObjectTreeViewNode thePreviousNode = (ObjectTreeViewNode)theSelectedNode.getPreviousSibling();
        if (thePreviousNode != null) {
            ObjectTreeViewNode theParent = (ObjectTreeViewNode)theSelectedNode.getParent();
            this.theTree.theModel.removeNodeFromParent((MutableTreeNode)theSelectedNode);
            this.theTree.theModel.insertNodeInto((MutableTreeNode)theSelectedNode, (MutableTreeNode)theParent, theParent.getIndex((TreeNode)thePreviousNode));
            TreePath path = new TreePath(theSelectedNode.getPath());
            if (path != null) {
                this.theTree.setSelectionPath(path);
            }
            MetaObject objParent = theParent.getMetaObject();
            MetaObject objChild1 = thePreviousNode.getMetaObject();
            MetaObject objChild2 = theSelectedNode.getMetaObject();
            objParent.exchangeChildren(objChild1, objChild2);
        }
    }

    public void addObjects(MetaObject currObj) {
        this.addObject(currObj, currObj.theParentObject);
        currObj = currObj.theFirstChild;
        while (currObj != null) {
            this.addObjects(currObj);
            currObj = currObj.theNextObject;
        }
    }

    public void addObject(MetaObject currObj, MetaObject theParent) {
        if (currObj != null) {
            if (theParent == null) {
                theParent = this.theDesignCockpit.getSelectedObject();
            }
            if (theParent == null || theParent.theClass.getMetadata().containerType.getContainerType() == 0) {
                theParent = this.theDesignCockpit.getSelectedFrame();
            }
            if (theParent != null && theParent.equals(currObj)) {
                theParent = null;
            }
            ObjectTreeViewNode theNewNode = new ObjectTreeViewNode(currObj);
            currObj.setTreeNode(theNewNode);
            if (theParent != null) {
                ObjectTreeViewNode theParentNode = theParent.getTreeNode();
                this.theTreeModel.insertNodeInto((MutableTreeNode)theNewNode, (MutableTreeNode)theParentNode, theParentNode.getChildCount());
            } else {
                this.theTreeModel.insertNodeInto((MutableTreeNode)theNewNode, (MutableTreeNode)this.theRootNode, this.theRootNode.getChildCount());
                if (currObj != null) {
                    if (currObj.theClass.getMetadata().containerType.getContainerType() == 3 || currObj.theClass.getMetadata().containerType.getContainerType() == 5 || currObj.theClass.getMetadata().containerType.getContainerType() == 4) {
                        this.theDesignCockpit.SelectContainer(currObj);
                    }
                    this.theDesignCockpit.SelectObject(currObj, false);
                }
            }
            this.theTree.setFolderIcons();
        }
    }

    public void redisplayProject() {
        this.clear();
        MetaProject metaProject = this.theDesignCockpit.theCurrentDesignProject.theMetaProject;
        this.load(metaProject.getFirstObject(), null);
    }
}

