/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.classEditor.LizardValueChoiceComboBoxModel;
import ch.abacus.designcockpit.ide.PropertyTable;
import ch.abacus.designcockpit.ide.PropertyTableValueChoiceComboBox;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

class PropertyComboBoxEditor
extends PropertyTableValueChoiceComboBox {
    PropertyTable theTable;
    ListCellRenderer defaultRenderer;

    public PropertyComboBoxEditor(LizardValueChoiceComboBoxModel model, Object receiver) {
        super(model, receiver);
        if (receiver instanceof PropertyTable) {
            this.theTable = (PropertyTable)receiver;
        }
    }

    public void enableColorSelection() {
        if (this.defaultRenderer == null) {
            this.defaultRenderer = this.getRenderer();
        }
        this.setRenderer(new ColorRenderer());
    }

    Color getItemColor(String avalue) {
        MetaPropertyDescriptor theProperty = this.theTable.theModel.theClassProperties.get(this.iRow);
        Object theResolvedValue = null;
        MetaConstantGroupCollection theConstantTableGroup = this.theTable.theModel.theMetaObject.theDesignProject.findConstantGroupCollection(theProperty.getIncludeTypeConstants());
        String nv = theConstantTableGroup.get(avalue);
        try {
            theResolvedValue = MetaConstantGroup.resolve((Object)nv, (MetadataDispenser)this.theTable.theDesignCockpit.theMetadataDispenser, (ClassLoader)this.theTable.theDesignCockpit.theFirstDesignProject.getMetaDataUser().getClassLoader().getLoader());
        }
        catch (HammerException e) {
            e.printStackTrace();
        }
        return (Color)theResolvedValue;
    }

    public void enableDefaultSelection() {
        this.setRenderer(this.defaultRenderer);
    }

    class ColorComboEditor
    extends JTextField
    implements ComboBoxEditor {
        private JComboBox combo;

        public ColorComboEditor(JComboBox combo) {
            this.setComboBox(combo);
            this.setBorder(null);
        }

        public Component getEditorComponent() {
            return this;
        }

        public Object getItem() {
            return super.getText();
        }

        public void setItem(Object anObject) {
            super.setText((String)anObject);
        }

        public void setComboBox(JComboBox combo) {
            if (!combo.isEditable()) {
                combo.setEditable(true);
            }
            this.combo = combo;
        }

        public JComboBox getComboBox() {
            return this.combo;
        }
    }

    class ColorRenderer
    implements ListCellRenderer {
        ColorRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ColorLabel label = new ColorLabel((String)value);
            label.setOpaque(true);
            return label;
        }
    }

    class ColorLabel
    extends JLabel {
        public ColorLabel(String strValue) {
            super(strValue);
        }

        public void paint(Graphics g) {
            String labelText = this.getText();
            Color currentColor = PropertyComboBoxEditor.this.getItemColor(labelText);
            JButton button = new JButton();
            Dimension dim = new Dimension(button.getFontMetrics(button.getFont()).stringWidth("...") * 2, button.getFontMetrics(button.getFont()).getHeight());
            g.setColor(Color.black);
            g.fillRect(0, 0, (int)dim.getWidth(), (int)dim.getHeight());
            g.setColor(currentColor);
            g.fillRect(1, 1, (int)dim.getWidth() - 2, (int)dim.getHeight() - 2);
            FontMetrics fontMetrics = g.getFontMetrics();
            g.setColor(PropertyComboBoxEditor.this.theTable.getForeground());
            g.drawString(labelText, (int)dim.getWidth() + 2, fontMetrics.getAscent());
        }
    }
}

