/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide.propertyinspector;

import ch.abacus.lib.ui.propertyinspector.core.StringEntry;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import java.util.ArrayList;
import java.util.HashMap;

public class ConstantListFactory {
    private final MetadataDispenser m_metadataDispenser;
    private HashMap<String, ArrayList<StringEntry>> m_lists;

    public ConstantListFactory(MetadataDispenser metadataDispenser) {
        this.m_metadataDispenser = metadataDispenser;
        this.m_lists = new HashMap(10);
    }

    public ArrayList getConstantList(String sName) {
        ArrayList<StringEntry> list = this.m_lists.get(sName);
        if (list != null) {
            return list;
        }
        return this.createConstantList(sName);
    }

    private ArrayList createConstantList(String sName) {
        ArrayList<StringEntry> list = new ArrayList<StringEntry>();
        MetaConstantGroup group = this.m_metadataDispenser.findConstantGroup(sName);
        if (group != null) {
            ArrayList constantList = group.getConstantList();
            for (int iConstant = 0; iConstant < constantList.size(); ++iConstant) {
                String sConstantName = (String)constantList.get(iConstant);
                list.add(new StringEntry((Object)sConstantName, sConstantName));
            }
        } else {
            MetaConstantGroupCollection collection = this.m_metadataDispenser.findConstantGroupCollection(sName);
            if (collection != null) {
                ArrayList constantList = collection.getConstantList();
                for (int iConstant = 0; iConstant < constantList.size(); ++iConstant) {
                    String sConstantName = (String)constantList.get(iConstant);
                    list.add(new StringEntry((Object)sConstantName, sConstantName));
                }
            }
        }
        this.m_lists.put(sName, list);
        return list;
    }
}

