/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide.propertyinspector;

import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.designcockpit.ide.propertyinspector.ColorPropertyValueRenderer;
import ch.abacus.designcockpit.ide.propertyinspector.ConstantListFactory;
import ch.abacus.designcockpit.ide.propertyinspector.DCBooleanRenderer;
import ch.abacus.designcockpit.ide.propertyinspector.DynamicListEditor;
import ch.abacus.designcockpit.ide.propertyinspector.MyIntegerEditor;
import ch.abacus.designcockpit.ide.propertyinspector.MyStringEditor;
import ch.abacus.designcockpit.ide.propertyinspector.ObjecReferenceListEditor;
import ch.abacus.lib.ui.propertyinspector.core.StringEntry;
import ch.abacus.lib.ui.propertyinspector.display.PropertyEditorRegistry;
import ch.abacus.lib.ui.propertyinspector.display.PropertyInspector;
import ch.abacus.lib.ui.propertyinspector.display.PropertyRendererInterface;
import ch.abacus.lib.ui.propertyinspector.display.PropertyRendererRegistry;
import ch.abacus.lib.ui.propertyinspector.display.PropertyValueEditorInterface;
import ch.abacus.lib.ui.propertyinspector.display.editor.BooleanEditor;
import ch.abacus.lib.ui.propertyinspector.display.renderer.ColorIcon;
import ch.abacus.lib.ui.propertyinspector.display.renderer.StringRenderer;
import ch.abacus.lib.ui.renderer.common.HammerClassCustomLoader;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.Icon;

public class PropertyRegistry {
    private final PropertyInspector m_propertyInspector;
    private final SuperDesignCockpit m_superDesignCockpit;
    private PropertyRendererRegistry m_rendererRegistry;
    private PropertyEditorRegistry m_editorRegistry;
    private ConstantListFactory m_constantListFactory;

    public PropertyRegistry(PropertyInspector propertyInspector, SuperDesignCockpit superDesignCockpit) {
        this.m_propertyInspector = propertyInspector;
        this.m_superDesignCockpit = superDesignCockpit;
        this.m_rendererRegistry = this.m_propertyInspector.getRendererRegistry();
        this.m_editorRegistry = this.m_propertyInspector.getEditorRegistry();
        this.m_constantListFactory = new ConstantListFactory(superDesignCockpit.getMetadataDispenser());
        this.registerRenderers();
        this.registerEditors();
        this.m_propertyInspector.initialize();
    }

    private void registerRenderers() {
        this.m_rendererRegistry.register("boolean", (PropertyRendererInterface)new DCBooleanRenderer());
        this.m_rendererRegistry.register("-default-", (PropertyRendererInterface)new StringRenderer());
    }

    public void registerColorRenderer(String sConstants) {
        String sRendererName = "java.awt.Color-" + sConstants;
        PropertyRendererInterface propertyRendererInterface = this.m_rendererRegistry.get(sRendererName);
        if (propertyRendererInterface == null) {
            this.m_rendererRegistry.register(sRendererName, (PropertyRendererInterface)new ColorPropertyValueRenderer(this.m_superDesignCockpit, sConstants));
        }
    }

    private void registerEditors() {
        this.m_editorRegistry.register("int", (PropertyValueEditorInterface)new MyIntegerEditor());
        this.m_editorRegistry.register("boolean", (PropertyValueEditorInterface)new BooleanEditor());
        this.m_editorRegistry.register("-default-", (PropertyValueEditorInterface)new MyStringEditor());
    }

    private void registerConstantListEditor(String sName, ArrayList list) {
        String name = "ConstantList-" + sName;
        if (this.m_editorRegistry.get(name) == null) {
            DynamicListEditor baseStringListEditor = new DynamicListEditor(list);
            baseStringListEditor.initialized();
            this.m_editorRegistry.register(name, (PropertyValueEditorInterface)baseStringListEditor);
        }
    }

    private void registerDataSourceList(String sName, ArrayList list) {
        String name = sName;
        if (this.m_editorRegistry.get(name) == null) {
            ObjecReferenceListEditor baseDatasourceList = new ObjecReferenceListEditor(false, list);
            baseDatasourceList.initialized();
            this.m_editorRegistry.register(name, (PropertyValueEditorInterface)baseDatasourceList);
        }
    }

    private void registerConstantListColorEditor(String sName, ArrayList list) {
        String name = "ConstantList-" + sName;
        if (this.m_editorRegistry.get(name) == null) {
            ArrayList<Icon> icons = new ArrayList<Icon>();
            for (int iItem = 0; iItem < list.size(); ++iItem) {
                StringEntry se = (StringEntry)list.get(iItem);
                icons.add((Icon)new ColorIcon(this.getItemColor(sName, se.getTranslatedName())));
            }
            DynamicListEditor baseStringListEditor = new DynamicListEditor(false, list, icons);
            baseStringListEditor.initialized();
            this.m_editorRegistry.register(name, (PropertyValueEditorInterface)baseStringListEditor);
        }
    }

    public PropertyRendererInterface getRenderer(String sType, String sConstants) {
        PropertyRendererInterface renderer;
        if (sType.equals("java.awt.Color") && sConstants != null) {
            this.registerColorRenderer(sConstants);
            sType = sType + "-" + sConstants;
        }
        if ((renderer = this.m_rendererRegistry.get(sType)) == null) {
            renderer = this.m_rendererRegistry.get("-default-");
        }
        return renderer;
    }

    public PropertyValueEditorInterface getEditor(String sType, String sConstants) {
        boolean bIsdbTables;
        boolean bIsDataSource = sType.equalsIgnoreCase("DataSource");
        boolean bIsdbField = sType.equalsIgnoreCase("FieldName") || sType.equalsIgnoreCase("OrderByField");
        boolean bl = bIsdbTables = sType.equalsIgnoreCase("dbTables");
        if (sConstants != null) {
            boolean bIsColor = sType.equals("java.awt.Color");
            sType = "ConstantList-" + sConstants;
            ArrayList constantList = this.m_constantListFactory.getConstantList(sConstants);
            if (bIsColor) {
                this.registerConstantListColorEditor(sConstants, constantList);
            } else {
                this.registerConstantListEditor(sConstants, constantList);
            }
        }
        if (bIsDataSource) {
            sConstants = sType = "-ObjReferenceList-" + sType;
            ArrayList constantList = this.m_constantListFactory.getConstantList(sConstants);
            this.registerDataSourceList(sConstants, constantList);
        } else if (bIsdbTables) {
            sConstants = sType = "-dbFieldNameList-" + sType;
            ArrayList constantTableList = this.m_constantListFactory.getConstantList(sConstants);
            this.registerDataSourceList(sConstants, constantTableList);
        } else if (bIsdbField) {
            sConstants = sType = "-dbFieldNameList-" + sType;
            ArrayList constantList = this.m_constantListFactory.getConstantList(sConstants);
            this.registerDataSourceList(sConstants, constantList);
        }
        PropertyValueEditorInterface editor = this.m_editorRegistry.get(sType);
        if (editor == null) {
            editor = this.m_editorRegistry.get("-default-");
        }
        return editor;
    }

    Color getItemColor(String sConstantGroup, String avalue) {
        Object theResolvedValue = null;
        MetadataDispenser metadataDispenser = this.m_superDesignCockpit.theMetadataDispenser;
        MetaConstantGroupCollection theConstantTableGroup = metadataDispenser.findConstantGroupCollection(sConstantGroup);
        String nv = theConstantTableGroup.get(avalue);
        try {
            HammerClassCustomLoader loader = this.m_superDesignCockpit.getClassLoader().getLoader();
            theResolvedValue = MetaConstantGroup.resolve((Object)nv, (MetadataDispenser)metadataDispenser, (ClassLoader)loader);
        }
        catch (HammerException e) {
            e.printStackTrace();
        }
        return (Color)theResolvedValue;
    }

    public PropertyEditorRegistry getEditorRegistry() {
        return this.m_editorRegistry;
    }
}

