/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarModifier {
    private final File jarName;
    private HashSet existingFiles = null;
    private File tempJarName = null;

    public JarModifier(File jarName, File tempJarName) throws IOException {
        this.jarName = jarName;
        this.existingFiles = new HashSet();
        this.tempJarName = tempJarName != null ? tempJarName : File.createTempFile("ADC", ".jar");
    }

    public static void main(String[] args) throws IOException {
        String jarName = args[0];
        JarModifier jarModifier = new JarModifier(new File("C:\\AbaJava\\v2005_cdnew\\aba\\java\\jars\\abalib.jar"), null);
        jarModifier.replaceFile(new File("ch/abacus/lib/ui/renderer/deploy/metadata.meta"), new File("c:\\metadata.meta"));
    }

    private void showFilesInJar(ArrayList files) {
        for (String sFile : files) {
            System.out.println(sFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeJar(String jarName, String[] args) throws IOException {
        JarOutputStream jar = new JarOutputStream((OutputStream)new FileOutputStream(jarName), new Manifest());
        System.out.println(jarName + " created.");
        try {
            byte[] buffer = new byte[1024];
            for (int i = 1; i < args.length; ++i) {
                String fileName = args[i];
                try {
                    FileInputStream file = new FileInputStream(fileName);
                    try {
                        int bytesRead;
                        JarEntry entry = new JarEntry(fileName);
                        jar.putNextEntry(entry);
                        while ((bytesRead = file.read(buffer)) != -1) {
                            jar.write(buffer, 0, bytesRead);
                        }
                        System.out.println(entry.getName() + " added.");
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        continue;
                    }
                    finally {
                        file.close();
                    }
                }
                catch (IOException io) {
                    System.out.println(io.getMessage());
                }
            }
        }
        finally {
            jar.close();
            System.out.println(jarName + " closed.");
        }
    }

    private static void displayJarContents(String sJarName, String[] args) throws IOException {
        JarInputStream jar = new JarInputStream(new FileInputStream(sJarName));
        System.out.println(sJarName + " found.");
        JarEntry jarEntry = jar.getNextJarEntry();
        while (jarEntry != null) {
            System.out.println(jarEntry.getName());
            jarEntry = jar.getNextJarEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSingleFileToJar() throws IOException {
        String jarName = "bigjar.jar";
        String fileName = "log.txt";
        JarOutputStream jar = new JarOutputStream((OutputStream)new FileOutputStream(jarName), new Manifest());
        System.out.println(jarName + " created.");
        try {
            JarEntry entry = new JarEntry("crap/bollox/dog/log.txt");
            jar.putNextEntry(entry);
            for (int i = 0; i < 500; ++i) {
                String s = "Line " + (i + 1) + "\r\n";
                byte[] buffer = s.getBytes();
                jar.write(buffer);
            }
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
        finally {
            jar.close();
            System.out.println(jarName + " closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFileFromJar() throws IOException {
        String jarName = "bigjar.jar";
        String fileName = "log.txt";
        JarInputStream jar = new JarInputStream(new FileInputStream(jarName));
        System.out.println(jarName + " created.");
        String sText = "";
        try {
            int bytesRead;
            byte[] buffer = new byte[1024];
            JarEntry entry = jar.getNextJarEntry();
            while ((bytesRead = jar.read(buffer)) != -1) {
                sText = sText + new String(buffer, 0, bytesRead);
            }
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
        finally {
            jar.close();
            System.out.println(jarName + " closed.");
            System.out.println(sText);
        }
    }

    private ArrayList getListOfFilesInJar(File jarName) throws IOException {
        ArrayList<String> filesList = new ArrayList<String>();
        JarInputStream jar = new JarInputStream(new FileInputStream(jarName));
        JarEntry jarEntry = jar.getNextJarEntry();
        while (jarEntry != null) {
            filesList.add(jarEntry.getName());
            jarEntry = jar.getNextJarEntry();
        }
        return filesList;
    }

    private void copyJarEntry(JarInputStream jarInputStream, JarOutputStream jarOutputStream, JarEntry jarEntryInput) throws IOException {
        if (this.shouldCopyFile(new File(jarEntryInput.getName()))) {
            int bytesRead;
            JarEntry jarEntryOutput = new JarEntry(jarEntryInput.getName());
            jarEntryOutput.setTime(jarEntryInput.getTime());
            jarOutputStream.putNextEntry(jarEntryOutput);
            byte[] buffer = new byte[1024];
            while ((bytesRead = jarInputStream.read(buffer)) != -1) {
                jarOutputStream.write(buffer, 0, bytesRead);
            }
        }
    }

    private boolean shouldCopyFile(File file) {
        return !this.existingFiles.contains(file.getPath());
    }

    public void replaceFile(File fileToReplace, File newFile) throws IOException {
        this.performReplaceFileErrorChecking(newFile);
        this.existingFiles.clear();
        this.existingFiles.add(fileToReplace.getPath());
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(this.jarName));
        Manifest manifest = jarInputStream.getManifest();
        JarOutputStream jarOutputStream = manifest != null ? new JarOutputStream((OutputStream)new FileOutputStream(this.tempJarName), manifest) : new JarOutputStream(new FileOutputStream(this.tempJarName));
        JarEntry jarEntryInput = jarInputStream.getNextJarEntry();
        while (jarEntryInput != null) {
            this.copyJarEntry(jarInputStream, jarOutputStream, jarEntryInput);
            jarEntryInput = jarInputStream.getNextJarEntry();
        }
        this.addFile(newFile, fileToReplace.getPath(), jarOutputStream);
        jarInputStream.close();
        jarOutputStream.close();
        boolean bDeleted = this.jarName.delete();
        if (bDeleted) {
            boolean bMoved = this.tempJarName.renameTo(this.jarName);
        }
    }

    private void performReplaceFileErrorChecking(File newFile) throws IOException {
        if (!newFile.exists()) {
            throw new FileNotFoundException("(" + newFile.getPath() + ")");
        }
        if (!this.jarName.exists()) {
            throw new FileNotFoundException("(" + this.jarName.getPath() + ")");
        }
    }

    private void addFile(File newFile, String sFilename, JarOutputStream jarOutputStream) throws IOException {
        int bytesRead;
        sFilename = this.convertBackslashesToSlashes(sFilename);
        FileInputStream fis = new FileInputStream(newFile);
        JarEntry jarEntryOutput = new JarEntry(sFilename);
        jarOutputStream.putNextEntry(jarEntryOutput);
        byte[] buffer = new byte[1024];
        while ((bytesRead = fis.read(buffer)) != -1) {
            jarOutputStream.write(buffer, 0, bytesRead);
        }
        fis.close();
        jarOutputStream.closeEntry();
    }

    private String convertBackslashesToSlashes(String sSource) {
        char[] c = sSource.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != '\\') continue;
            c[i] = 47;
        }
        return new String(c);
    }
}

