/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.metadataEditor.ClassPropertiesPage;
import ch.abacus.designcockpit.metadataEditor.ManageClassPageAttributes;
import ch.abacus.designcockpit.metadataEditor.MetadataEditor;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JADialog;
import ch.abacus.lib.ui.JAFrame;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JATabbedPane;
import ch.abacus.lib.ui.JATextArea;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

public class ManageClassDialog
extends JADialog {
    final MetadataEditor theEditor;
    ManageClassPageAttributes pageAttributes;
    private TableModel theModel;
    protected MetaClass theClass;
    private boolean dialogModified = false;
    JATextArea txtComments = new JATextArea();

    public ManageClassDialog(MetadataEditor editor, MetaClass metaClass) {
        super((JAFrame)editor, "Manage Class: " + metaClass.getMetadata().sClassName, true, false);
        this.theEditor = editor;
        this.theClass = metaClass;
        this.initDisplay("Class \"" + metaClass.getMetadata().sClassName + "\"");
        this.populateDisplay();
    }

    public boolean isDialogModified() {
        return this.dialogModified;
    }

    private void populateDisplay() {
        this.txtComments.setText(this.theClass.getMetadata().sClassComment);
    }

    private void initDisplay(String sCaption) {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JATabbedPane tabbedPane = new JATabbedPane();
        this.pageAttributes = new ManageClassPageAttributes(this, this.theClass);
        ClassPropertiesPage pageProperties = new ClassPropertiesPage(this, this.theClass.getMetadata());
        JAPanel pageComments = new JAPanel((LayoutManager)new BorderLayout());
        pageComments.add((Component)new JScrollPane((Component)this.txtComments), (Object)"Center");
        tabbedPane.add("Attributes", (Component)((Object)this.pageAttributes));
        tabbedPane.add("Properties", (Component)((Object)pageProperties));
        tabbedPane.add("Comments", (Component)pageComments);
        pane.add((Component)tabbedPane, "Center");
        JAPanel pnlDialogButtons = new JAPanel((LayoutManager)new FlowLayout(2, 5, 5));
        JAButton btnOK = new JAButton("OK");
        btnOK.addActionListener((ActionListener)new OkAction(this));
        pnlDialogButtons.add((Component)btnOK);
        pane.add((Component)pnlDialogButtons, "South");
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
            }
        });
    }

    class OkAction
    implements ActionListener {
        private final ManageClassDialog dialog;

        public OkAction(ManageClassDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            ManageClassDialog.this.dialogModified = true;
            this.dialog.theEditor.setMetadataModified(true);
            ManageClassDialog.this.pageAttributes.commitAttributes();
            String sComments = ManageClassDialog.this.txtComments.getText();
            if (sComments.equals("")) {
                sComments = null;
            }
            ManageClassDialog.this.theClass.getMetadata().sClassComment = sComments;
            this.dialog.hide();
        }
    }

    class CancelAction
    implements ActionListener {
        private final ManageClassDialog dialog;

        public CancelAction(ManageClassDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            ManageClassDialog.this.hide();
        }
    }
}

