/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.metadataEditor.MetadataEditor;
import ch.abacus.designcockpit.metadataEditor.MetadataEditorPageConstantCollections;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JAList;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class ManageCollectionGroupsDialog
extends JDialog {
    final MetadataEditor theEditor;
    JAList lstGroups = new JAList();
    MetaConstantGroupCollection theCollection;

    public ManageCollectionGroupsDialog(MetadataEditorPageConstantCollections pageCollections, MetaConstantGroupCollection collection, String sCaption, String sCollectionTitle) {
        super((Frame)((Object)pageCollections.editor), sCaption, true);
        this.theEditor = pageCollections.editor;
        this.theCollection = collection;
        this.initDisplay(sCollectionTitle);
        this.populateDisplay();
    }

    private void initDisplay(String sCaption) {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JAPanel pnlGroups = new JAPanel((LayoutManager)new BorderLayout());
        pnlGroups.setBorder((Border)BorderFactory.createTitledBorder(sCaption));
        pnlGroups.add((Component)new JScrollPane((Component)this.lstGroups), (Object)"Center");
        pane.add((Component)pnlGroups, "Center");
        JAPanel pnlDialogButtons = new JAPanel((LayoutManager)new FlowLayout(2, 5, 5));
        JAButton btnOK = new JAButton("OK");
        JAButton btnCancel = new JAButton("Cancel");
        btnOK.addActionListener((ActionListener)new OkAction(this));
        btnCancel.addActionListener((ActionListener)new CancelAction(this));
        pnlDialogButtons.add((Component)btnOK);
        pnlDialogButtons.add((Component)btnCancel);
        pane.add((Component)pnlDialogButtons, "South");
        this.setSize(400, 300);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CancelAction cancelAction = new CancelAction(ManageCollectionGroupsDialog.this);
                cancelAction.actionPerformed(new ActionEvent(this, 0, ""));
            }
        });
    }

    private ArrayList getIncludedGroups() {
        ArrayList<MetaConstantGroup> groups = new ArrayList<MetaConstantGroup>();
        for (int i = 0; i < this.theCollection.getGroupCount(); ++i) {
            groups.add(this.theCollection.getGroup(i));
        }
        return groups;
    }

    private ArrayList getAllGroups() {
        ArrayList<MetaConstantGroup> allGroups = new ArrayList<MetaConstantGroup>();
        MetaConstantGroup group = this.theEditor.theMetadataDispenser.getFirstMetaConstantGroup();
        while (group != null) {
            allGroups.add(group);
            group = group.theNextSibling;
        }
        return allGroups;
    }

    private Object[] getAllGroupNames() {
        ArrayList<String> allGroupNames = new ArrayList<String>();
        MetaConstantGroup group = this.theEditor.theMetadataDispenser.getFirstMetaConstantGroup();
        while (group != null) {
            allGroupNames.add(group.sClassName);
            group = group.theNextSibling;
        }
        return allGroupNames.toArray();
    }

    void populateDisplay() {
        ArrayList allGroups = this.getAllGroups();
        this.lstGroups.setListData(this.getAllGroupNames());
        ArrayList includedGroups = this.getIncludedGroups();
        int[] selectedIndices = new int[includedGroups.size()];
        for (int iSelectedGroup = 0; iSelectedGroup < includedGroups.size(); ++iSelectedGroup) {
            selectedIndices[iSelectedGroup] = allGroups.indexOf(includedGroups.get(iSelectedGroup));
        }
        this.lstGroups.setSelectedIndices(selectedIndices);
    }

    class OkAction
    implements ActionListener {
        private final ManageCollectionGroupsDialog dialog;

        public OkAction(ManageCollectionGroupsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            MetadataDispenser theMetadataDispenser = this.dialog.theEditor.theMetadataDispenser;
            ManageCollectionGroupsDialog.this.theCollection.clearGroups();
            Object[] selectedGroupNames = ManageCollectionGroupsDialog.this.lstGroups.getSelectedValues();
            for (int iSelectedGroup = 0; iSelectedGroup < selectedGroupNames.length; ++iSelectedGroup) {
                String sSelectedGroupName = (String)selectedGroupNames[iSelectedGroup];
                ManageCollectionGroupsDialog.this.theCollection.addGroup(theMetadataDispenser.findConstantGroup(sSelectedGroupName));
            }
            ManageCollectionGroupsDialog.this.theEditor.setMetadataModified(true);
            this.dialog.hide();
        }
    }

    class CancelAction
    implements ActionListener {
        private final ManageCollectionGroupsDialog dialog;

        public CancelAction(ManageCollectionGroupsDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            ManageCollectionGroupsDialog.this.hide();
        }
    }
}

