/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.metadataEditor.ManageClassDialog;
import ch.abacus.designcockpit.metadataEditor.ManageClassesDialog;
import ch.abacus.designcockpit.metadataEditor.MetadataEditor;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.JASplitPane;
import ch.abacus.lib.ui.JATable;
import ch.abacus.lib.ui.JATextArea;
import ch.abacus.lib.ui.JATree;
import ch.abacus.lib.ui.renderer.common.IDEComponentPaletteNode;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class MetadataEditorPageClasses
extends JAPanel {
    final MetadataEditor editor;
    JATree treClasses = null;
    JATable tblDetails;
    JATable tblProperties;
    JATextArea txtComments = null;
    TableModel tableModel = null;
    DefaultTreeModel theTreeModel;
    IDEComponentPaletteNode baseClass = null;

    public MetadataEditorPageClasses(MetadataEditor editor) {
        this.editor = editor;
        this.initInterface();
        this.populateInterface();
    }

    boolean loadClass(MetaClass theFirstClass, IDEComponentPaletteNode thisNode) {
        for (MetaClass currClass = theFirstClass; currClass != null; currClass = currClass.getNextSibling()) {
            IDEComponentPaletteNode theNewNode = new IDEComponentPaletteNode(currClass);
            if (thisNode == null) {
                this.theTreeModel.insertNodeInto((MutableTreeNode)theNewNode, (MutableTreeNode)this.baseClass, this.baseClass.getChildCount());
            } else {
                this.theTreeModel.insertNodeInto((MutableTreeNode)theNewNode, (MutableTreeNode)thisNode, thisNode.getChildCount());
            }
            if (currClass.getFirstClass() == null) continue;
            this.loadClass(currClass.getFirstClass(), theNewNode);
        }
        return true;
    }

    private void populateInterface() {
        MetaClass theFirstClass = this.editor.theMetadataDispenser.getFirstClass();
        this.baseClass = new IDEComponentPaletteNode(theFirstClass);
        this.theTreeModel = new DefaultTreeModel((TreeNode)this.baseClass);
        this.treClasses.setModel((TreeModel)this.theTreeModel);
        this.loadClass(theFirstClass.getFirstClass(), this.baseClass);
        this.treClasses.expandRow(0);
        this.treClasses.setSelectionRow(0);
        IDEComponentPaletteNode node = (IDEComponentPaletteNode)this.treClasses.getLastSelectedPathComponent();
        if (node != null) {
            this.showClassAttributes(node.getMetaClass());
        }
    }

    private void initInterface() {
        this.setLayout(new BorderLayout());
        JAPanel pnlClass = new JAPanel((LayoutManager)new BorderLayout());
        JAPanel pnlNonVisibleClass = new JAPanel((LayoutManager)new BorderLayout());
        this.treClasses = new JATree();
        JAPanel pnlClasses = new JAPanel((LayoutManager)new BorderLayout());
        JAPanel pnlClassAttributes = new JAPanel((LayoutManager)new BorderLayout());
        pnlClasses.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        pnlClassAttributes.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        JASplitPane splitPane = new JASplitPane(1, (Component)pnlClasses, (Component)pnlClassAttributes);
        splitPane.setDividerLocation(200);
        JAPanel grpDetails = new JAPanel();
        grpDetails.setBorder((Border)BorderFactory.createTitledBorder("Details"));
        grpDetails.setLayout((LayoutManager)new GridLayout(1, 1, 10, 10));
        this.tblDetails = new JATable(12, 2);
        this.tblDetails.setSelectionMode(0);
        grpDetails.add((Component)this.tblDetails);
        this.tblDetails.setTableHeader(null);
        JAPanel grpComments = new JAPanel();
        grpComments.setBorder((Border)BorderFactory.createTitledBorder("Comments"));
        grpComments.setLayout((LayoutManager)new GridLayout(1, 1, 10, 10));
        this.txtComments = new JATextArea(5, 30);
        grpComments.add((Component)new JAScrollPane((Component)this.txtComments));
        pnlNonVisibleClass.add((Component)grpDetails, (Object)"North");
        pnlNonVisibleClass.add((Component)grpComments, (Object)"South");
        pnlClass.add((Component)pnlNonVisibleClass, (Object)"North");
        JAPanel grpProperties = new JAPanel();
        grpProperties.setBorder((Border)BorderFactory.createTitledBorder("Properties"));
        grpProperties.setLayout((LayoutManager)new GridLayout(1, 1, 10, 10));
        this.tblProperties = new JATable();
        this.tblProperties.setSelectionMode(0);
        grpProperties.add((Component)new JScrollPane((Component)this.tblProperties));
        pnlClass.add((Component)grpProperties, (Object)"Center");
        Dimension minimumSize = new Dimension(100, 50);
        pnlClasses.setMinimumSize(minimumSize);
        pnlClassAttributes.setMinimumSize(minimumSize);
        JALabel lblClasses = new JALabel("Classes");
        pnlClasses.add((Component)lblClasses, (Object)"North");
        pnlClasses.add((Component)new JScrollPane((Component)this.treClasses), (Object)"Center");
        JAPanel pnlButtonsClass = new JAPanel((LayoutManager)new FlowLayout(0, 0, 5));
        JAButton btnModifyClasses = new JAButton("Modify Classes");
        btnModifyClasses.addActionListener((ActionListener)new ModifyClassesAction(this));
        pnlButtonsClass.add((Component)btnModifyClasses);
        pnlClasses.add((Component)pnlButtonsClass, (Object)"South");
        JALabel lblClassAttribytes = new JALabel("Class Attributes");
        pnlClassAttributes.add((Component)lblClassAttribytes, (Object)"North");
        pnlClassAttributes.add((Component)pnlClass, (Object)"Center");
        JAPanel pnlButtons = new JAPanel((LayoutManager)new FlowLayout(0, 0, 5));
        JAButton btnModifyClass = new JAButton("Modify Class");
        btnModifyClass.addActionListener((ActionListener)new ModifyClassAction(this));
        pnlButtons.add((Component)btnModifyClass);
        pnlClassAttributes.add((Component)pnlButtons, (Object)"South");
        this.add((Component)splitPane);
        this.treClasses.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                IDEComponentPaletteNode node = (IDEComponentPaletteNode)MetadataEditorPageClasses.this.treClasses.getLastSelectedPathComponent();
                if (node != null) {
                    MetadataEditorPageClasses.this.showClassAttributes(node.getMetaClass());
                }
            }
        });
    }

    private void showClassAttributes(MetaClass metaClass) {
        this.tblDetails.setValueAt((Object)"Full Classname", 0, 0);
        this.tblDetails.setValueAt((Object)metaClass.getMetadata().sFullClassName, 0, 1);
        this.tblDetails.setValueAt((Object)"Superclass Name", 1, 0);
        this.tblDetails.setValueAt((Object)metaClass.getMetadata().getSuperClassName(), 1, 1);
        this.tblDetails.setValueAt((Object)"Superclass FullPath", 2, 0);
        this.tblDetails.setValueAt((Object)metaClass.getMetadata().getFullPathOfSuperClass(), 2, 1);
        this.tblDetails.setValueAt((Object)"Display", 3, 0);
        this.tblDetails.setValueAt((Object)metaClass.getMetadata().sDisplayClass, 3, 1);
        this.tblDetails.setValueAt((Object)"Hidden", 4, 0);
        this.tblDetails.setValueAt((Object)new Boolean(metaClass.getMetadata().bHidden), 4, 1);
        this.tblDetails.setValueAt((Object)"SkipDeclarations", 5, 0);
        this.tblDetails.setValueAt((Object)new Boolean(metaClass.getMetadata().bSkipDecl), 5, 1);
        this.tblDetails.setValueAt((Object)"Design Borders", 6, 0);
        this.tblDetails.setValueAt((Object)new Boolean(metaClass.getMetadata().bDesignBorders), 6, 1);
        this.tblDetails.setValueAt((Object)"Skip Default Listeners", 7, 0);
        this.tblDetails.setValueAt((Object)new Boolean(metaClass.getMetadata().bDefaultListeners), 7, 1);
        this.tblDetails.setValueAt((Object)"Container Type", 8, 0);
        this.tblDetails.setValueAt((Object)metaClass.getMetadata().containerType.getContainerTypeAsString(), 8, 1);
        this.tblDetails.setValueAt((Object)"Custom", 9, 0);
        this.tblDetails.setValueAt((Object)metaClass.getMetadata().sCustomCodeGenerationMethod, 9, 1);
        this.tblDetails.setValueAt((Object)"Class Factory", 10, 0);
        this.tblDetails.setValueAt((Object)metaClass.getMetadata().theFactoryName, 10, 1);
        this.tblDetails.setValueAt((Object)"Design Editor", 11, 0);
        this.tblDetails.setValueAt((Object)metaClass.getMetadata().theDesignEditor, 11, 1);
        this.tblDetails.setEnabled(false);
        this.txtComments.setText(metaClass.getMetadata().sClassComment);
        this.txtComments.setCaretPosition(0);
        this.txtComments.setEditable(false);
        this.txtComments.setLineWrap(true);
        this.txtComments.setWrapStyleWord(true);
        this.tableModel = new TableModel(metaClass.getMetadata());
        this.tblProperties.setModel((javax.swing.table.TableModel)this.tableModel);
        this.tblProperties.setAutoResizeMode(3);
    }

    class ModifyClassAction
    implements ActionListener {
        private MetadataEditorPageClasses page;

        public ModifyClassAction(MetadataEditorPageClasses page) {
            this.page = page;
        }

        public void actionPerformed(ActionEvent e) {
            IDEComponentPaletteNode node = (IDEComponentPaletteNode)MetadataEditorPageClasses.this.treClasses.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            final MetaClass metaClass = node.getMetaClass();
            final ManageClassDialog dialog = new ManageClassDialog(this.page.editor, metaClass);
            dialog.show(new Runnable(){

                public void run() {
                    if (dialog.isDialogModified()) {
                        MetadataEditorPageClasses.this.showClassAttributes(metaClass);
                    }
                }
            });
        }
    }

    class ModifyClassesAction
    implements ActionListener {
        private MetadataEditorPageClasses page;

        public ModifyClassesAction(MetadataEditorPageClasses page) {
            this.page = page;
        }

        public void actionPerformed(ActionEvent e) {
            IDEComponentPaletteNode node = (IDEComponentPaletteNode)MetadataEditorPageClasses.this.treClasses.getLastSelectedPathComponent();
            MetaClass metaClass = node.getMetaClass();
            ManageClassesDialog dialog = new ManageClassesDialog(this.page, metaClass);
            dialog.show(new Runnable(){

                public void run() {
                    MetadataEditorPageClasses.this.populateInterface();
                }
            });
        }
    }

    class TableModel
    extends AbstractTableModel {
        private MetaClassDetail theClass;
        private int rowCount;

        public TableModel(MetaClassDetail theClass) {
            this.theClass = theClass;
            this.rowCount = theClass.iNumberOfProperties;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Type";
                }
            }
            return "Default";
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public int getColumnCount() {
            return 3;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            MetaPropertyDescriptor theProperty = this.theClass.theFirstProperty;
            for (int i = 0; i < rowIndex; ++i) {
                theProperty = theProperty.getNextProperty();
            }
            switch (columnIndex) {
                case 0: {
                    return theProperty.getName();
                }
                case 1: {
                    return theProperty.getClassName();
                }
            }
            return theProperty.getDefaultValue();
        }
    }
}

