/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.designcockpit.metadataEditor.MetadataEditor;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.JATextArea;
import ch.abacus.lib.ui.JATextField;
import ch.abacus.lib.ui.renderer.common.MetadataAdministrator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MetadataEditorPageGeneral
extends JAPanel {
    private final MetadataEditor theEditor;
    JSpinner spnVersionNumber = new JSpinner();
    JSpinner spnRevisionNumber = new JSpinner();
    JSpinner spnSubrevisionNumber = new JSpinner();
    JSpinner spnBuildNumber = new JSpinner();
    JATextField txtDesignBorderDefinition = new JATextField();
    JATextArea txtComments = new JATextArea();

    public MetadataEditorPageGeneral(MetadataEditor editor) {
        this.theEditor = editor;
        this.initInterface();
        this.populateInterface();
    }

    void populateInterface() {
        MetadataAdministrator admin = this.theEditor.theMetadataDispenser.theMetaDataAdministrator;
        this.spnVersionNumber.setModel(new SpinnerNumberModel(admin.iVersionNumber, 0, 999, 1));
        this.spnRevisionNumber.setModel(new SpinnerNumberModel(admin.iRevisionNumber, 0, 999, 1));
        this.spnSubrevisionNumber.setModel(new SpinnerNumberModel(admin.iSubrevisionNumber, 0, 999, 1));
        this.spnBuildNumber.setModel(new SpinnerNumberModel(admin.iBuildNumber, 0, 999, 1));
        this.txtDesignBorderDefinition.setText(this.theEditor.theMetadataDispenser.sDesignBorderDefinition);
        this.txtComments.setText(this.theEditor.theMetadataDispenser.theMetadataDocument.sDocumentComments);
    }

    void initInterface() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        JAPanel pnlTopNonVisible = new JAPanel((LayoutManager)new BorderLayout());
        JAPanel pnlCenterNonVisible = new JAPanel((LayoutManager)new BorderLayout());
        JAPanel pnlVersion = new JAPanel();
        pnlVersion.setBorder((Border)BorderFactory.createTitledBorder("Version Numbers"));
        JAPanel pnlVersionNumber = new JAPanel();
        JALabel lblVersionNumber = new JALabel("Version");
        this.spnVersionNumber.setPreferredSize(new Dimension(60, 22));
        pnlVersionNumber.add((Component)lblVersionNumber);
        pnlVersionNumber.add((Component)this.spnVersionNumber);
        pnlVersion.add((Component)pnlVersionNumber);
        JAPanel pnlRevisionNumber = new JAPanel();
        JALabel lblRevisionNumber = new JALabel("Revision", 4);
        this.spnRevisionNumber.setPreferredSize(new Dimension(60, 22));
        pnlRevisionNumber.add((Component)lblRevisionNumber);
        pnlRevisionNumber.add((Component)this.spnRevisionNumber);
        pnlVersion.add((Component)pnlRevisionNumber);
        JAPanel pnlSubrevisionNumber = new JAPanel();
        JALabel lblSubrevisionNumber = new JALabel("Subrevision", 4);
        this.spnSubrevisionNumber.setPreferredSize(new Dimension(60, 22));
        pnlSubrevisionNumber.add((Component)lblSubrevisionNumber);
        pnlSubrevisionNumber.add((Component)this.spnSubrevisionNumber);
        pnlVersion.add((Component)pnlSubrevisionNumber);
        JAPanel pnlBuildNumber = new JAPanel();
        JALabel lblBuildNumber = new JALabel("Build", 4);
        this.spnBuildNumber.setPreferredSize(new Dimension(60, 22));
        pnlBuildNumber.add((Component)lblBuildNumber);
        pnlBuildNumber.add((Component)this.spnBuildNumber);
        pnlVersion.add((Component)pnlBuildNumber);
        JAPanel pnlDesignBorderDefinition = new JAPanel((LayoutManager)new BorderLayout());
        pnlDesignBorderDefinition.setBorder((Border)BorderFactory.createTitledBorder("Design-Border Definition"));
        JAPanel pnlComments = new JAPanel((LayoutManager)new BorderLayout());
        pnlComments.setBorder((Border)BorderFactory.createTitledBorder("Comments"));
        pnlComments.add((Component)new JAScrollPane((Component)this.txtComments), (Object)"Center");
        pnlDesignBorderDefinition.add((Component)this.txtDesignBorderDefinition, (Object)"North");
        pnlTopNonVisible.add((Component)pnlVersion, (Object)"North");
        pnlTopNonVisible.add((Component)pnlDesignBorderDefinition, (Object)"Center");
        pnlCenterNonVisible.add((Component)pnlComments, (Object)"Center");
        this.add((Component)pnlTopNonVisible, "North");
        this.add((Component)pnlCenterNonVisible, "Center");
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                MetadataEditorPageGeneral.this.theEditor.setMetadataModified(true);
            }

            public void insertUpdate(DocumentEvent e) {
                if (MetadataEditorPageGeneral.this.theEditor.isVisible()) {
                    MetadataEditorPageGeneral.this.theEditor.setMetadataModified(true);
                }
            }

            public void removeUpdate(DocumentEvent e) {
                MetadataEditorPageGeneral.this.theEditor.setMetadataModified(true);
            }
        };
        this.txtComments.getDocument().addDocumentListener(documentListener);
        this.txtDesignBorderDefinition.getDocument().addDocumentListener(documentListener);
    }

    public void save() {
        int iVersionNumber = (Integer)this.spnVersionNumber.getValue();
        int iRevisionNumber = (Integer)this.spnRevisionNumber.getValue();
        int iSubrevisionNumber = (Integer)this.spnSubrevisionNumber.getValue();
        int iBuildNumber = (Integer)this.spnBuildNumber.getValue();
        String sDesignBorderDefinition = this.txtDesignBorderDefinition.getText();
        this.theEditor.theMetadataDispenser.theMetaDataAdministrator.iVersionNumber = iVersionNumber;
        this.theEditor.theMetadataDispenser.theMetaDataAdministrator.iRevisionNumber = iRevisionNumber;
        this.theEditor.theMetadataDispenser.theMetaDataAdministrator.iSubrevisionNumber = iSubrevisionNumber;
        this.theEditor.theMetadataDispenser.theMetaDataAdministrator.iBuildNumber = iBuildNumber;
        this.theEditor.theMetadataDispenser.sDesignBorderDefinition = sDesignBorderDefinition;
        String sComments = this.txtComments.getText();
        if (sComments.length() == 0) {
            sComments = null;
        }
        this.theEditor.theMetadataDispenser.theMetadataDocument.sDocumentComments = sComments;
    }
}

