/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.lang;

import java.util.Iterator;
import java.util.Locale;

public class Language {
    public static final int GERMAN_ID = 0;
    public static final int FRENCH_ID = 1;
    public static final int ITALIAN_ID = 2;
    public static final int ENGLISH_ID = 3;
    public static final int SPANISH_ID = 4;
    public static final String GERMAN_ISOCODE = "de";
    public static final String FRENCH_ISOCODE = "fr";
    public static final String ITALIAN_ISOCODE = "it";
    public static final String ENGLISH_ISOCODE = "en";
    public static final String SPANISH_ISOCODE = "es";
    public static final char GERMAN_CHAR = 'D';
    public static final char FRENCH_CHAR = 'F';
    public static final char ITALIAN_CHAR = 'I';
    public static final char ENGLISH_CHAR = 'E';
    public static final char SPANISH_CHAR = 'S';
    public static final String GERMAN_CHAR_STRING = "D";
    public static final String FRENCH_CHAR_STRING = "F";
    public static final String ITALIAN_CHAR_STRING = "I";
    public static final String ENGLISH_CHAR_STRING = "E";
    public static final String SPANISH_CHAR_STRING = "S";
    public static final Language DE = new Language(0);
    public static final Language FR = new Language(1);
    public static final Language IT = new Language(2);
    public static final Language EN = new Language(3);
    public static final Language ES = new Language(4);
    private static final Language[] ALL = new Language[]{DE, FR, IT, EN, ES};
    private static final String[] ISO_CODES = new String[]{"de", "fr", "it", "en", "es"};
    private static final char[] CHARS = new char[]{'D', 'F', 'I', 'E', 'S'};
    private static final String[] CHAR_STRINGS = new String[]{"D", "F", "I", "E", "S"};
    private static final Locale[] LOCALES = new Locale[]{Locale.GERMAN, Locale.FRENCH, Locale.ITALIAN, Locale.ENGLISH, new Locale(ISO_CODES[4])};
    private int mLanguageNr;

    private Language(int nLanguageId) {
        this.mLanguageNr = nLanguageId;
    }

    public boolean equals(Object other) {
        return this.mLanguageNr == ((Language)other).mLanguageNr;
    }

    public String toString() {
        return this.getISOCode();
    }

    public int getId() {
        return this.mLanguageNr;
    }

    public String getISOCode() {
        return ISO_CODES[this.mLanguageNr];
    }

    public char getCharacter() {
        return CHARS[this.mLanguageNr];
    }

    public String getCharString() {
        return CHAR_STRINGS[this.mLanguageNr];
    }

    public Locale getLocale() {
        return LOCALES[this.mLanguageNr];
    }

    public static Language fromISOCode(String isoCode) {
        return Language.fromISOCode(isoCode, DE);
    }

    public static Language fromNr(int nr) {
        return Language.fromNr(nr, DE);
    }

    public static Language fromChar(char ch) {
        return Language.fromChar(ch, DE);
    }

    public static Language fromChar(char ch, Language defaultLanguage) {
        for (int i = 0; i < CHARS.length; ++i) {
            if (CHARS[i] != ch) continue;
            return ALL[i];
        }
        return defaultLanguage;
    }

    public static Language fromISOCode(String isoCode, Language defaultLanguage) {
        for (int i = 0; i < ISO_CODES.length; ++i) {
            if (!ISO_CODES[i].equals(isoCode)) continue;
            return ALL[i];
        }
        return defaultLanguage;
    }

    public static final Iterator iterator() {
        return new Iterator(){
            private int counter = 0;

            public boolean hasNext() {
                return this.counter < ALL.length;
            }

            public Object next() {
                return this.counter < ALL.length ? ALL[this.counter++] : null;
            }

            public void remove() {
            }
        };
    }

    public static Language fromNr(int nr, Language defaultLanguage) {
        if (nr < 0 || nr >= ALL.length) {
            return defaultLanguage;
        }
        return ALL[nr];
    }

    public static void main(String[] args) {
        System.out.println("---- Language ----");
        for (int i = 0; i < ALL.length; ++i) {
            Language language = ALL[i];
            System.out.println(language.getId() + ", " + language.getISOCode() + ", " + language.getCharacter());
            for (int il = 0; il < ALL.length; ++il) {
            }
        }
        Language language = DE;
        System.out.println(language.getId() + ", " + language.getISOCode() + ", " + language.getCharacter());
        language = FR;
        System.out.println(language.getId() + ", " + language.getISOCode() + ", " + language.getCharacter());
        language = IT;
        System.out.println(language.getId() + ", " + language.getISOCode() + ", " + language.getCharacter());
        language = EN;
        System.out.println(language.getId() + ", " + language.getISOCode() + ", " + language.getCharacter());
        language = ES;
        System.out.println(language.getId() + ", " + language.getISOCode() + ", " + language.getCharacter());
    }
}

