/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui;

import ch.abacus.lib.ui.JATree;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DNDTree
extends JATree
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private DropTarget dropTarget = null;
    private DragSource dragSource = null;
    protected DefaultMutableTreeNode fromNode = null;
    protected DefaultMutableTreeNode dropnode = null;
    private DefaultTreeModel treemodel = null;

    public DNDTree(TreeModel model) {
        super(model);
        this.treemodel = (DefaultTreeModel)model;
        this.dropTarget = new DropTarget(this, this);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
    }

    public void dragEnter(DropTargetDragEvent event) {
        event.acceptDrag(2);
    }

    public void dragExit(DropTargetEvent event) {
    }

    public void dragOver(DropTargetDragEvent event) {
    }

    public void drop(DropTargetDropEvent event) {
        try {
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                event.acceptDrop(2);
                String s = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                Object occur = event.getSource();
                Point droppoint = event.getLocation();
                TreePath droppath = this.getClosestPathForLocation(droppoint.x, droppoint.y);
                this.dropnode = (DefaultMutableTreeNode)droppath.getLastPathComponent();
                event.getDropTargetContext().dropComplete(true);
            } else {
                event.rejectDrop();
            }
        }
        catch (IOException exception) {
            event.rejectDrop();
        }
        catch (UnsupportedFlavorException ufException) {
            event.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent event) {
    }

    public void dragGestureRecognized(DragGestureEvent event) {
        TreePath selected;
        this.fromNode = null;
        this.dropnode = null;
        TreePath treepath = selected = this.getSelectionPath();
        this.fromNode = (DefaultMutableTreeNode)treepath.getLastPathComponent();
        if (selected != null) {
            Cursor cursor = this.selectCursor(event.getDragAction());
            StringSelection text = new StringSelection(((Object)selected).toString());
            this.dragSource.startDrag(event, cursor, text, this);
        }
    }

    private Cursor selectCursor(int action) {
        return action == 2 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop;
    }

    public void dragDropEnd(DragSourceDropEvent event) {
        if (event.getDropSuccess()) {
            try {
                if (this.dropnode.equals(this.fromNode)) {
                    System.out.println("drag==drop");
                    throw new IllegalArgumentException("the source is the same as the destination");
                }
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.dropnode.getParent();
                int i = parent.getIndex(this.dropnode);
                parent.insert(this.fromNode, i);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException(iae.toString());
            }
            this.treemodel.reload();
        }
    }

    public void dragEnter(DragSourceDragEvent event) {
    }

    public void dragExit(DragSourceEvent event) {
    }

    public void dragOver(DragSourceDragEvent event) {
    }

    public void dropActionChanged(DragSourceDragEvent event) {
    }
}

