/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.layout;

import ch.abacus.lib.ui.layout.Anchoring;
import ch.abacus.lib.ui.layout.AnchoringComponent;
import ch.abacus.lib.ui.layout.CustomScaleableInterface;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;

public class AnchoringLayoutManager
implements LayoutManager2 {
    AnchoringComponent firstAnchoringComponent = null;
    AnchoringComponent lastAnchoringComponent = null;
    private static final int PREFERRED = 0;
    private static final int MINIMUM = 1;
    private static final int DEFAULT_SCALE = 1000;
    public int width;
    public int height;
    public int scale = 1000;

    public AnchoringLayoutManager() {
        this.width = -1;
        this.height = -1;
    }

    public AnchoringLayoutManager(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public AnchoringComponent findAnchoringComponent(Component comp) {
        AnchoringComponent theAnchoringComponent = this.firstAnchoringComponent;
        while (theAnchoringComponent != null && !theAnchoringComponent.component.equals(comp)) {
            theAnchoringComponent = theAnchoringComponent.nextAnchoringComponent;
        }
        return theAnchoringComponent;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void addLayoutComponent(String name, Component comp) {
        Anchoring theAnchoring;
        AnchoringComponent theMatch = this.findAnchoringComponent(comp);
        boolean bNewComponent = false;
        if (theMatch == null) {
            theMatch = new AnchoringComponent();
            bNewComponent = true;
        }
        theMatch.anchoring = theAnchoring = new Anchoring(false, false, false, false);
        theMatch.name = new String(name);
        theMatch.component = comp;
        theMatch.scale = this.scale;
        if (bNewComponent) {
            if (this.firstAnchoringComponent == null) {
                this.firstAnchoringComponent = theMatch;
            } else {
                this.lastAnchoringComponent.nextAnchoringComponent = theMatch;
            }
            theMatch.prevAnchoringComponent = this.lastAnchoringComponent;
            this.lastAnchoringComponent = theMatch;
        }
    }

    public void addLayoutComponent(Component comp, Object name) {
        if (name == null) {
            name = comp.getName();
        }
        if (!(name instanceof String)) {
            throw new IllegalArgumentException("cannot add component " + comp.toString() + " to anchoring layout: must pass component and name (a string)");
        }
        this.addLayoutComponent((String)name, comp);
    }

    public void setAnchoring(Component comp, boolean left, boolean right, boolean top, boolean bottom) {
        AnchoringComponent theComponent = this.findAnchoringComponent(comp);
        if (theComponent != null) {
            Anchoring theAnchoring;
            theComponent.anchoring = theAnchoring = new Anchoring(left, right, top, bottom);
        } else {
            String sName = comp.getName();
            if (sName != null) {
                this.addLayoutComponent(comp.getName(), comp);
                theComponent = this.findAnchoringComponent(comp);
                theComponent.anchoring = new Anchoring(left, right, top, bottom);
            }
        }
    }

    public void setAnchoring(Component comp, int iAnchoring) {
        AnchoringComponent theComponent = this.findAnchoringComponent(comp);
        if (theComponent != null) {
            Anchoring theAnchoring;
            theComponent.anchoring = theAnchoring = new Anchoring(iAnchoring);
        } else {
            String sName = comp.getName();
            if (sName != null) {
                this.addLayoutComponent(comp.getName(), comp);
                theComponent = this.findAnchoringComponent(comp);
                theComponent.anchoring = new Anchoring(iAnchoring);
            }
        }
    }

    public void removeLayoutComponent(Component comp) {
        AnchoringComponent theComponent = this.findAnchoringComponent(comp);
        if (theComponent != null) {
            if (theComponent.equals(this.firstAnchoringComponent)) {
                this.firstAnchoringComponent = theComponent.nextAnchoringComponent;
                if (this.firstAnchoringComponent != null) {
                    this.firstAnchoringComponent.prevAnchoringComponent = null;
                }
            }
            if (theComponent.equals(this.lastAnchoringComponent)) {
                this.lastAnchoringComponent = theComponent.prevAnchoringComponent;
                if (this.lastAnchoringComponent != null) {
                    this.lastAnchoringComponent.nextAnchoringComponent = null;
                }
            }
            if (theComponent.prevAnchoringComponent != null) {
                theComponent.prevAnchoringComponent.nextAnchoringComponent = theComponent.nextAnchoringComponent;
            }
            if (theComponent.nextAnchoringComponent != null) {
                theComponent.nextAnchoringComponent.prevAnchoringComponent = theComponent.prevAnchoringComponent;
            }
        }
    }

    public String getName(Component comp) {
        AnchoringComponent theComponent = this.findAnchoringComponent(comp);
        if (theComponent != null) {
            return theComponent.name;
        }
        return null;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.layoutSize(parent, 1);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.layoutSize(parent, 0);
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public void layoutContainer(Container parent) {
        int iNewScale = this.scale;
        Component[] comps = parent.getComponents();
        Insets insets = parent.getInsets();
        int iHorzInsets = insets.left + insets.right;
        int iVertInsets = insets.top + insets.bottom;
        Dimension dimParentRaw = parent.getSize();
        Dimension dimParent = new Dimension(dimParentRaw.width - iHorzInsets, dimParentRaw.height - iVertInsets);
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            Dimension dimComponent = comp.getSize();
            Dimension dimMinComponent = comp.getMinimumSize();
            Dimension dimMaxComponent = comp.getMaximumSize();
            Point ptLocation = comp.getLocation();
            int x = (int)ptLocation.getX();
            int y = (int)ptLocation.getY();
            int cx = dimComponent.width;
            int cy = dimComponent.height;
            AnchoringComponent theAnchoring = this.findAnchoringComponent(comp);
            if (theAnchoring == null) {
                System.err.println("Cannot find anchoring component for component:  " + comp.toString());
                return;
            }
            if (theAnchoring.anchoring != null) {
                if (theAnchoring.anchoring.anchorInitialized) {
                    if ((theAnchoring.anchoring.anchoring & 4) == 4) {
                        x = theAnchoring.anchoring.anchorLeft;
                        if ((theAnchoring.anchoring.anchoring & 8) == 8) {
                            cx = dimParent.width - (x + theAnchoring.anchoring.anchorRight);
                        }
                    } else if ((theAnchoring.anchoring.anchoring & 8) == 8) {
                        x = dimParent.width - (cx + theAnchoring.anchoring.anchorRight);
                    }
                    if ((theAnchoring.anchoring.anchoring & 1) == 1) {
                        y = theAnchoring.anchoring.anchorTop;
                        if ((theAnchoring.anchoring.anchoring & 2) == 2) {
                            cy = dimParent.height - (y + theAnchoring.anchoring.anchorBottom);
                        }
                    } else if ((theAnchoring.anchoring.anchoring & 2) == 2) {
                        y = dimParent.height - (cy + theAnchoring.anchoring.anchorBottom);
                    }
                } else if (dimParent.width > 0 && dimParent.height > 0) {
                    if ((theAnchoring.anchoring.anchoring & 4) == 4) {
                        theAnchoring.anchoring.anchorLeft = x;
                    }
                    if ((theAnchoring.anchoring.anchoring & 8) == 8) {
                        theAnchoring.anchoring.anchorRight = dimParent.width - (x + dimComponent.width);
                    }
                    if ((theAnchoring.anchoring.anchoring & 1) == 1) {
                        theAnchoring.anchoring.anchorTop = y;
                    }
                    if ((theAnchoring.anchoring.anchoring & 2) == 2) {
                        theAnchoring.anchoring.anchorBottom = dimParent.height - (y + dimComponent.height);
                    }
                    theAnchoring.anchoring.anchorInitialized = true;
                }
            }
            if (cx < dimMinComponent.width) {
                cx = dimMinComponent.width;
            }
            if (cy < dimMinComponent.height) {
                cy = dimMinComponent.height;
            }
            int iMaxWidth = dimMaxComponent.width;
            int iMaxHeight = dimMaxComponent.height;
            if (iMaxWidth != 0 && cx > iMaxWidth) {
                cx = iMaxWidth;
            }
            if (iMaxHeight != 0 && cy > iMaxHeight) {
                cy = iMaxHeight;
            }
            if (iNewScale != theAnchoring.scale) {
                int oldScale = theAnchoring.scale;
                comp.setBounds(x * iNewScale / oldScale, y * iNewScale / oldScale, cx * iNewScale / oldScale, cy * iNewScale / oldScale);
                if (comp instanceof CustomScaleableInterface) {
                    ((CustomScaleableInterface)((Object)comp)).scaleChanged(iNewScale, oldScale);
                } else {
                    Font font = comp.getFont();
                    if (font != null) {
                        Font newFont = new Font(font.getName(), font.getStyle(), font.getSize() * iNewScale / oldScale);
                        comp.setFont(newFont);
                    }
                }
                theAnchoring.scale = iNewScale;
                continue;
            }
            comp.setBounds(x, y, cx, cy);
        }
    }

    protected Dimension layoutSize(Container parent, int iType) {
        int newWidth;
        int newHeight;
        if (this.width == -1 || this.height == -1) {
            newHeight = 0;
            newWidth = 0;
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component comp = comps[i];
                AnchoringComponent theAnchoring = this.findAnchoringComponent(comp);
                Dimension dimComponent = iType == 0 ? comp.getPreferredSize() : comp.getMinimumSize();
                Dimension dimParent = parent.getSize();
                Point pt = comp.getLocation();
                int x = dimComponent.width;
                if (theAnchoring != null) {
                    if ((theAnchoring.anchoring.anchoring & 4) == 4) {
                        x += (int)pt.getX();
                    }
                    if ((theAnchoring.anchoring.anchoring & 8) == 8) {
                        x += (int)((double)dimParent.width - pt.getX() - (double)dimComponent.width);
                    }
                }
                int y = dimComponent.height;
                if (theAnchoring != null) {
                    if ((theAnchoring.anchoring.anchoring & 1) == 1) {
                        y += (int)pt.getY();
                    }
                    if ((theAnchoring.anchoring.anchoring & 2) == 2) {
                        y += (int)((double)dimParent.height - pt.getY() - (double)dimComponent.height);
                    }
                }
                newWidth = Math.max(newWidth, x);
                newHeight = Math.max(newHeight, y);
            }
            if (this.width != -1) {
                newWidth = this.width;
            }
            if (this.height != -1) {
                newHeight = this.height;
            }
        } else {
            newWidth = this.width;
            newHeight = this.height;
        }
        Insets insets = parent.getInsets();
        return new Dimension(newWidth + insets.left + insets.right, newHeight + insets.top + insets.bottom);
    }
}

