/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.plaf.generic;

import ch.abacus.lib.ui.plaf.generic.GenericLookAndFeel;
import ch.abacus.lib.ui.plaf.generic.GenericToggleButtonListener;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class GenericToggleButtonUI
extends BasicToggleButtonUI {
    protected GenericToggleButtonListener mButtonListener = new GenericToggleButtonListener(null);

    public static ComponentUI createUI(JComponent c) {
        return new GenericToggleButtonUI();
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return this.mButtonListener;
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        boolean isIcon;
        Rectangle focusRect = new Rectangle();
        String text = b.getText();
        boolean bl = isIcon = b.getIcon() != null;
        if (text != null && !text.equals("")) {
            if (!isIcon) {
                focusRect.setBounds(textRect);
            } else {
                focusRect.setBounds(iconRect.union(textRect));
            }
        } else if (isIcon) {
            focusRect.setBounds(iconRect);
        }
        g.setColor(GenericLookAndFeel.getDarkGray());
        g.drawRect(focusRect.x - 1, focusRect.y - 1, focusRect.width + 1, focusRect.height + 1);
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        } else {
            g.setColor(GenericLookAndFeel.getDarkGray());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            Dimension size = b.getSize();
            g.setColor(GenericLookAndFeel.getFillDown());
            g.fillRect(0, 0, size.width, size.height);
        }
    }
}

