/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.propertyinspector.display.editor;

import ch.abacus.lib.ui.JAComboBox;
import ch.abacus.lib.ui.propertyinspector.display.editor.BaseEditor;
import ch.abacus.lib.ui.propertyinspector.display.editor.EditorDelegate;
import ch.abacus.lib.ui.propertyinspector.display.editor.EditorValueAccessor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ListCellRenderer;

public abstract class AbstractListEditor
extends BaseEditor
implements EditorValueAccessor {
    protected JAComboBox comboBox;
    private boolean lazyInitialisation;

    public AbstractListEditor(boolean lazyInitialisation) {
        this.lazyInitialisation = lazyInitialisation;
    }

    public abstract List getItemList();

    public abstract int indexOf(Object var1);

    public abstract ListCellRenderer getListCellRenderer();

    public void reformatValue(Object value) {
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)anEvent;
            return e.getClickCount() > 2;
        }
        return true;
    }

    public void initialized() {
        this.comboBox = new JAComboBox();
        this.comboBox.setRenderer(this.getListCellRenderer());
        this.delegate = new EditorDelegate(this){

            public Object getValue() {
                return AbstractListEditor.this.getValue();
            }

            public void setValue(Object value) {
                AbstractListEditor.this.reformatValue(value);
                AbstractListEditor.this.setValue(value);
            }

            public boolean shouldSelectCell(EventObject anEvent) {
                if (anEvent instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)anEvent;
                    return e.getID() != 506;
                }
                return true;
            }

            public boolean stopCellEditing() {
                if (AbstractListEditor.this.comboBox.isEditable()) {
                    AbstractListEditor.this.comboBox.actionPerformed(new ActionEvent(AbstractListEditor.this, 0, ""));
                }
                return super.stopCellEditing();
            }
        };
        if (!this.lazyInitialisation) {
            this.comboBox.setModel(new DefaultComboBoxModel<Object>(this.getItemList().toArray()));
        }
        this.comboBox.addActionListener(this.delegate);
        this.initialize(this.comboBox);
    }

    public Object getValue() {
        return this.comboBox.getSelectedItem();
    }

    public void setValue(Object value) {
        this.reformatValue(value);
        if (value == null) {
            this.comboBox.setSelectedIndex(-1);
        } else {
            this.comboBox.setSelectedIndex(this.indexOf(value));
        }
        this.modify();
    }
}

