/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.propertyinspector.display.renderer;

import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.report.preview.PreviewPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class IconLabel
extends PreviewPanel {
    private JALabel label = new JALabel();
    private JALabel button = new JALabel();
    private String hint = null;
    private Color color = UIManager.getColor("Panel.background").darker();
    private Border lineBorder = new Border(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color aColor = g.getColor();
            try {
                g.setColor(IconLabel.this.color);
                g.drawLine(x, y, x, y + height);
            }
            finally {
                g.setColor(aColor);
            }
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(0, 2, 0, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }
    };

    public IconLabel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Center");
        this.add((Component)this.button, "East");
        this.button.setVisible(false);
        this.button.setPreferredSize(new Dimension(16, 16));
        this.button.setBorder(this.lineBorder);
        this.setOpaque(true);
    }

    public String getToolTipText(MouseEvent event) {
        if (this.isButton(event.getX(), event.getY()) && this.hint != null) {
            return this.hint;
        }
        return super.getToolTipText(event);
    }

    private boolean isButton(int x, int y) {
        return x >= this.button.getX() && x <= this.button.getX() + this.button.getWidth() && y >= this.button.getY() && y <= this.button.getY() + this.button.getHeight();
    }

    public JLabel getButton() {
        return this.button;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public void setIcon(Icon icon) {
        this.button.setIcon(icon);
        this.button.setVisible(icon != null);
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.label != null) {
            this.label.setBackground(c);
        }
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        if (this.label != null) {
            this.label.setForeground(c);
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
        if (this.label != null) {
            this.label.setFont(f);
        }
    }

    public void setText(String s) {
        if (this.label != null) {
            this.label.setText(s);
        }
    }
}

