/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class HammerJarFileEx {
    JarFile theJar;
    JarFile theTempJar;
    File newJarFile;
    ArrayList theExcludeList;
    JarOutputStream jarOutputStream;
    String sJarName;

    public HammerJarFileEx(JarFile theJar) {
        this.theJar = theJar;
        this.theExcludeList = new ArrayList(0);
        this.sJarName = theJar.getName();
    }

    public boolean load() {
        return this.createTempJar();
    }

    public boolean save() {
        boolean bRetVal = true;
        if (this.jarOutputStream == null) {
            return false;
        }
        bRetVal = this.copyJar();
        try {
            this.jarOutputStream.close();
        }
        catch (IOException e) {
            return false;
        }
        if (bRetVal) {
            try {
                this.theJar.close();
            }
            catch (IOException e) {
                return false;
            }
        }
        return bRetVal;
    }

    private boolean createTempJar() {
        int iMatch = this.sJarName.indexOf(".");
        try {
            this.newJarFile = new File(this.sJarName + ".tmp");
            if (this.newJarFile.exists()) {
                this.newJarFile.delete();
            }
            this.newJarFile.createNewFile();
        }
        catch (IOException e0) {
            System.err.println("Cannot create jar file " + this.sJarName + ".tmp");
            return false;
        }
        try {
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(this.newJarFile));
            this.jarOutputStream = null;
            try {
                this.jarOutputStream = new JarOutputStream(outputStream);
            }
            catch (IOException e1) {
                System.err.println("Cannot create output stream for jar file " + this.sJarName + " " + e1);
            }
        }
        catch (FileNotFoundException e1) {
            return false;
        }
        return true;
    }

    public byte[] getJarEntryBytes(JarFile jarf, JarEntry entry) {
        try {
            int bytesread;
            InputStream is = jarf.getInputStream(entry);
            int fileLength = (int)entry.getSize();
            byte[] classBytes = new byte[fileLength];
            for (int totalbytes = 0; totalbytes != fileLength; totalbytes += bytesread) {
                int iBytesToRead = 512;
                if (fileLength - totalbytes < 512) {
                    iBytesToRead = fileLength - totalbytes;
                }
                bytesread = is.read(classBytes, totalbytes, iBytesToRead);
            }
            is.close();
            return classBytes;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean copyJar() {
        boolean bRetVal = true;
        Enumeration<JarEntry> allentries = this.theJar.entries();
        while (allentries.hasMoreElements() && bRetVal) {
            JarEntry entry = allentries.nextElement();
            String sEntryName = entry.getName();
            if (this.theExcludeList.contains(sEntryName)) continue;
            byte[] theEntryBytes = this.getJarEntryBytes(this.theJar, entry);
            bRetVal = this.addJarEntry(sEntryName, theEntryBytes);
        }
        return bRetVal;
    }

    public boolean removeJarEntry(JarEntry theEntry) {
        String sName;
        if (theEntry != null && (sName = theEntry.getName()) != null) {
            this.theExcludeList.add(sName);
            return true;
        }
        return false;
    }

    public boolean addJarEntry(String sName, byte[] theBytes) {
        boolean bRetVal = this.createJarEntry(sName);
        if (bRetVal) {
            bRetVal = this.writeJarEntry(theBytes);
        }
        return bRetVal;
    }

    private boolean writeJarEntry(byte[] theBytes) {
        try {
            this.jarOutputStream.write(theBytes);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean write(int i) {
        try {
            this.jarOutputStream.write(i);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public JarOutputStream getOutputStream() {
        return this.jarOutputStream;
    }

    public boolean createJarEntry(String sName) {
        JarEntry je = new JarEntry(sName);
        try {
            this.jarOutputStream.putNextEntry(je);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean finishJarSave() {
        String sJarFileName = this.theJar.getName();
        try {
            this.theJar.close();
        }
        catch (IOException e1) {
            return false;
        }
        File theJarFile = new File(sJarFileName);
        if (theJarFile.exists()) {
            theJarFile.delete();
        }
        boolean bTest = this.newJarFile.renameTo(theJarFile);
        return bTest;
    }
}

