/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.HammerLogConsole;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

class HammerLogEditorPopupMenu
extends JPopupMenu {
    HammerLogConsole theConsole = null;
    EditorUndoAction theUndoAction = null;
    EditorRedoAction theRedoAction = null;
    EditorCutAction theCutAction = null;
    EditorCopyAction theCopyAction = null;
    EditorPasteAction thePasteAction = null;
    Object theEditor = null;
    EditorSelectAllAction theSelectAllAction = null;

    public HammerLogEditorPopupMenu(Object objEditor, HammerLogConsole objConsole) {
        this.theConsole = objConsole;
        this.theEditor = objEditor;
        this.theUndoAction = new EditorUndoAction("Undo", null, this.theConsole);
        this.theRedoAction = new EditorRedoAction("Redo", null, this.theConsole);
        this.theCutAction = new EditorCutAction("Cut", null, this.theConsole);
        this.theCopyAction = new EditorCopyAction("Copy", null, this.theConsole);
        this.thePasteAction = new EditorPasteAction("Paste", null, this.theConsole);
        this.theSelectAllAction = new EditorSelectAllAction("Select All", null, this.theConsole);
        this.add(this.theUndoAction);
        this.add(this.theRedoAction);
        this.addSeparator();
        this.add(this.theCutAction);
        this.add(this.theCopyAction);
        this.add(this.thePasteAction);
        this.addSeparator();
        this.add(this.theSelectAllAction);
    }

    public void editorAction(String theActionName, ActionEvent evt) {
        Class<?> clsActiveEditor = this.theEditor.getClass();
        Class[] clsParams = new Class[]{new String().getClass()};
        try {
            Method m = clsActiveEditor.getMethod("getActionByName", clsParams);
            Object[] objParams = new Object[]{theActionName};
            Object obj = m.invoke(this.theEditor, objParams);
            if (obj != null && obj instanceof Action) {
                Action action = (Action)obj;
                action.actionPerformed(evt);
            }
        }
        catch (InvocationTargetException e1) {
            System.out.println("Invocation error");
        }
        catch (NoSuchMethodException e2) {
            System.out.println("No such method error");
        }
        catch (IllegalAccessException e3) {
            System.out.println("Illegal Access error");
        }
    }

    class EditorRedoAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public EditorRedoAction(String label, Icon icon, HammerLogConsole objIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = objIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            Class<?> clsActiveEditor = HammerLogEditorPopupMenu.this.theEditor.getClass();
            Class[] clsParams = new Class[]{};
            try {
                Method m = clsActiveEditor.getMethod("redo", clsParams);
                Object[] objParams = new Object[]{};
                m.invoke(HammerLogEditorPopupMenu.this.theEditor, objParams);
            }
            catch (InvocationTargetException e1) {
                System.out.println("Invocation error");
            }
            catch (NoSuchMethodException e2) {
                System.out.println("No such method error");
            }
            catch (IllegalAccessException e3) {
                System.out.println("Illegal Access error");
            }
        }
    }

    class EditorUndoAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public EditorUndoAction(String label, Icon icon, HammerLogConsole objIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = objIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            Class<?> clsActiveEditor = HammerLogEditorPopupMenu.this.theEditor.getClass();
            Class[] clsParams = new Class[]{};
            try {
                Method m = clsActiveEditor.getMethod("undo", clsParams);
                Object[] objParams = new Object[]{};
                m.invoke(HammerLogEditorPopupMenu.this.theEditor, objParams);
            }
            catch (InvocationTargetException e1) {
                System.out.println("Invocation error");
            }
            catch (NoSuchMethodException e2) {
                System.out.println("No such method error");
            }
            catch (IllegalAccessException e3) {
                System.out.println("Illegal Access error");
            }
        }
    }

    class EditorPasteAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public EditorPasteAction(String label, Icon icon, HammerLogConsole objIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = objIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            HammerLogEditorPopupMenu.this.editorAction("paste-from-clipboard", evt);
        }
    }

    class EditorCopyAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public EditorCopyAction(String label, Icon icon, HammerLogConsole objIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = objIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            HammerLogEditorPopupMenu.this.editorAction("copy-to-clipboard", evt);
        }
    }

    class EditorSelectAllAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public EditorSelectAllAction(String label, Icon icon, HammerLogConsole objIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = objIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            HammerLogEditorPopupMenu.this.editorAction("select-all", evt);
        }
    }

    class EditorCutAction
    extends AbstractAction {
        HammerLogConsole theIDELogConsole;

        public EditorCutAction(String label, Icon icon, HammerLogConsole objIDELogConsole) {
            super(label, icon);
            this.theIDELogConsole = null;
            this.theIDELogConsole = objIDELogConsole;
        }

        public void actionPerformed(ActionEvent evt) {
            HammerLogEditorPopupMenu.this.editorAction("cut-to-clipboard", evt);
        }
    }
}

