/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class JOImageField
extends JComponent {
    private boolean editable;
    Image workImage;
    String lastSelectedPath = null;
    private Image image;
    static String defaultImageString = "http://www.java.com/im/logo_footer.gif";
    public String ImageLocation = "<Existing Image>";
    private boolean debug = true;
    private int width;
    private int height;
    private boolean explicitSize = false;
    private int explicitWidth = 0;
    private int explicitHeight = 0;
    private MediaTracker tracker;
    private static int lastTrackerID = 0;
    private int currentTrackerID;
    private boolean doneLoading = false;
    private Container parentContainer;

    public boolean isExplicitSize() {
        return this.explicitSize;
    }

    public void setExplicitSize(boolean explicitSize) {
        this.explicitSize = explicitSize;
    }

    public JOImageField() {
        this(defaultImageString);
    }

    public JOImageField(String imageURLString) {
        this(JOImageField.makeURL(imageURLString));
    }

    public JOImageField(URL imageURL) {
        this(JOImageField.loadImage(imageURL));
        this.ImageLocation = imageURL.toExternalForm();
    }

    public JOImageField(byte[] imageBytes) {
        this(JOImageField.loadImage(imageBytes));
    }

    public JOImageField(InputStream in) throws IOException {
        this(JOImageField.loadImage(in));
    }

    public JOImageField(URL imageDirectory, String file) {
        this(JOImageField.makeURL(imageDirectory, file));
        this.ImageLocation = file;
    }

    public void selectImageFile() {
        JFileChooser fc;
        int returnVal;
        String filename = "." + File.separator;
        if (this.lastSelectedPath != null) {
            filename = this.lastSelectedPath;
        }
        if ((returnVal = (fc = new JFileChooser(new File(filename))).showOpenDialog(null)) != 0) {
            return;
        }
        File selFile = fc.getSelectedFile();
        try {
            this.lastSelectedPath = selFile.toURL().toExternalForm();
            this.setImageLocation(this.lastSelectedPath);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public JOImageField(Image img) {
        this.setImage(img);
        this.addMouseListener(new ImageMouseListener());
        this.addFocusListener(new ImageFocusListener());
    }

    public void waitForImage(boolean doLayout) {
        if (!this.doneLoading) {
            this.debug("[waitForImage] - Resizing and waiting for " + this.ImageLocation);
            try {
                this.tracker.waitForID(this.currentTrackerID);
            }
            catch (InterruptedException ie) {
            }
            catch (Exception e) {
                System.out.println("Error loading " + this.ImageLocation + ": " + e.getMessage());
                e.printStackTrace();
            }
            if (this.tracker.isErrorID(0)) {
                new Throwable("Error loading image " + this.ImageLocation).printStackTrace();
            }
            this.doneLoading = true;
            this.width = this.explicitWidth != 0 ? this.explicitWidth : this.image.getWidth(this) + 2 * this.getInsets().left;
            this.height = this.explicitHeight != 0 ? this.explicitHeight : this.image.getHeight(this) + 2 * this.getInsets().top;
            this.setSize(this.width, this.height);
            this.debug("[waitForImage] - " + this.ImageLocation + " is " + this.width + "x" + this.height + ".");
            this.parentContainer = this.getParent();
            if (this.parentContainer != null && doLayout) {
                this.setBackground(this.parentContainer.getBackground());
                this.parentContainer.doLayout();
            }
        }
    }

    public void setSize(int width, int height) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (width > 0) {
                this.explicitWidth = width;
            }
            if (height > 0) {
                this.explicitHeight = height;
            }
        }
        super.setSize(width, height);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (width > 0) {
                this.explicitWidth = width;
            }
            if (height > 0) {
                this.explicitHeight = height;
            }
        }
        super.setBounds(x, y, width, height);
    }

    public void centerAt(int x, int y) {
        this.debug("Placing center of " + this.ImageLocation + " at (" + x + "," + y + ")");
        this.setLocation(x - this.width / 2, y - this.height / 2);
    }

    public synchronized boolean contains(int x, int y) {
        return x >= 0 && x <= this.width && y >= 0 && y <= this.height;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        if (cm == null) {
            return false;
        }
        return cm.hasAlpha();
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = JOImageField.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public void paint(Graphics g) {
        if (!this.doneLoading) {
            this.waitForImage(true);
        } else {
            if (this.hasFocus()) {
                try {
                    Kernel kernel = new Kernel(3, 3, new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f});
                    ConvolveOp op = new ConvolveOp(kernel);
                    BufferedImage bufferedImage = op.filter(JOImageField.toBufferedImage(this.image), null);
                    this.workImage = Toolkit.getDefaultToolkit().createImage(bufferedImage.getSource());
                }
                catch (Exception e) {
                    this.workImage = this.image;
                }
            } else {
                this.workImage = this.image;
            }
            if (this.explicitSize) {
                g.drawImage(this.workImage, this.getInsets().left, this.getInsets().top, this.width - this.getInsets().left * 2, this.height - this.getInsets().top * 2, this);
            } else {
                g.drawImage(this.workImage, this.getInsets().left, this.getInsets().top, this);
            }
        }
    }

    public Dimension getPreferredSize() {
        if (!this.doneLoading) {
            this.waitForImage(false);
        }
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (!this.doneLoading) {
            this.waitForImage(false);
        }
        return super.getMinimumSize();
    }

    protected void drawRectOLD(Graphics g, int left, int top, int width, int height, int lineThickness, Color rectangleColor) {
        g.setColor(rectangleColor);
        for (int i = 0; i < lineThickness; ++i) {
            g.drawRect(left, top, width, height);
            if (i >= lineThickness - 1) continue;
            ++left;
            ++top;
            width -= 2;
            height -= 2;
        }
    }

    protected void debug(String message) {
        if (this.debug) {
            System.out.println(message);
        }
    }

    private static URL makeURL(String s) {
        URL u = null;
        try {
            if (s == null) {
                u = new URL("file:/");
                return u;
            }
            if (!(s.toLowerCase().startsWith("http:") || s.toLowerCase().startsWith("file:") || s.toLowerCase().startsWith("ftp:"))) {
                s = "file:/" + s;
            }
            u = new URL(s);
        }
        catch (MalformedURLException mue) {
            System.out.println("Bad URL " + s + ": " + mue);
            mue.printStackTrace();
        }
        return u;
    }

    private static URL makeURL(URL directory, String file) {
        URL u = null;
        try {
            u = new URL(directory, file);
        }
        catch (MalformedURLException mue) {
            System.out.println("Bad URL " + directory.toExternalForm() + ", " + file + ": " + mue);
            mue.printStackTrace();
        }
        return u;
    }

    public static Image loadImage(URL url) {
        return Toolkit.getDefaultToolkit().getImage(url);
    }

    public static Image loadImage(String surl) {
        return JOImageField.loadImage(JOImageField.makeURL(surl));
    }

    public static Image loadImage(byte[] imageBytes) {
        return Toolkit.getDefaultToolkit().createImage(imageBytes);
    }

    public static Image loadImage(InputStream in) throws IOException {
        return ImageIO.read(in);
    }

    public Image getImage() {
        return this.image;
    }

    public void setBytes(byte[] imageBytes) {
        this.setImage(JOImageField.loadImage(imageBytes));
    }

    public byte[] getBytes() {
        BufferedImage bi = JOImageField.toBufferedImage(this.image);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bi);
        encoder.setJPEGEncodeParam(param);
        try {
            encoder.encode(bi);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected boolean hasExplicitSize() {
        return this.explicitSize;
    }

    public static String getDefaultImageString() {
        return defaultImageString;
    }

    public static void setDefaultImageString(String file) {
        defaultImageString = file;
    }

    public String getImageLocation() {
        return this.ImageLocation;
    }

    public void setImageLocation(String file) {
        this.ImageLocation = JOImageField.makeURL(file).toExternalForm();
        this.setImage(JOImageField.loadImage(this.ImageLocation));
    }

    public void setImage(Image img) {
        this.image = img;
        this.tracker = new MediaTracker(this);
        this.currentTrackerID = lastTrackerID++;
        this.tracker.addImage(this.image, this.currentTrackerID);
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public void setIsDebugging(boolean debug) {
        this.debug = debug;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        if (b != this.editable) {
            boolean oldVal = this.editable;
            this.editable = b;
            if (this.editable) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.enableInputMethods(this.editable);
            this.firePropertyChange("editable", (Object)oldVal, (Object)this.editable);
            this.repaint();
        }
    }

    class ImageFocusListener
    extends FocusAdapter {
        ImageFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            JOImageField.this.paint(JOImageField.this.getGraphics());
        }

        public void focusLost(FocusEvent e) {
            JOImageField.this.paint(JOImageField.this.getGraphics());
        }
    }

    class ImageMouseListener
    extends MouseAdapter {
        ImageMouseListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            JMenuItem item;
            evt.getComponent().requestFocus();
            JPopupMenu menu = new JPopupMenu();
            if (JOImageField.this.isEditable()) {
                item = new JMenuItem("Select");
                item.addActionListener(new SelectActionListener());
                menu.add(item);
                item = new JMenuItem("Edit");
                item.addActionListener(new SelectURLActionListener());
                menu.add(item);
                item = new JMenuItem("Cut");
                menu.add(item);
            }
            item = new JMenuItem("Copy");
            menu.add(item);
            if (JOImageField.this.isEditable()) {
                item = new JMenuItem("Paste");
                menu.add(item);
            }
            menu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    class SelectURLActionListener
    implements ActionListener {
        SelectURLActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String retstr = JOptionPane.showInputDialog("Edit", (Object)JOImageField.this.getImageLocation());
            if (retstr != null) {
                JOImageField.this.setImageLocation(retstr);
            }
        }
    }

    class SelectActionListener
    implements ActionListener {
        SelectActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JOImageField.this.selectImageFile();
        }
    }
}

