/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import java.util.ArrayList;

public class MetaPropertyDescriptor {
    MetaPropertyDescriptor theNextProperty = null;
    String sGetName = null;
    String sSetName = null;
    String theHelperClass = null;
    String sClass = null;
    String sType = null;
    private String sDefaultValue = null;
    String sName = null;
    String sDoc = null;
    public boolean bAllowMultipleLanguages = false;
    public int iSubpropertyCount = 0;
    public MetaPropertyDescriptor theFirstSubproperty = null;
    public MetaPropertyDescriptor theLastSubproperty = null;
    public MetaPropertyDescriptor theSuperProperty = null;
    public boolean bAllowMultipleValues = false;
    ArrayList theValueChoices = new ArrayList(0);
    public boolean bGenerate = true;
    public boolean bVisible = false;
    public boolean bObjectReference = false;
    public boolean bObjectPromptList = false;
    private String sIncludeTypeConstants = null;
    private int iOrder = 0;
    private ArrayList objectReferenceList = null;
    private boolean bDataAwareness = false;
    private boolean bReadOnly = false;
    private MetaClassDetail theMetaClassDetail = null;

    public MetaPropertyDescriptor() {
    }

    public MetaPropertyDescriptor(String theName, String theType, String theClass, String[] theValueChoiceList, String theDoc, String theDefaultValue, String theSetName, String theGetName, String theHelperClass, String sIncludeTypeConstants, int iOrder, MetadataDispenser theMetadataDispenser, MetaClassDetail theClassDetail) {
        this.sGetName = theGetName;
        this.sSetName = theSetName;
        this.sName = theName;
        this.sType = theType;
        this.sDoc = theDoc;
        this.theHelperClass = theHelperClass;
        this.sIncludeTypeConstants = sIncludeTypeConstants;
        this.theMetaClassDetail = theClassDetail;
        this.setDefaultValue(theMetadataDispenser, theClassDetail, theDefaultValue);
        this.sClass = theClass;
        this.iOrder = iOrder;
        if (theValueChoiceList != null) {
            for (int i = 0; i < theValueChoiceList.length; ++i) {
                this.theValueChoices.add(theValueChoiceList[i]);
            }
        }
    }

    public int getSubpropertyCount() {
        return this.iSubpropertyCount;
    }

    public MetaPropertyDescriptor getProperty(String sPropertyName) {
        for (MetaPropertyDescriptor theProperty = this.theFirstSubproperty; theProperty != null; theProperty = theProperty.getNextProperty()) {
            String sMetaDataPropertyName = theProperty.getName();
            if ((sMetaDataPropertyName = sMetaDataPropertyName.substring(sMetaDataPropertyName.lastIndexOf(".") + 1)).equals(sPropertyName)) {
                return theProperty;
            }
            int iDotPos = sPropertyName.indexOf(".");
            if (iDotPos == -1) continue;
            String sFront = sPropertyName.substring(0, iDotPos);
            if (!theProperty.getName().equals(sFront)) continue;
            if (theProperty.theFirstSubproperty != null) {
                return theProperty.theFirstSubproperty.getProperty(sPropertyName.substring(iDotPos + 1));
            }
            return null;
        }
        return null;
    }

    public void addSubproperty(MetaPropertyDescriptor theNewSubproperty) {
        if (this.theFirstSubproperty == null) {
            this.theFirstSubproperty = theNewSubproperty;
        } else {
            this.theLastSubproperty.theNextProperty = theNewSubproperty;
        }
        this.theLastSubproperty = theNewSubproperty;
        theNewSubproperty.theSuperProperty = this;
    }

    public boolean removeSubProperty(String sPropertyName) {
        MetaPropertyDescriptor theProperty = this.theFirstSubproperty;
        MetaPropertyDescriptor theLastProcessed = null;
        while (theProperty != null) {
            if (theProperty.sName.equals(sPropertyName)) {
                if (theLastProcessed == null) {
                    this.theFirstSubproperty = theProperty.theNextProperty;
                } else {
                    theLastProcessed.theNextProperty = theProperty.theNextProperty;
                }
                if (theProperty == this.theLastSubproperty) {
                    this.theLastSubproperty = theLastProcessed;
                    if (theLastProcessed != null && theLastProcessed.theNextProperty != null) {
                        theLastProcessed.theNextProperty = null;
                    }
                }
                --this.iSubpropertyCount;
                int iOrder = 0;
                for (theProperty = this.theFirstSubproperty; theProperty != null; theProperty = theProperty.getNextProperty()) {
                    theProperty.iOrder = iOrder++;
                }
                return true;
            }
            theLastProcessed = theProperty;
            theProperty = theProperty.theNextProperty;
        }
        return false;
    }

    public Object getValueChoice(int i) {
        String sValue = i >= this.theValueChoices.size() ? "" : (String)this.theValueChoices.get(i);
        if (this.sClass.equalsIgnoreCase("string")) {
            return sValue;
        }
        if (this.sClass.equalsIgnoreCase("integer")) {
            if (sValue.trim().length() == 0) {
                return new Integer(0);
            }
            return new Integer(sValue);
        }
        if (this.sClass.equalsIgnoreCase("boolean")) {
            if (sValue.trim().length() == 0) {
                return new Boolean(false);
            }
            return new Boolean(sValue);
        }
        return sValue;
    }

    public String getValueChoiceAsString(int i) {
        return this.getValueChoice(i).toString();
    }

    public String getName() {
        return this.sName;
    }

    public String getClassName() {
        return this.sClass;
    }

    public String getTypeName() {
        return this.sType;
    }

    public String getDoc() {
        return this.sDoc;
    }

    public String getDefaultValue() {
        return this.sDefaultValue;
    }

    public String getGetMethod() {
        return this.sGetName;
    }

    public String getSetMethod() {
        return this.sSetName;
    }

    public void setGetMethod(String sMethodName) {
        this.sGetName = sMethodName;
    }

    public void setSetMethod(String sMethodName) {
        this.sSetName = sMethodName;
    }

    public void setValueChoiceAsString(int i, String sValue) {
        this.theValueChoices.set(i, sValue);
    }

    public void setValueChoice(int i, Object objValue) {
        String sValue = "";
        sValue = objValue instanceof String ? (String)objValue : (objValue instanceof Integer ? objValue.toString() : (objValue instanceof Boolean ? objValue.toString() : objValue.toString()));
        this.theValueChoices.set(i, sValue);
    }

    public int getValueChoiceCount() {
        if (this.theValueChoices == null) {
            return 0;
        }
        return this.theValueChoices.size();
    }

    public void removeValueChoice(String sValue) {
        this.theValueChoices.remove(sValue);
    }

    public void addValueChoice(String sValue) {
        if (!this.theValueChoices.contains(sValue)) {
            this.theValueChoices.add(sValue);
        }
    }

    public boolean getDataAwareness() {
        return this.bDataAwareness;
    }

    public void setDataAwareness(boolean bDataAwareness) {
        this.bDataAwareness = bDataAwareness;
    }

    public void setName(String sValue) {
        this.sName = sValue;
    }

    public void setClassName(String sValue) {
        this.sClass = sValue;
    }

    public void getTypeName(String sValue) {
        this.sType = sValue;
    }

    public void setDoc(String sValue) {
        this.sDoc = sValue;
    }

    public void setHelperClass(String sValue) {
        this.theHelperClass = sValue;
    }

    public String getHelperClass() {
        return this.theHelperClass;
    }

    public boolean isReadOnly() {
        return this.bReadOnly;
    }

    public void setReadOnly(boolean bReadOnly) {
        this.bReadOnly = bReadOnly;
    }

    public MetaPropertyDescriptor getNextProperty() {
        return this.theNextProperty;
    }

    public void setDefaultValue(MetadataDispenser theProject, MetaClassDetail metaClassDetail, String sDefaultValue) {
        this.sDefaultValue = sDefaultValue;
        String sExpandedValue = this.getExpandedMatch(theProject, sDefaultValue);
        if (sDefaultValue != null) {
            metaClassDetail.setPropertyDefaultValue(this.sName, sDefaultValue, sExpandedValue);
        }
    }

    public void setSimpleDefaultValue(String sDefaultValue) {
        this.sDefaultValue = sDefaultValue;
    }

    public String getExpandedMatch(MetadataDispenser theProject, String sValue) {
        String sMatch = null;
        MetaConstantGroup theConstantTable = theProject.findConstantGroup(this.sIncludeTypeConstants);
        if (theConstantTable != null) {
            sMatch = theConstantTable.get(sValue);
        } else {
            MetaConstantGroupCollection theConstantTableCollection = theProject.findConstantGroupCollection(this.sIncludeTypeConstants);
            if (theConstantTableCollection != null) {
                sMatch = theConstantTableCollection.get(sValue);
            }
        }
        if (sMatch != null) {
            sValue = sMatch;
        }
        return sValue;
    }

    public Object getExpandedValue(MetaProject theProject, String sValue) {
        MetaConstantGroupCollection theConstantTableCollection;
        String sMatch = null;
        MetaConstantGroup theConstantTable = theProject.findConstantGroup(this.sIncludeTypeConstants);
        if (theConstantTable != null ? (sMatch = theConstantTable.getKey(sValue)) != null && this.sType.endsWith("oolean") : (theConstantTableCollection = theProject.findConstantGroupCollection(this.sIncludeTypeConstants)) != null && (sMatch = theConstantTableCollection.getKey(sValue)) != null && this.sType.endsWith("oolean")) {
            return new Boolean(sMatch);
        }
        if (sMatch != null) {
            sValue = sMatch;
        }
        return sValue;
    }

    public String getIncludeTypeConstants() {
        return this.sIncludeTypeConstants;
    }

    public void setIncludeTypeConstants(String sIncludeTypeConstants) {
        this.sIncludeTypeConstants = sIncludeTypeConstants;
    }

    public String getConciseValue(MetaProject theProject, String sTestValue) {
        String sMatch = null;
        MetaConstantGroup theConstantTable = theProject.findConstantGroup(this.sIncludeTypeConstants);
        if (theConstantTable != null) {
            sMatch = theConstantTable.getKey(sTestValue);
        } else {
            MetaConstantGroupCollection theConstantTableCollection = theProject.findConstantGroupCollection(this.sIncludeTypeConstants);
            if (theConstantTableCollection != null) {
                sMatch = theConstantTableCollection.getKey(sTestValue);
            }
        }
        if (sMatch != null) {
            sTestValue = sMatch;
        }
        return sTestValue;
    }

    public int getOrder() {
        return this.iOrder;
    }

    public void setObjectReferenceList(ArrayList objList) {
        this.objectReferenceList = objList;
    }

    public ArrayList getObjectReferenceList() {
        return this.objectReferenceList;
    }
}

