/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common.jdbc;

import ch.abacus.lib.ui.renderer.common.jdbc.JSSDataSource;
import com.nqadmin.swingSet.SSTextDocument;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Stack;
import java.util.Vector;
import javax.sql.RowSet;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class JSSComboBox
extends JComponent {
    public String FieldName = null;
    public RowSet rs = null;
    private SSTextDocument sstxdoc = null;
    private JSSDataSource editDataSource = null;
    private int iDesignMode = 0;
    private boolean bfieldBound = false;
    private JTextField textField = null;
    private JComboBox cmbDisplayed = new JComboBox();
    private transient Connection conn = null;
    private String query = null;
    private String columnName = null;
    private String displayColumnName = null;
    private String secondDisplayColumnName = null;
    private Vector columnVector = new Vector();
    private int numberOfItems = 0;
    private transient RowSet rowset = null;
    final MyComboListener cmbListener = new MyComboListener();
    final MyTextFieldDocumentListener textFieldDocumentListener = new MyTextFieldDocumentListener();
    final MyKeyListener myKeyListener = new MyKeyListener();
    String seperator = " - ";
    String datePattern = "MM/dd/yyyy";

    public JSSComboBox() {
        this.addComponent();
        this.textField = new JTextField();
    }

    public JSSComboBox(Connection _conn, String _query, String _columnName, String _displayColumnName, JTextField _textField) {
        this.conn = _conn;
        this.query = _query;
        this.columnName = _columnName;
        this.displayColumnName = _displayColumnName;
        this.textField = _textField;
        this.textField.setPreferredSize(new Dimension(200, 20));
        this.textField.setMaximumSize(new Dimension(200, 20));
        this.addComponent();
    }

    public JSSComboBox(Connection _conn, String _query, String _columnName, String _displayColumnName) {
        this.conn = _conn;
        this.query = _query;
        this.columnName = _columnName;
        this.displayColumnName = _displayColumnName;
        this.textField = new JTextField();
        this.textField.setPreferredSize(new Dimension(200, 20));
        this.cmbDisplayed.setPreferredSize(new Dimension(200, 20));
        this.textField.setMaximumSize(new Dimension(200, 20));
        this.cmbDisplayed.setMaximumSize(new Dimension(200, 20));
    }

    private void initex(Connection _conn, String _query, String _columnName, String _displayColumnName) {
        this.conn = _conn;
        this.query = _query;
        this.columnName = _columnName;
        this.displayColumnName = _displayColumnName;
        this.textField.setPreferredSize(new Dimension(200, 20));
        this.cmbDisplayed.setPreferredSize(new Dimension(200, 20));
        this.textField.setMaximumSize(new Dimension(200, 20));
        this.cmbDisplayed.setMaximumSize(new Dimension(200, 20));
    }

    public void setRowSet(RowSet _rowset) {
        this.rowset = _rowset;
    }

    public void setConnection(Connection _conn) {
        this.conn = _conn;
    }

    public void setQuery(String _query) {
        this.query = _query;
    }

    public void setColumnName(String _columnName) {
        this.columnName = _columnName;
    }

    public void setDisplayColumnName(String _displayColumnName) {
        this.displayColumnName = _displayColumnName;
    }

    public void setDateFormat(String _format) {
        this.datePattern = _format;
    }

    public void setSecondDisplayColumnName(String _secondDisplayColumnName) {
        this.secondDisplayColumnName = _secondDisplayColumnName;
    }

    public void setTextField(JTextField _textField) {
        this.textField = _textField;
    }

    public void setPreferredSize(Dimension _dimension) {
        this.cmbDisplayed.setPreferredSize(_dimension);
    }

    public Connection getConnection() {
        return this.conn;
    }

    public int getNumberOfItems() {
        return this.numberOfItems;
    }

    public String getQuery() {
        return this.query;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getDisplayColumnName() {
        return this.displayColumnName;
    }

    public String getSecondDisplayColumnName() {
        return this.secondDisplayColumnName;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setSeperator(String _seperator) {
        this.seperator = _seperator;
    }

    public String getSeperator() {
        return this.seperator;
    }

    public long getSelectedValue() {
        int index = this.cmbDisplayed.getSelectedIndex();
        if (index == -1) {
            return -1L;
        }
        return (Long)this.columnVector.get(index);
    }

    public void setSelectedValue(long _value) {
        this.textField.setText(String.valueOf(_value));
    }

    public void execute(String sqlCommand, String field, String displayField) throws SQLException, Exception {
        this.query = sqlCommand;
        this.initex(this.editDataSource.getConnection(), this.query, field, displayField);
        this.execute();
    }

    public void execute() throws SQLException, Exception {
        ResultSet rs = null;
        this.removeListeners();
        Statement statement = this.conn.createStatement();
        if (this.query.equals("")) {
            throw new Exception("Query is empty");
        }
        try {
            rs = statement.executeQuery(this.query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cmbDisplayed.removeAllItems();
        this.columnVector.clear();
        int i = 0;
        while (rs.next()) {
            if (this.secondDisplayColumnName != null) {
                this.cmbDisplayed.addItem(this.getStringValue(rs, this.displayColumnName) + this.seperator + rs.getString(this.secondDisplayColumnName));
            } else {
                this.cmbDisplayed.addItem(this.getStringValue(rs, this.displayColumnName));
            }
            Long columnId = new Long(i);
            this.columnVector.add(i, columnId);
            ++i;
        }
        this.numberOfItems = i;
        this.setCmbDisplay();
        this.addListeners();
    }

    private void setCmbDisplay() {
        Document doc = this.textField.getDocument();
        try {
            long valueInText;
            int indexCorrespondingToLong;
            String text = doc.getText(0, doc.getLength());
            if (text != null && (indexCorrespondingToLong = this.columnVector.indexOf(new Long(valueInText = Long.parseLong(text)))) != this.cmbDisplayed.getSelectedIndex()) {
                this.cmbDisplayed.setSelectedIndex(indexCorrespondingToLong);
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        catch (NullPointerException npe) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void bind(RowSet _rs, String _column) {
        this.bfieldBound = true;
        this.textField.setDocument((Document)new SSTextDocument(_rs, _column));
        this.cmbDisplayed.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                JSSComboBox.this.myKeyListener.resetSearchString();
            }
        });
    }

    private void addListeners() {
        this.cmbDisplayed.addActionListener(this.cmbListener);
        this.cmbDisplayed.addKeyListener(this.myKeyListener);
        this.textField.getDocument().addDocumentListener(this.textFieldDocumentListener);
    }

    private void removeListeners() {
        this.cmbDisplayed.removeActionListener(this.cmbListener);
        this.cmbDisplayed.removeKeyListener(this.myKeyListener);
        this.textField.getDocument().removeDocumentListener(this.textFieldDocumentListener);
    }

    public void setDataSource(JSSDataSource ds) {
        this.editDataSource = ds;
        try {
            if (ds != null && this.FieldName != null) {
                this.rs = ds.getRowSet();
                this.setRowSet(this.rs);
                if (this.iDesignMode == 0 && !this.bfieldBound) {
                    this.bind(this.rs, this.FieldName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFieldName(String sData) {
        this.FieldName = sData;
        if (this.rs != null || this.editDataSource != null) {
            this.setDataSource(this.editDataSource);
            if (this.iDesignMode == 0 && !this.bfieldBound) {
                this.bind(this.rs, this.FieldName);
            }
        }
    }

    public ArrayList getFieldNames() {
        return this.editDataSource.getFieldNames();
    }

    private void addComponent() {
        this.setLayout(new BoxLayout(this, 2));
        this.cmbDisplayed.setPreferredSize(new Dimension(150, 20));
        this.add(this.cmbDisplayed);
    }

    public JComboBox getComboBox() {
        return this.cmbDisplayed;
    }

    public Component getComponent() {
        return this.cmbDisplayed;
    }

    public void addItem(String _name, long _value) {
        this.columnVector.add(new Long(_value));
        this.cmbDisplayed.addItem(_name);
        ++this.numberOfItems;
    }

    public boolean deleteItem(String _name) {
        for (int i = 0; i < this.cmbDisplayed.getItemCount(); ++i) {
            if (!((String)this.cmbDisplayed.getItemAt(i)).equals(_name)) continue;
            this.cmbDisplayed.removeItemAt(i);
            this.columnVector.removeElementAt(i);
            --this.numberOfItems;
            return true;
        }
        return false;
    }

    public boolean deleteItem(long _value) {
        int index = this.columnVector.indexOf(new Long(_value));
        if (index == -1) {
            return false;
        }
        this.columnVector.removeElementAt(index);
        this.cmbDisplayed.removeItemAt(index);
        --this.numberOfItems;
        return true;
    }

    public boolean deleteItem(String _name, long _value) {
        for (int i = 0; i < this.cmbDisplayed.getItemCount(); ++i) {
            if (!((String)this.cmbDisplayed.getItemAt(i)).equals(_name) || (Long)this.columnVector.elementAt(i) != _value) continue;
            this.cmbDisplayed.removeItemAt(i);
            this.columnVector.removeElementAt(i);
            --this.numberOfItems;
            return true;
        }
        return false;
    }

    public boolean updateItem(long _value, String _name) {
        int index = this.columnVector.indexOf(new Long(_value));
        if (index == -1) {
            return false;
        }
        this.cmbDisplayed.removeActionListener(this.cmbListener);
        this.cmbDisplayed.insertItemAt(_name, index + 1);
        this.cmbDisplayed.removeItemAt(index);
        this.cmbDisplayed.setSelectedIndex(index);
        this.cmbDisplayed.addActionListener(this.cmbListener);
        return true;
    }

    private String getStringValue(ResultSet _rs, String _columnName) {
        String strValue = "";
        try {
            int type = _rs.getMetaData().getColumnType(_rs.findColumn(_columnName));
            switch (type) {
                case 91: {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(this.datePattern);
                    strValue = dateFormat.format(_rs.getDate(_columnName));
                    break;
                }
                default: {
                    strValue = _rs.getString(_columnName);
                    break;
                }
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        return strValue;
    }

    private class MyComboListener
    implements ActionListener {
        private MyComboListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            JSSComboBox.this.textField.getDocument().removeDocumentListener(JSSComboBox.this.textFieldDocumentListener);
            int index = JSSComboBox.this.cmbDisplayed.getSelectedIndex();
            if (index != -1) {
                try {
                    long valueCorresponingToIndex = (Long)JSSComboBox.this.columnVector.get(index);
                    String strValueinTextField = JSSComboBox.this.textField.getText();
                    long valueInText = -1L;
                    if (!strValueinTextField.equals("")) {
                        valueInText = Long.parseLong(strValueinTextField);
                    }
                    if (valueInText != valueCorresponingToIndex) {
                        JSSComboBox.this.textField.setText(String.valueOf(valueCorresponingToIndex));
                    }
                }
                catch (NullPointerException npe) {
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                JSSComboBox.this.textField.setText("");
            }
            JSSComboBox.this.textField.getDocument().addDocumentListener(JSSComboBox.this.textFieldDocumentListener);
        }
    }

    private class MyKeyListener
    extends KeyAdapter {
        String searchString = null;
        Stack searchStack = new Stack();
        int previousIndex = 0;

        private MyKeyListener() {
        }

        public void resetSearchString() {
            this.searchString = null;
        }

        public void keyReleased(KeyEvent ke) {
            int i;
            if (ke.getKeyCode() == 27 || ke.getKeyCode() == 33 || ke.getKeyCode() == 34 || ke.getKeyCode() == 38 || ke.getKeyCode() == 40 || ke.getKeyCode() == 10) {
                this.searchString = null;
                this.searchStack.removeAllElements();
                if (ke.getKeyCode() == 10) {
                    ((Component)ke.getSource()).transferFocus();
                }
                return;
            }
            if (ke.getKeyCode() == 8) {
                if (this.searchString == null) {
                    JSSComboBox.this.cmbDisplayed.setSelectedIndex(0);
                    this.searchStack.removeAllElements();
                    this.previousIndex = 0;
                    return;
                }
                if (this.searchString.length() > 0) {
                    this.searchString = this.searchString.substring(0, this.searchString.length() - 1);
                    if (this.searchString.length() == 0) {
                        this.searchString = null;
                        this.searchStack.removeAllElements();
                        this.previousIndex = 0;
                    }
                }
            } else {
                this.searchString = this.searchString == null ? new String(new char[]{ke.getKeyChar()}) : this.searchString + new String(new char[]{ke.getKeyChar()});
            }
            if (this.searchString == null || this.searchString.equals("")) {
                JSSComboBox.this.cmbDisplayed.setSelectedIndex(0);
                return;
            }
            if (ke.getKeyCode() == 8) {
                if (this.searchStack.empty()) {
                    JSSComboBox.this.cmbDisplayed.setSelectedIndex(0);
                    return;
                }
                this.searchStack.pop();
                if (!this.searchStack.empty()) {
                    this.previousIndex = (Integer)this.searchStack.peek();
                    JSSComboBox.this.cmbDisplayed.setSelectedIndex(this.previousIndex);
                    return;
                }
                this.previousIndex = 0;
                JSSComboBox.this.cmbDisplayed.setSelectedIndex(0);
                return;
            }
            for (i = this.previousIndex; i < JSSComboBox.this.cmbDisplayed.getItemCount(); ++i) {
                if (this.searchString.length() == 0) {
                    JSSComboBox.this.cmbDisplayed.setSelectedIndex(0);
                    continue;
                }
                if (((String)JSSComboBox.this.cmbDisplayed.getItemAt(i)).length() < this.searchString.length() || !this.searchString.equalsIgnoreCase(((String)JSSComboBox.this.cmbDisplayed.getItemAt(i)).substring(0, this.searchString.length()))) continue;
                JSSComboBox.this.cmbDisplayed.setSelectedIndex(i);
                this.searchStack.push(new Integer(i));
                return;
            }
            if (i == JSSComboBox.this.cmbDisplayed.getItemCount()) {
                for (i = 0; i < this.previousIndex; ++i) {
                    if (this.searchString.length() == 0) {
                        JSSComboBox.this.cmbDisplayed.setSelectedIndex(0);
                        continue;
                    }
                    if (((String)JSSComboBox.this.cmbDisplayed.getItemAt(i)).length() < this.searchString.length() || !this.searchString.equalsIgnoreCase(((String)JSSComboBox.this.cmbDisplayed.getItemAt(i)).substring(0, this.searchString.length()))) continue;
                    JSSComboBox.this.cmbDisplayed.setSelectedIndex(i);
                    this.searchStack.push(new Integer(i));
                    return;
                }
            }
            if (this.searchStack.empty()) {
                JSSComboBox.this.cmbDisplayed.setSelectedIndex(0);
            } else {
                JSSComboBox.this.cmbDisplayed.setSelectedIndex((Integer)this.searchStack.peek());
            }
        }
    }

    private class MyTextFieldDocumentListener
    implements DocumentListener {
        private MyTextFieldDocumentListener() {
        }

        public void changedUpdate(DocumentEvent de) {
            JSSComboBox.this.cmbDisplayed.removeActionListener(JSSComboBox.this.cmbListener);
            Document doc = JSSComboBox.this.textField.getDocument();
            try {
                String text = doc.getText(0, doc.getLength());
                if (text != null) {
                    long valueInText = Long.parseLong(text);
                    int indexCorrespondingToLong = JSSComboBox.this.columnVector.indexOf(new Long(valueInText));
                    if (indexCorrespondingToLong != JSSComboBox.this.cmbDisplayed.getSelectedIndex()) {
                        JSSComboBox.this.cmbDisplayed.setSelectedIndex(indexCorrespondingToLong);
                    }
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            catch (NullPointerException npe) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            JSSComboBox.this.cmbDisplayed.addActionListener(JSSComboBox.this.cmbListener);
        }

        public void insertUpdate(DocumentEvent de) {
            JSSComboBox.this.cmbDisplayed.removeActionListener(JSSComboBox.this.cmbListener);
            Document doc = JSSComboBox.this.textField.getDocument();
            try {
                String text = doc.getText(0, doc.getLength());
                if (text != null) {
                    long valueInText = Long.parseLong(text);
                    int indexCorrespondingToLong = JSSComboBox.this.columnVector.indexOf(new Long(valueInText));
                    if (indexCorrespondingToLong != JSSComboBox.this.cmbDisplayed.getSelectedIndex()) {
                        JSSComboBox.this.cmbDisplayed.setSelectedIndex(indexCorrespondingToLong);
                    }
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            catch (NullPointerException npe) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            JSSComboBox.this.cmbDisplayed.addActionListener(JSSComboBox.this.cmbListener);
        }

        public void removeUpdate(DocumentEvent de) {
            JSSComboBox.this.cmbDisplayed.removeActionListener(JSSComboBox.this.cmbListener);
            Document doc = JSSComboBox.this.textField.getDocument();
            try {
                String text = doc.getText(0, doc.getLength());
                if (text.equals("")) {
                    JSSComboBox.this.cmbDisplayed.setSelectedIndex(-1);
                } else if (text != null) {
                    long valueInText = Long.parseLong(text);
                    int indexCorrespondingToLong = JSSComboBox.this.columnVector.indexOf(new Long(valueInText));
                    if (indexCorrespondingToLong != JSSComboBox.this.cmbDisplayed.getSelectedIndex()) {
                        JSSComboBox.this.cmbDisplayed.setSelectedIndex(indexCorrespondingToLong);
                    }
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            catch (NullPointerException npe) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            JSSComboBox.this.cmbDisplayed.addActionListener(JSSComboBox.this.cmbListener);
        }
    }
}

