/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.programmableCompiler;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class Exec {
    private static boolean verbose = true;

    public static void setVerbose(boolean verboseFlag) {
        verbose = verboseFlag;
    }

    public static boolean exec(String command) {
        return Exec.exec(command, false, false);
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static boolean execWait(String command) {
        return Exec.exec(command, false, true);
    }

    public static boolean execPrint(String command) {
        return Exec.exec(command, true, false);
    }

    private static boolean exec(String command, boolean printResults, boolean wait) {
        block15: {
            if (verbose) {
                Exec.printSeparator();
                System.out.println("Executing '" + command + "'.");
            }
            try {
                Process p = Runtime.getRuntime().exec(command);
                if (printResults) {
                    BufferedInputStream buffer = new BufferedInputStream(p.getInputStream());
                    BufferedReader commandResult = new BufferedReader(new InputStreamReader(buffer));
                    String s = null;
                    try {
                        while ((s = commandResult.readLine()) != null) {
                            System.out.println("Output: " + s);
                        }
                        commandResult.close();
                        if (p.exitValue() != 0) {
                            if (verbose) {
                                Exec.printError(command + " -- p.exitValue() != 0");
                            }
                            return false;
                        }
                        break block15;
                    }
                    catch (Exception e) {}
                    break block15;
                }
                if (!wait) break block15;
                try {
                    System.out.println(" ");
                    int returnVal = p.waitFor();
                    if (returnVal != 0) {
                        if (verbose) {
                            Exec.printError(command);
                        }
                        return false;
                    }
                }
                catch (Exception e) {
                    if (verbose) {
                        Exec.printError(command, e);
                    }
                    return false;
                }
            }
            catch (Exception e) {
                if (verbose) {
                    Exec.printError(command, e);
                }
                return false;
            }
        }
        return true;
    }

    private static void printError(String command, Exception e) {
        System.out.println("Error doing exec(" + command + "): " + e.getMessage());
        System.out.println("Did you specify the full pathname?");
    }

    private static void printError(String command) {
        System.out.println("Error executing '" + command + "'.");
    }

    private static void printSeparator() {
        System.out.println("==============================================");
    }
}

