/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.programmableCompiler;

import ch.abacus.lib.ui.renderer.programmableCompiler.ProgrammableCompiler;
import java.io.File;
import java.lang.reflect.Method;

public class Test {
    public static void main(String[] args) {
        ProgrammableCompiler dc;
        Class[] classes;
        Class[] classes2;
        Class[] classes1;
        ProgrammableCompiler dc2;
        String[] expectedClasses;
        ProgrammableCompiler dc3;
        String[] mainClasses;
        Object o;
        Method m;
        Class c1;
        String[] defns;
        ProgrammableCompiler dc4;
        Method m2;
        Class c;
        String[] defns2;
        Object o2;
        Method m3;
        Method m4;
        Class c2;
        String packageHeader = "package p.q.r;\n";
        String defn1 = "public class Test1 {\n  public static void m1() {\n    System.out.println (\"Test OK.\");\n  }\n\n  public void m2() {\n    System.out.println (\"Test OK.\");\n  }\n\n  public String m3 (String s) {\n    return \"Test OK.\";\n  }\n}\n";
        String defn2 = "public class Test2 {\n  public static void m1() {\n    Test1 t = new Test1();\n    t.m2 ();\n  }\n}\n";
        String defn3 = "public class Test3 {\n  public static void m1() {\n    p.q.r.Test2 t = new p.q.r.Test2();\n    t.m1 ();\n  }\n}\n";
        String defn4 = "public class Test4 {\n  public static void m1() {\n    Test5 t = new Test5();\n    t.m1 ();\n  }\n}\n\nclass Test5 {\n  void m1() {\n    System.out.println (\"Test OK.\");\n  }\n}\n";
        String defn5 = "public class Test6 {\n  public void m1() {\n    Test7 t = new Test7();\n    t.m1 ();\n  }\n\n  class Test7 {\n    void m1() {\n      System.out.println (\"Test OK.\");\n    }\n  }\n}\n";
        String defn6 = "package a.b.c;\nimport d.e.f.*;\npublic class Test8 {\n  public void m1() {\n    Test9 t = new Test9 (this);\n    t.m1 ();\n  }\n\n  public void m2() {\n    System.out.println (\"Test OK.\");\n  }\n}\n";
        String defn7 = "package d.e.f;\nimport a.b.c.*;\npublic class Test9 {\n  Test8 t8;\n  public Test9 (Test8 t8) {\n    this.t8 = t8;\n  }\n\n  public void m1() {\n    t8.m2 ();\n  }\n}\n";
        try {
            System.out.println("Single class.");
            c2 = new ProgrammableCompiler().compileClass(defn1);
            m4 = c2.getMethod("m1", new Class[0]);
            m4.invoke(null, new Object[0]);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Single class in package.");
            c2 = new ProgrammableCompiler().compileClass(packageHeader + defn1);
            m4 = c2.getMethod("m1", new Class[0]);
            m4.invoke(null, new Object[0]);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Single class / non-static method.");
            c2 = new ProgrammableCompiler().compileClass(defn1);
            m4 = c2.getMethod("m2", new Class[0]);
            Object o3 = c2.newInstance();
            m4.invoke(o3, new Object[0]);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Single class / parameter and result.");
            c2 = new ProgrammableCompiler().compileClass(defn1);
            Object[] params = new Object[]{"test parameter"};
            Class[] paramTypes = new Class[]{params[0].getClass()};
            m3 = c2.getMethod("m3", paramTypes);
            o2 = c2.newInstance();
            String s = (String)m3.invoke(o2, params);
            System.out.println(s);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Two classes.");
            defns2 = new String[]{defn1, defn2};
            c = new ProgrammableCompiler().compileClass(defns2, "Test2");
            m2 = c.getMethod("m1", new Class[0]);
            Object o4 = c.newInstance();
            String s = (String)m2.invoke(o4, new Object[0]);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Separate compilation.");
            dc4 = new ProgrammableCompiler();
            defns = new String[]{packageHeader + defn1, packageHeader + defn2};
            c1 = dc4.compileClass(defns, "p.q.r.Test2");
            Class c22 = dc4.compileClass(defn3);
            m = c22.getMethod("m1", new Class[0]);
            o = c22.newInstance();
            String s = (String)m.invoke(o, new Object[0]);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Multiple classes in same definition.");
            dc4 = new ProgrammableCompiler();
            Class c12 = dc4.compileClass(defn4);
            Class c23 = dc4.compileClass(defn4, "Test4");
            m3 = c23.getMethod("m1", new Class[0]);
            o2 = c23.newInstance();
            m3.invoke(o2, new Object[0]);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Multiple classes, multiple definitions.");
            defns2 = new String[]{defn1, defn4};
            mainClasses = new String[]{"Test1", "Test4"};
            dc3 = new ProgrammableCompiler();
            Class c3 = dc3.compileClass(defns2, mainClasses, "Test4");
            m = c3.getMethod("m1", new Class[0]);
            o = c3.newInstance();
            m.invoke(o, new Object[0]);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Multiple classes returned.");
            defns2 = new String[]{defn1, defn4};
            mainClasses = new String[]{"Test1", "Test4"};
            expectedClasses = new String[]{"Test1", "Test4", "Test5"};
            dc2 = new ProgrammableCompiler();
            classes1 = dc2.compileClasses(defns2);
            Test.checkClassNames(classes1, expectedClasses);
            classes2 = dc2.compileClasses(defns2, mainClasses);
            Test.checkClassNames(classes2, expectedClasses);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Multiple specified classes returned.");
            defns2 = new String[]{defn1, defn4};
            mainClasses = new String[]{"Test1", "Test4"};
            dc3 = new ProgrammableCompiler();
            classes = dc3.compileSpecificClasses(defns2, mainClasses);
            Test.checkClassNames(classes, mainClasses);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Multiple classes specified and returned.");
            defns2 = new String[]{defn1, defn4};
            mainClasses = new String[]{"Test1", "Test4"};
            dc3 = new ProgrammableCompiler();
            classes = dc3.compileClasses(defns2, mainClasses, mainClasses);
            Test.checkClassNames(classes, mainClasses);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Multiple recursive packages.");
            defns2 = new String[]{defn6, defn7};
            dc = new ProgrammableCompiler();
            Class c4 = dc.compileClass(defns2, "a.b.c.Test8");
            m3 = c4.getMethod("m1", new Class[0]);
            o2 = c4.newInstance();
            m3.invoke(o2, new Object[0]);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Multiple independent compilations.");
            String[] defns1 = new String[]{defn6, defn7};
            String[] defns22 = new String[]{defn1, defn4};
            expectedClasses = new String[]{"Test1", "Test4", "Test5"};
            dc2 = new ProgrammableCompiler();
            classes1 = dc2.compileClasses(defns1);
            classes2 = dc2.compileClasses(defns22);
            Test.checkClassNames(classes2, expectedClasses);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Inner class.");
            defns2 = new String[]{defn5};
            String[] expectedClasses2 = new String[]{"Test6$Test7", "Test6"};
            dc3 = new ProgrammableCompiler();
            classes = dc3.compileClasses(defns2);
            Test.checkClassNames(classes, expectedClasses2);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Compile to byte arrays.");
            defns2 = new String[]{defn1, defn4};
            int[] expectedByteArrayLengths = new int[]{574, 320, 442};
            dc3 = new ProgrammableCompiler();
            byte[][] byteArrays = dc3.compileClassesToBytes(defns2);
            Test.checkByteArrayLengths(byteArrays, expectedByteArrayLengths);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Compile to files.");
            defns2 = new String[]{defn1, defn4};
            int[] expectedFileLengths = new int[]{574, 320, 442};
            dc3 = new ProgrammableCompiler();
            File[] files = dc3.compileClassesToFiles(defns2);
            Test.checkFileLengths(files, expectedFileLengths);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Manually setting class path.");
            ProgrammableCompiler dc1 = new ProgrammableCompiler();
            defns = new String[]{packageHeader + defn1, packageHeader + defn2};
            c1 = dc1.compileClass(defns, "p.q.r.Test2");
            ProgrammableCompiler dc22 = new ProgrammableCompiler();
            dc22.classPathVector.insertElementAt(dc1.classPathVector.elementAt(0), 0);
            Class c24 = dc22.compileClass(defn3);
            Method m5 = c24.getMethod("m1", new Class[0]);
            Object o5 = c24.newInstance();
            String s = (String)m5.invoke(o5, new Object[0]);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Compiler class invocation only.");
            dc4 = new ProgrammableCompiler();
            if (!dc4.isCompilerClassAvailable()) {
                System.out.println("Class invocation not available.");
            } else {
                dc4.useCompilerClass = true;
                dc4.useShell = false;
                c = dc4.compileClass(defn1);
                m2 = c.getMethod("m1", new Class[0]);
                m2.invoke(null, new Object[0]);
            }
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Shell invocation only.");
            dc4 = new ProgrammableCompiler();
            if (!dc4.isShellAvailable()) {
                System.out.println("Shell invocation not available.");
            } else {
                dc4.useCompilerClass = false;
                dc4.useShell = true;
                c = dc4.compileClass(defn1);
                m2 = c.getMethod("m1", new Class[0]);
                m2.invoke(null, new Object[0]);
            }
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Invalid class definitions (compilation should fail).");
            defns2 = new String[]{"xxx " + defn1, "yyy " + defn4};
            dc = new ProgrammableCompiler();
            Class[] classes3 = dc.compileClasses(defns2);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        System.out.println("Finished testing.");
    }

    protected static void printClassNames(Class[] classes) {
        System.out.println("Classes returned:\n");
        for (int i = 0; i < classes.length; ++i) {
            System.out.println("   " + classes[i].getName());
        }
    }

    protected static void printBytes(byte[][] byteArrays) {
        System.out.println("Byte arrays:\n");
        for (int i = 0; i < byteArrays.length; ++i) {
            System.out.println("Array length: " + byteArrays[i].length);
            for (int j = 0; j < byteArrays[i].length; ++j) {
                System.out.print(byteArrays[i][j]);
                System.out.print(" ");
            }
            System.out.println();
        }
    }

    protected static void checkClassNames(Class[] classes, String[] expectedClassNames) throws Exception {
        int i;
        if (classes.length != expectedClassNames.length) {
            throw new Exception("Unexpected number of classes");
        }
        String[] generatedClassNames = new String[classes.length];
        for (i = 0; i < classes.length; ++i) {
            generatedClassNames[i] = classes[i].getName();
        }
        Test.sort(generatedClassNames);
        Test.sort(expectedClassNames);
        for (i = 0; i < classes.length; ++i) {
            if (generatedClassNames[i].equals(expectedClassNames[i])) continue;
            throw new Exception("Unexpected class");
        }
        System.out.println("Test OK.");
    }

    protected static void sort(String[] strings) {
        int noStrings = strings.length;
        for (int i = 0; i < noStrings - 1; ++i) {
            for (int j = 0; j < noStrings - i - 1; ++j) {
                if (strings[j].compareTo(strings[j + 1]) <= 0) continue;
                String temp = strings[j + 1];
                strings[j + 1] = strings[j];
                strings[j] = temp;
            }
        }
    }

    protected static void checkByteArrayLengths(byte[][] byteArrays, int[] expectedByteArrayLengths) throws Exception {
        if (byteArrays.length != expectedByteArrayLengths.length) {
            throw new Exception("Unexpected number of byte arrays");
        }
        for (int i = 0; i < byteArrays.length; ++i) {
            if (byteArrays[i].length == expectedByteArrayLengths[i]) continue;
            throw new Exception("Unexpected byte array length");
        }
        System.out.println("Test OK.");
    }

    protected static void checkFileLengths(File[] files, int[] expectedFileLengths) throws Exception {
        if (files.length != expectedFileLengths.length) {
            throw new Exception("Unexpected number of files");
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].length() == (long)expectedFileLengths[i]) continue;
            throw new Exception("Unexpected file length");
        }
        System.out.println("Test OK.");
    }
}

