/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cf;

import com.ibm.cf.IndentWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class CodeFormatter {
    public static final int DEFAULT_MAX = 74;
    public static final int DEFAULT_STEP = 2;
    public static final String DEFAULT_DELIM = "(+";
    public static final String DEFAULT_S_DELIM = ",";
    private int maxLineLength = 74;
    private int indentationStep = 2;
    private String delimiters = "(+";
    private String stickyDelimiters = ",";
    private int indent;
    private int hangingIndent;
    private int origIndent;
    private boolean inCPP_Comment;

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int n) {
        this.maxLineLength = n < 0 ? 0 : n;
    }

    public int getIndentationStep() {
        return this.indentationStep;
    }

    public void setIndentationStep(int n) {
        this.indentationStep = n < 0 ? 0 : n;
    }

    public String getDelimiters() {
        return this.delimiters;
    }

    public void setDelimiters(String string) {
        this.delimiters = string;
    }

    public String getStickyDelimiters() {
        return this.stickyDelimiters;
    }

    public void setStickyDelimiters(String string) {
        this.stickyDelimiters = string;
    }

    private void printLine(String string, IndentWriter indentWriter) {
        String string2;
        char[] cArray = string.toCharArray();
        char c = ' ';
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer(this.hangingIndent + string.length());
        int n = 0;
        while (n < cArray.length) {
            block24: {
                char c2;
                block25: {
                    block23: {
                        c2 = cArray[n];
                        if (!bl) break block23;
                        stringBuffer.append(c2);
                        bl = false;
                        break block24;
                    }
                    if (!bl2) break block25;
                    switch (c2) {
                        case '\\': {
                            stringBuffer.append('\\');
                            bl = true;
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            stringBuffer.append(c2);
                            if (c2 == c) {
                                this.addTok(stringBuffer2, stringBuffer, indentWriter);
                                stringBuffer.setLength(0);
                                bl2 = false;
                                break;
                            }
                            break block24;
                        }
                        case '\t': {
                            stringBuffer.append(IndentWriter.getSpaces(this.indentationStep));
                            break;
                        }
                        default: {
                            if (c2 > '\u001f') {
                                stringBuffer.append(c2);
                                break;
                            }
                            break block24;
                        }
                    }
                    break block24;
                }
                if (this.inCPP_Comment) {
                    stringBuffer.append(c2);
                    if (c2 == '/' && n > 0 && cArray[n - 1] == '*') {
                        this.inCPP_Comment = false;
                    }
                } else {
                    switch (c2) {
                        case '/': {
                            stringBuffer.append(c2);
                            if (n <= 0 || cArray[n - 1] != '/') break;
                            String string3 = stringBuffer.append(cArray, n + 1, cArray.length - (n + 1)).toString();
                            indentWriter.println(this.indent, stringBuffer2.append(string3).toString());
                            return;
                        }
                        case '*': {
                            stringBuffer.append(c2);
                            if (n <= 0 || cArray[n - 1] != '/') break;
                            this.inCPP_Comment = true;
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            this.addTok(stringBuffer2, stringBuffer, indentWriter);
                            stringBuffer.setLength(0);
                            stringBuffer.append(c2);
                            c = c2;
                            bl2 = true;
                            break;
                        }
                        case '\t': {
                            stringBuffer.append(IndentWriter.getSpaces(this.indentationStep));
                            break;
                        }
                        case '{': {
                            stringBuffer.append(c2);
                            this.origIndent += this.indentationStep;
                            break;
                        }
                        case '}': {
                            stringBuffer.append(c2);
                            this.origIndent -= this.indentationStep;
                            if (n != 0) break;
                            this.indent = this.origIndent;
                            break;
                        }
                        default: {
                            if (c2 <= '\u001f') break;
                            if (this.delimiters.indexOf(c2) != -1) {
                                this.addTok(stringBuffer2, stringBuffer, indentWriter);
                                stringBuffer.setLength(0);
                                stringBuffer.append(c2);
                                break;
                            }
                            if (this.stickyDelimiters.indexOf(c2) != -1) {
                                stringBuffer.append(c2);
                                this.addTok(stringBuffer2, stringBuffer, indentWriter);
                                stringBuffer.setLength(0);
                                break;
                            }
                            stringBuffer.append(c2);
                        }
                    }
                }
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            this.addTok(stringBuffer2, stringBuffer, indentWriter);
        }
        if ((string2 = stringBuffer2.toString().trim()).length() > 0) {
            indentWriter.println(this.indent, string2);
        }
    }

    private void addTok(StringBuffer stringBuffer, StringBuffer stringBuffer2, IndentWriter indentWriter) {
        int n = stringBuffer2.length();
        int n2 = stringBuffer.length();
        if (this.indent + n2 + n > this.maxLineLength) {
            if (n2 == 0) {
                indentWriter.println(this.indent, stringBuffer2.toString());
                this.indent = this.hangingIndent;
                stringBuffer.setLength(0);
                return;
            }
            indentWriter.println(this.indent, stringBuffer.toString().trim());
            this.indent = this.hangingIndent;
            stringBuffer.setLength(0);
        }
        stringBuffer.append(stringBuffer2.toString());
    }

    public void formatCode(Reader reader, Writer writer) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        IndentWriter indentWriter = new IndentWriter(new BufferedWriter(writer), true);
        try {
            String string;
            this.origIndent = 0;
            this.inCPP_Comment = false;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() > 0) {
                    this.indent = this.origIndent;
                    this.hangingIndent = this.indent + this.indentationStep;
                    this.printLine(string, indentWriter);
                    continue;
                }
                indentWriter.println();
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }
}

