/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.windows;

import com.l2fprod.common.swing.JTaskPaneGroup;
import com.l2fprod.common.swing.plaf.basic.BasicTaskPaneGroupUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public class WindowsClassicTaskPaneGroupUI
extends BasicTaskPaneGroupUI {
    private static int TITLE_HEIGHT = 25;
    private static int ROUND_HEIGHT = 5;

    public static ComponentUI createUI(JComponent c) {
        return new WindowsClassicTaskPaneGroupUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.group.setOpaque(false);
    }

    protected int getTitleHeight() {
        return TITLE_HEIGHT;
    }

    protected Border createPaneBorder() {
        return new ClassicPaneBorder();
    }

    class ClassicPaneBorder
    extends BasicTaskPaneGroupUI.PaneBorder {
        ClassicPaneBorder() {
        }

        protected void paintExpandedControls(JTaskPaneGroup group, Graphics g) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int ovalSize = TITLE_HEIGHT - 2 * ROUND_HEIGHT;
            if (WindowsClassicTaskPaneGroupUI.this.mouseOver) {
                int x = group.getWidth() - TITLE_HEIGHT;
                int y = ROUND_HEIGHT - 1;
                int x2 = x + ovalSize;
                int y2 = y + ovalSize;
                g.setColor(Color.white);
                g.drawLine(x, y, x2, y);
                g.drawLine(x, y, x, y2);
                g.setColor(Color.gray);
                g.drawLine(x2, y, x2, y2);
                g.drawLine(x, y2, x2, y2);
            }
            Color paintColor = group.isSpecial() ? this.specialTitleForeground : this.titleForeground;
            BasicTaskPaneGroupUI.ChevronIcon chevron = group.isExpanded() ? new BasicTaskPaneGroupUI.ChevronIcon(true) : new BasicTaskPaneGroupUI.ChevronIcon(false);
            int chevronX = group.getWidth() - TITLE_HEIGHT + ovalSize / 2 - chevron.getIconWidth() / 2;
            int chevronY = ROUND_HEIGHT + (ovalSize / 2 - chevron.getIconHeight()) - 1;
            g.setColor(paintColor);
            chevron.paintIcon(group, g, chevronX, chevronY);
            chevron.paintIcon(group, g, chevronX, chevronY + chevron.getIconHeight() + 1);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }
}

