/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseColumn;
import com.microsoft.jdbc.base.BaseColumns;
import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplDatabaseMetaData;
import com.microsoft.jdbc.base.BaseResultSetFilterDescriptor;
import com.microsoft.jdbc.base.BaseResultSetSortDescriptor;
import com.microsoft.jdbc.base.BaseStatement;
import com.microsoft.jdbc.base.BaseTableTypes;
import com.microsoft.jdbc.base.BaseTypeInfos;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;

public final class BaseDatabaseMetaData
implements DatabaseMetaData {
    private static String footprint = "$Revision:   1.49.1.0.1.0  $";
    static final int driverMajorVersion = 2;
    protected static final int driverMinorVersion = 2;
    protected BaseConnection connection;
    protected BaseImplDatabaseMetaData implDatabaseMetaData;
    protected BaseExceptions exceptions;

    BaseDatabaseMetaData() {
    }

    public BaseDatabaseMetaData(BaseConnection baseConnection, BaseImplDatabaseMetaData baseImplDatabaseMetaData) throws SQLException {
        this.exceptions = baseConnection.exceptions;
        this.connection = baseConnection;
        this.implDatabaseMetaData = baseImplDatabaseMetaData;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.allProceduresAreCallable == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(1);
            }
            boolean bl = this.implDatabaseMetaData.allProceduresAreCallable;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean allTablesAreSelectable() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.allTablesAreSelectable == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(2);
            }
            boolean bl = this.implDatabaseMetaData.allTablesAreSelectable;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.dataDefinitionCausesTransactionCommit == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(113);
            }
            boolean bl = this.implDatabaseMetaData.dataDefinitionCausesTransactionCommit;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.dataDefinitionIgnoredInTransactions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(114);
            }
            boolean bl = this.implDatabaseMetaData.dataDefinitionIgnoredInTransactions;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: {
                    if (this.implDatabaseMetaData.deletesAreDetectedForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(138);
                    }
                    bl = this.implDatabaseMetaData.deletesAreDetectedForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.deletesAreDetectedScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(139);
                    }
                    bl = this.implDatabaseMetaData.deletesAreDetectedScrollInsensitive;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.deletesAreDetectedScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(140);
                    }
                    bl = this.implDatabaseMetaData.deletesAreDetectedScrollSensitive;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"deletesAreDetected"};
                    throw this.exceptions.getException(6003, stringArray);
                }
            }
            boolean bl2 = bl;
            Object var4_6 = null;
            return bl2;
        }
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.doesMaxRowSizeIncludeBlobs == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(99);
            }
            boolean bl = this.implDatabaseMetaData.doesMaxRowSizeIncludeBlobs;
            Object var3_3 = null;
            return bl;
        }
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (n != 0 && n != 1 && n != 2 || string == null && string3 == null && string2 == null) {
                String[] stringArray = new String[]{"getBestRowIdentifier"};
                throw this.exceptions.getException(6003, stringArray);
            }
            int[] nArray = new int[]{9, 10, 11, 1, 12};
            Object[] objectArray = new Object[]{string, string2, string3, new Integer(n), new Boolean(bl)};
            boolean[] blArray = new boolean[5];
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray);
            int[] nArray2 = new int[]{1};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(7, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(5);
            baseColumn.label = "SCOPE";
            baseColumn.name = "SCOPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "COLUMN_NAME";
            baseColumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DATA_TYPE";
            baseColumn.name = "DATA_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_NAME";
            baseColumn.name = "TYPE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "COLUMN_SIZE";
            baseColumn.name = "COLUMN_SIZE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "BUFFER_LENGTH";
            baseColumn.name = "BUFFER_LENGTH";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DECIMAL_DIGITS";
            baseColumn.name = "DECIMAL_DIGITS";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "PSEUDO_COLUMN";
            baseColumn.name = "PSEUDO_COLUMN";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            if (!baseResultSetFilterDescriptor.allRestrictionsSatified()) {
                baseColumn = new BaseColumn(12);
                baseColumn.label = "TABLE_CAT";
                baseColumn.name = "TABLE_CAT";
                this.setCommonResultSetMetaData(baseColumn);
                baseColumns.add(baseColumn);
                baseColumn = new BaseColumn(12);
                baseColumn.label = "TABLE_SCHEM";
                baseColumn.name = "TABLE_SCHEM";
                this.setCommonResultSetMetaData(baseColumn);
                baseColumns.add(baseColumn);
                baseColumn = new BaseColumn(12);
                baseColumn.label = "TABLE_NAME";
                baseColumn.name = "TABLE_NAME";
                this.setCommonResultSetMetaData(baseColumn);
                baseColumns.add(baseColumn);
                baseColumn = new BaseColumn(-7);
                baseColumn.label = "NULLABLE";
                baseColumn.name = "NULLABLE";
                this.setCommonResultSetMetaData(baseColumn);
                baseColumns.add(baseColumn);
            }
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            baseStatement.setupForDatabaseMetaData(baseColumns, 7, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
            ResultSet resultSet = baseStatement.executeQuery(string4);
            Object var8_19 = null;
            return resultSet;
        }
    }

    public String getCatalogSeparator() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.catalogSeparator == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(58);
            }
            String string = this.implDatabaseMetaData.catalogSeparator;
            Object var3_3 = null;
            return string;
        }
    }

    public String getCatalogTerm() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.catalogTerm == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(56);
            }
            String string = this.implDatabaseMetaData.catalogTerm;
            Object var3_3 = null;
            return string;
        }
    }

    public ResultSet getCatalogs() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray = new int[]{1};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray);
            String string = this.implDatabaseMetaData.getResultSetSQL(8, null, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_CAT";
            baseColumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            baseStatement.setupForDatabaseMetaData(baseColumns, 8, null, baseResultSetSortDescriptor, null);
            ResultSet resultSet = baseStatement.executeQuery(string);
            Object var3_9 = null;
            return resultSet;
        }
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (string == null && string3 == null && string2 == null && string4 == null) {
                String[] stringArray = new String[]{"getColumnPrivileges"};
                throw this.exceptions.getException(6003, stringArray);
            }
            int[] nArray = new int[]{1, 2, 3, 4};
            Object[] objectArray = new Object[]{string, string2, string3, string4};
            boolean[] blArray = new boolean[4];
            blArray[3] = true;
            boolean[] blArray2 = blArray;
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray2);
            int[] nArray2 = new int[]{4, 7};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string5 = this.implDatabaseMetaData.getResultSetSQL(9, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_CAT";
            baseColumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_SCHEM";
            baseColumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_NAME";
            baseColumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "COLUMN_NAME";
            baseColumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "GRANTOR";
            baseColumn.name = "GRANTOR";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "GRANTEE";
            baseColumn.name = "GRANTEE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PRIVILEGE";
            baseColumn.name = "PRIVILEGE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "IS_GRANTABLE";
            baseColumn.name = "IS_GRANTABLE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            baseStatement.setupForDatabaseMetaData(baseColumns, 9, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
            ResultSet resultSet = baseStatement.executeQuery(string5);
            Object var7_18 = null;
            return resultSet;
        }
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray = new int[]{1, 2, 3, 4};
            Object[] objectArray = new Object[]{string, string2, string3, string4};
            boolean[] blArray = new boolean[4];
            blArray[1] = true;
            blArray[2] = true;
            blArray[3] = true;
            boolean[] blArray2 = blArray;
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray2);
            int[] nArray2 = new int[]{2, 3, 17};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string5 = this.implDatabaseMetaData.getResultSetSQL(2, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_CAT";
            baseColumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_SCHEM";
            baseColumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_NAME";
            baseColumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "COLUMN_NAME";
            baseColumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DATA_TYPE";
            baseColumn.name = "DATA_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_NAME";
            baseColumn.name = "TYPE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "COLUMN_SIZE";
            baseColumn.name = "COLUMN_SIZE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "BUFFER_LENGTH";
            baseColumn.name = "BUFFER_LENGTH";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "DECIMAL_DIGITS";
            baseColumn.name = "DECIMAL_DIGITS";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "NUM_PREC_RADIX";
            baseColumn.name = "NUM_PREC_RADIX";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "NULLABLE";
            baseColumn.name = "NULLABLE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "REMARKS";
            baseColumn.name = "REMARKS";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "COLUMN_DEF";
            baseColumn.name = "COLUMN_DEF";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "SQL_DATA_TYPE";
            baseColumn.name = "SQL_DATA_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "SQL_DATETIME_SUB";
            baseColumn.name = "SQL_DATETIME_SUB";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "CHAR_OCTET_LENGTH";
            baseColumn.name = "CHAR_OCTET_LENGTH";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "ORDINAL_POSITION";
            baseColumn.name = "ORDINAL_POSITION";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "IS_NULLABLE";
            baseColumn.name = "IS_NULLABLE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            baseStatement.setupForDatabaseMetaData(baseColumns, 2, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
            ResultSet resultSet = baseStatement.executeQuery(string5);
            Object var7_17 = null;
            return resultSet;
        }
    }

    public Connection getConnection() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseConnection baseConnection2 = this.connection;
            Object var3_3 = null;
            return baseConnection2;
        }
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (string3 == null || string6 == null) {
                String[] stringArray = new String[]{"getCrossReference"};
                throw this.exceptions.getException(6003, stringArray);
            }
            int[] nArray = new int[]{1, 2, 3, 5, 6, 7};
            Object[] objectArray = new Object[]{string, string2, string3, string4, string5, string6};
            boolean[] blArray = new boolean[6];
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray);
            int[] nArray2 = new int[]{5, 6, 7, 9};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string7 = this.implDatabaseMetaData.getResultSetSQL(10, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_CAT";
            baseColumn.name = "PKTABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_SCHEM";
            baseColumn.name = "PKTABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_NAME";
            baseColumn.name = "PKTABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKCOLUMN_NAME";
            baseColumn.name = "PKCOLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_CAT";
            baseColumn.name = "FKTABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_SCHEM";
            baseColumn.name = "FKTABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_NAME";
            baseColumn.name = "FKTABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKCOLUMN_NAME";
            baseColumn.name = "FKCOLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "KEY_SEQ";
            baseColumn.name = "KEY_SEQ";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "UPDATE_RULE";
            baseColumn.name = "UPDATE_RULE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DELETE_RULE";
            baseColumn.name = "DELETE_RULE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FK_NAME";
            baseColumn.name = "FK_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PK_NAME";
            baseColumn.name = "PK_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DEFERRABILITY";
            baseColumn.name = "DEFERRABILITY";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            baseStatement.setupForDatabaseMetaData(baseColumns, 10, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
            ResultSet resultSet = baseStatement.executeQuery(string7);
            Object var9_20 = null;
            return resultSet;
        }
    }

    public String getDatabaseProductName() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.databaseProductName == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(8);
            }
            String string = this.implDatabaseMetaData.databaseProductName;
            Object var3_3 = null;
            return string;
        }
    }

    public String getDatabaseProductVersion() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.databaseProductVersion == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(9);
            }
            String string = this.implDatabaseMetaData.databaseProductVersion;
            Object var3_3 = null;
            return string;
        }
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.defaultTransactionIsolation == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(105);
            }
            int n = this.implDatabaseMetaData.defaultTransactionIsolation;
            Object var3_3 = null;
            return n;
        }
    }

    public int getDriverMajorVersion() {
        return 2;
    }

    public int getDriverMinorVersion() {
        return 2;
    }

    public String getDriverName() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            String string = this.connection.driverName;
            Object var3_3 = null;
            return string;
        }
    }

    public String getDriverVersion() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            String string = String.valueOf(Integer.toString(2)) + "." + Integer.toString(2) + "." + "0029";
            Object var3_3 = null;
            return string;
        }
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (string == null && string3 == null && string2 == null) {
                String[] stringArray = new String[]{"getExportedKeys"};
                throw this.exceptions.getException(6003, stringArray);
            }
            int[] nArray = new int[]{1, 2, 3};
            Object[] objectArray = new Object[]{string, string2, string3};
            boolean[] blArray = new boolean[3];
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray);
            int[] nArray2 = new int[]{5, 6, 7, 9};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(11, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_CAT";
            baseColumn.name = "PKTABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_SCHEM";
            baseColumn.name = "PKTABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_NAME";
            baseColumn.name = "PKTABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKCOLUMN_NAME";
            baseColumn.name = "PKCOLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_CAT";
            baseColumn.name = "FKTABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_SCHEM";
            baseColumn.name = "FKTABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_NAME";
            baseColumn.name = "FKTABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKCOLUMN_NAME";
            baseColumn.name = "FKCOLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "KEY_SEQ";
            baseColumn.name = "KEY_SEQ";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "UPDATE_RULE";
            baseColumn.name = "UPDATE_RULE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DELETE_RULE";
            baseColumn.name = "DELETE_RULE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FK_NAME";
            baseColumn.name = "FK_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PK_NAME";
            baseColumn.name = "PK_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DEFERRABILITY";
            baseColumn.name = "DEFERRABILITY";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            baseStatement.setupForDatabaseMetaData(baseColumns, 11, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
            ResultSet resultSet = baseStatement.executeQuery(string4);
            Object var6_17 = null;
            return resultSet;
        }
    }

    public String getExtraNameCharacters() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.extraNameCharacters == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(27);
            }
            String string = this.implDatabaseMetaData.extraNameCharacters;
            Object var3_3 = null;
            return string;
        }
    }

    public String getIdentifierQuoteString() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.identifierQuoteString == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(20);
            }
            String string = this.implDatabaseMetaData.identifierQuoteString;
            Object var3_3 = null;
            return string;
        }
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (string3 == null) {
                String[] stringArray = new String[]{"getImportedKeys"};
                throw this.exceptions.getException(6003, stringArray);
            }
            int[] nArray = new int[]{5, 6, 7};
            Object[] objectArray = new Object[]{string, string2, string3};
            boolean[] blArray = new boolean[3];
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray);
            int[] nArray2 = new int[]{1, 2, 3, 9};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(12, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_CAT";
            baseColumn.name = "PKTABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_SCHEM";
            baseColumn.name = "PKTABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_NAME";
            baseColumn.name = "PKTABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKCOLUMN_NAME";
            baseColumn.name = "PKCOLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_CAT";
            baseColumn.name = "FKTABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_SCHEM";
            baseColumn.name = "FKTABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_NAME";
            baseColumn.name = "FKTABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKCOLUMN_NAME";
            baseColumn.name = "FKCOLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "KEY_SEQ";
            baseColumn.name = "KEY_SEQ";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "UPDATE_RULE";
            baseColumn.name = "UPDATE_RULE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DELETE_RULE";
            baseColumn.name = "DELETE_RULE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FK_NAME";
            baseColumn.name = "FK_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PK_NAME";
            baseColumn.name = "PK_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DEFERRABILITY";
            baseColumn.name = "DEFERRABILITY";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            baseStatement.setupForDatabaseMetaData(baseColumns, 12, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
            ResultSet resultSet = baseStatement.executeQuery(string4);
            Object var6_17 = null;
            return resultSet;
        }
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (string3 == null) {
                throw this.exceptions.getException(6046);
            }
            int[] nArray = new int[]{1, 2, 3, 4, 14};
            Object[] objectArray = new Object[]{string, string2, string3, new Boolean(bl), new Boolean(bl2)};
            boolean[] blArray = new boolean[5];
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray);
            int[] nArray2 = new int[]{4, 7, 6, 8};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(13, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_CAT";
            baseColumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_SCHEM";
            baseColumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_NAME";
            baseColumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(-7);
            baseColumn.label = "NON_UNIQUE";
            baseColumn.name = "NON_UNIQUE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "INDEX_QUALIFIER";
            baseColumn.name = "INDEX_QUALIFIER";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "INDEX_NAME";
            baseColumn.name = "INDEX_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "TYPE";
            baseColumn.name = "TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "ORDINAL_POSITION";
            baseColumn.name = "ORDINAL_POSITION";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "COLUMN_NAME";
            baseColumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "ASC_OR_DESC";
            baseColumn.name = "ASC_OR_DESC";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "CARDINALITY";
            baseColumn.name = "CARDINALITY";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "PAGES";
            baseColumn.name = "PAGES";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FILTER_CONDITION";
            baseColumn.name = "FILTER_CONDITION";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            if (!baseResultSetFilterDescriptor.allRestrictionsSatified()) {
                baseColumn = new BaseColumn(-7);
                baseColumn.label = "APPROXIMATE";
                baseColumn.name = "APPROXIMATE";
                this.setCommonResultSetMetaData(baseColumn);
                baseColumns.add(baseColumn);
            }
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            baseStatement.setupForDatabaseMetaData(baseColumns, 13, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
            ResultSet resultSet = baseStatement.executeQuery(string4);
            Object var8_18 = null;
            return resultSet;
        }
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxBinaryLiteralLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(84);
            }
            int n = this.implDatabaseMetaData.maxBinaryLiteralLength;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxCatalogNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxCatalogNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(97);
            }
            int n = this.implDatabaseMetaData.maxCatalogNameLength;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxCharLiteralLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxCharLiteralLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(85);
            }
            int n = this.implDatabaseMetaData.maxCharLiteralLength;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxColumnNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(86);
            }
            int n = this.implDatabaseMetaData.maxColumnNameLength;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnsInGroupBy == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(87);
            }
            int n = this.implDatabaseMetaData.maxColumnsInGroupBy;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxColumnsInIndex() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnsInIndex == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(88);
            }
            int n = this.implDatabaseMetaData.maxColumnsInIndex;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnsInOrderBy == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(89);
            }
            int n = this.implDatabaseMetaData.maxColumnsInOrderBy;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxColumnsInSelect() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnsInSelect == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(90);
            }
            int n = this.implDatabaseMetaData.maxColumnsInSelect;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxColumnsInTable() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnsInTable == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(91);
            }
            int n = this.implDatabaseMetaData.maxColumnsInTable;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxConnections() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxConnections == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(92);
            }
            int n = this.implDatabaseMetaData.maxConnections;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxCursorNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxCursorNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(93);
            }
            int n = this.implDatabaseMetaData.maxCursorNameLength;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxIndexLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxIndexLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(94);
            }
            int n = this.implDatabaseMetaData.maxIndexLength;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxProcedureNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxProcedureNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(96);
            }
            int n = this.implDatabaseMetaData.maxProcedureNameLength;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxRowSize() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxRowSize == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(98);
            }
            int n = this.implDatabaseMetaData.maxRowSize;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxSchemaNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxSchemaNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(95);
            }
            int n = this.implDatabaseMetaData.maxSchemaNameLength;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxStatementLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxStatementLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(100);
            }
            int n = this.implDatabaseMetaData.maxStatementLength;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxStatements() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int n;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxStatements == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(101);
            }
            if ((n = this.implDatabaseMetaData.maxStatements.intValue()) == 1) {
                n = 0;
            }
            int n2 = n;
            Object var3_4 = null;
            return n2;
        }
    }

    public int getMaxTableNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxTableNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(102);
            }
            int n = this.implDatabaseMetaData.maxTableNameLength;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxTablesInSelect() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxTablesInSelect == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(103);
            }
            int n = this.implDatabaseMetaData.maxTablesInSelect;
            Object var3_3 = null;
            return n;
        }
    }

    public int getMaxUserNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxUserNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(104);
            }
            int n = this.implDatabaseMetaData.maxUserNameLength;
            Object var3_3 = null;
            return n;
        }
    }

    public String getNumericFunctions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.numericFunctions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(22);
            }
            String string = this.implDatabaseMetaData.numericFunctions;
            Object var3_3 = null;
            return string;
        }
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (string == null && string3 == null && string2 == null) {
                String[] stringArray = new String[]{"getColumnPrivileges"};
                throw this.exceptions.getException(6003, stringArray);
            }
            int[] nArray = new int[]{1, 2, 3};
            Object[] objectArray = new Object[]{string, string2, string3};
            boolean[] blArray = new boolean[3];
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray);
            int[] nArray2 = new int[]{4};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(14, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_CAT";
            baseColumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_SCHEM";
            baseColumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_NAME";
            baseColumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "COLUMN_NAME";
            baseColumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "KEY_SEQ";
            baseColumn.name = "KEY_SEQ";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PK_NAME";
            baseColumn.name = "PK_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            baseStatement.setupForDatabaseMetaData(baseColumns, 14, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
            ResultSet resultSet = baseStatement.executeQuery(string4);
            Object var6_17 = null;
            return resultSet;
        }
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray = new int[]{1, 2, 3, 4};
            Object[] objectArray = new Object[]{string, string2, string3, string4};
            boolean[] blArray = new boolean[4];
            blArray[1] = true;
            blArray[2] = true;
            blArray[3] = true;
            boolean[] blArray2 = blArray;
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray2);
            int[] nArray2 = new int[]{2, 3};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string5 = this.implDatabaseMetaData.getResultSetSQL(6, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "PROCEDURE_CAT";
            baseColumn.name = "PROCEDURE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PROCEDURE_SCHEM";
            baseColumn.name = "PROCEDURE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PROCEDURE_NAME";
            baseColumn.name = "PROCEDURE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "COLUMN_NAME";
            baseColumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "COLUMN_TYPE";
            baseColumn.name = "COLUMN_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DATA_TYPE";
            baseColumn.name = "DATA_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_NAME";
            baseColumn.name = "TYPE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "PRECISION";
            baseColumn.name = "PRECISION";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "LENGTH";
            baseColumn.name = "LENGTH";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "SCALE";
            baseColumn.name = "SCALE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "RADIX";
            baseColumn.name = "RADIX";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "NULLABLE";
            baseColumn.name = "NULLABLE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "REMARKS";
            baseColumn.name = "REMARKS";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            baseStatement.setupForDatabaseMetaData(baseColumns, 6, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
            ResultSet resultSet = baseStatement.executeQuery(string5);
            Object var7_17 = null;
            return resultSet;
        }
    }

    public String getProcedureTerm() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.procedureTerm == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(55);
            }
            String string = this.implDatabaseMetaData.procedureTerm;
            Object var3_3 = null;
            return string;
        }
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray = new int[]{1, 2, 3};
            Object[] objectArray = new Object[]{string, string2, string3};
            boolean[] blArray = new boolean[3];
            blArray[1] = true;
            blArray[2] = true;
            boolean[] blArray2 = blArray;
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray2);
            int[] nArray2 = new int[]{2, 3};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(5, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "PROCEDURE_CAT";
            baseColumn.name = "PROCEDURE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PROCEDURE_SCHEM";
            baseColumn.name = "PROCEDURE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PROCEDURE_NAME";
            baseColumn.name = "PROCEDURE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "RESERVED_1";
            baseColumn.name = "RESERVED_1";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "RESERVED_2";
            baseColumn.name = "RESERVED_2";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "RESERVED_3";
            baseColumn.name = "RESERVED_3";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "REMARKS";
            baseColumn.name = "REMARKS";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "PROCEDURE_TYPE";
            baseColumn.name = "PROCEDURE_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            baseStatement.setupForDatabaseMetaData(baseColumns, 5, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
            ResultSet resultSet = baseStatement.executeQuery(string4);
            Object var6_16 = null;
            return resultSet;
        }
    }

    public String getSQLKeywords() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.SQLKeywords == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(21);
            }
            String string = this.implDatabaseMetaData.SQLKeywords;
            Object var3_3 = null;
            return string;
        }
    }

    public String getSchemaTerm() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.schemaTerm == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(54);
            }
            String string = this.implDatabaseMetaData.schemaTerm;
            Object var3_3 = null;
            return string;
        }
    }

    public ResultSet getSchemas() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray = new int[]{1};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray);
            String string = this.implDatabaseMetaData.getResultSetSQL(15, null, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_SCHEM";
            baseColumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            baseStatement.setupForDatabaseMetaData(baseColumns, 15, null, baseResultSetSortDescriptor, null);
            ResultSet resultSet = baseStatement.executeQuery(string);
            Object var3_9 = null;
            return resultSet;
        }
    }

    public String getSearchStringEscape() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.searchStringEscape == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(26);
            }
            String string = this.implDatabaseMetaData.searchStringEscape;
            Object var3_3 = null;
            return string;
        }
    }

    public String getStringFunctions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.stringFunctions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(23);
            }
            String string = this.implDatabaseMetaData.stringFunctions;
            Object var3_3 = null;
            return string;
        }
    }

    public String getSystemFunctions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.systemFunctions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(24);
            }
            String string = this.implDatabaseMetaData.systemFunctions;
            Object var3_3 = null;
            return string;
        }
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray = new int[]{1, 2, 3};
            Object[] objectArray = new Object[]{string, string2, string3};
            boolean[] blArray = new boolean[3];
            blArray[1] = true;
            blArray[2] = true;
            boolean[] blArray2 = blArray;
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray2);
            int[] nArray2 = new int[]{2, 3, 6};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(16, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_CAT";
            baseColumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_SCHEM";
            baseColumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_NAME";
            baseColumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "GRANTOR";
            baseColumn.name = "GRANTOR";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "GRANTEE";
            baseColumn.name = "GRANTEE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PRIVILEGE";
            baseColumn.name = "PRIVILEGE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "IS_GRANTABLE";
            baseColumn.name = "IS_GRANTABLE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            baseStatement.setupForDatabaseMetaData(baseColumns, 16, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
            ResultSet resultSet = baseStatement.executeQuery(string4);
            Object var6_16 = null;
            return resultSet;
        }
    }

    public ResultSet getTableTypes() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "TABLE_TYPE";
            baseColumn.name = "TABLE_TYPE";
            baseColumn.displaySize = 32;
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            BaseTableTypes baseTableTypes = this.implDatabaseMetaData.getTableTypes();
            String string = baseTableTypes != null ? null : this.implDatabaseMetaData.getResultSetSQL(4, null, null);
            baseStatement.setupForDatabaseMetaData(baseColumns, 4, null, null, baseTableTypes);
            ResultSet resultSet = baseStatement.executeQuery(string);
            Object var3_8 = null;
            return resultSet;
        }
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray = new int[]{1, 2, 3, 4};
            Object[] objectArray = new Object[]{string, string2, string3, stringArray};
            boolean[] blArray = new boolean[4];
            blArray[1] = true;
            blArray[2] = true;
            boolean[] blArray2 = blArray;
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray2);
            int[] nArray2 = new int[]{4, 2, 3};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(1, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_CAT";
            baseColumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_SCHEM";
            baseColumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_NAME";
            baseColumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_TYPE";
            baseColumn.name = "TABLE_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "REMARKS";
            baseColumn.name = "REMARKS";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            baseStatement.setupForDatabaseMetaData(baseColumns, 1, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
            ResultSet resultSet = baseStatement.executeQuery(string4);
            Object var7_17 = null;
            return resultSet;
        }
    }

    public String getTimeDateFunctions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.timeDateFunctions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(25);
            }
            String string = this.implDatabaseMetaData.timeDateFunctions;
            Object var3_3 = null;
            return string;
        }
    }

    public ResultSet getTypeInfo() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "TYPE_NAME";
            baseColumn.name = "TYPE_NAME";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "DATA_TYPE";
            baseColumn.name = "DATA_TYPE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "PRECISION";
            baseColumn.name = "PRECISION";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "LITERAL_PREFIX";
            baseColumn.name = "LITERAL_PREFIX";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "LITERAL_SUFFIX";
            baseColumn.name = "LITERAL_SUFFIX";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "CREATE_PARAMS";
            baseColumn.name = "CREATE_PARAMS";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "NULLABLE";
            baseColumn.name = "NULLABLE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(-7);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "CASE_SENSITIVE";
            baseColumn.name = "CASE_SENSITIVE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "SEARCHABLE";
            baseColumn.name = "SEARCHABLE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(-7);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "UNSIGNED_ATTRIBUTE";
            baseColumn.name = "UNSIGNED_ATTRIBUTE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(-7);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "FIXED_PREC_SCALE";
            baseColumn.name = "FIXED_PREC_SCALE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(-7);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "AUTO_INCREMENT";
            baseColumn.name = "AUTO_INCREMENT";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "LOCAL_TYPE_NAME";
            baseColumn.name = "LOCAL_TYPE_NAME";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "MINIMUM_SCALE";
            baseColumn.name = "MINIMUM_SCALE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "MAXIMUM_SCALE";
            baseColumn.name = "MAXIMUM_SCALE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "SQL_DATA_TYPE";
            baseColumn.name = "SQL_DATA_TYPE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "SQL_DATETIME_SUB";
            baseColumn.name = "SQL_DATETIME_SUB";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "NUM_PREC_RADIX";
            baseColumn.name = "NUM_PREC_RADIX";
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            BaseTypeInfos baseTypeInfos = this.implDatabaseMetaData.getTypeInfo();
            String string = baseTypeInfos != null ? null : this.implDatabaseMetaData.getResultSetSQL(3, null, null);
            baseStatement.setupForDatabaseMetaData(baseColumns, 3, null, null, baseTypeInfos);
            ResultSet resultSet = baseStatement.executeQuery(string);
            Object var3_8 = null;
            return resultSet;
        }
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray2 = new int[]{1, 2, 3, 4};
            Object[] objectArray = new Object[]{string, string2, string3, nArray};
            boolean[] blArray = new boolean[4];
            blArray[1] = true;
            blArray[2] = true;
            boolean[] blArray2 = blArray;
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray2, objectArray, blArray2);
            int[] nArray3 = new int[]{5, 2, 3};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray3);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(17, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_CAT";
            baseColumn.name = "TYPE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_SCHEM";
            baseColumn.name = "TYPE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_NAME";
            baseColumn.name = "TYPE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "CLASS_NAME";
            baseColumn.name = "CLASS_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DATA_TYPE";
            baseColumn.name = "DATA_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "REMARKS";
            baseColumn.name = "REMARKS";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            baseStatement.setupForDatabaseMetaData(baseColumns, 17, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
            ResultSet resultSet = baseStatement.executeQuery(string4);
            Object var7_17 = null;
            return resultSet;
        }
    }

    public String getURL() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            String string = "jdbc:microsoft:" + this.connection.driverName.toLowerCase() + "://" + this.connection.connectProps.get("serverName") + ":" + this.connection.connectProps.get("portNumber");
            Enumeration enumeration = this.connection.connectProps.propertyNames();
            String string2 = null;
            String string3 = null;
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (string2.equals("USER") || string2.equals("PASSWORD") || string2.equals("SERVERNAME") || string2.equals("PORTNUMBER")) continue;
                string3 = this.connection.connectProps.get(string2);
                string = String.valueOf(string) + ";" + string2 + "=" + string3;
            }
            String string4 = string;
            Object var3_7 = null;
            return string4;
        }
    }

    public String getUserName() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            String string = this.connection.connectProps.get("user");
            Object var3_3 = null;
            return string;
        }
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray = new int[]{9, 10, 11};
            Object[] objectArray = new Object[]{string, string2, string3};
            boolean[] blArray = new boolean[3];
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray);
            int[] nArray2 = new int[]{};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(18, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(5);
            baseColumn.label = "SCOPE";
            baseColumn.name = "SCOPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "COLUMN_NAME";
            baseColumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DATA_TYPE";
            baseColumn.name = "DATA_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_NAME";
            baseColumn.name = "TYPE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "COLUMN_SIZE";
            baseColumn.name = "COLUMN_SIZE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "BUFFER_LENGTH";
            baseColumn.name = "BUFFER_LENGTH";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DECIMAL_DIGITS";
            baseColumn.name = "DECIMAL_DIGITS";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "PSEUDO_COLUMN";
            baseColumn.name = "PSEUDO_COLUMN";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            if (!baseResultSetFilterDescriptor.allRestrictionsSatified()) {
                baseColumn = new BaseColumn(12);
                baseColumn.label = "TABLE_CAT";
                baseColumn.name = "TABLE_CAT";
                this.setCommonResultSetMetaData(baseColumn);
                baseColumns.add(baseColumn);
                baseColumn = new BaseColumn(12);
                baseColumn.label = "TABLE_SCHEM";
                baseColumn.name = "TABLE_SCHEM";
                this.setCommonResultSetMetaData(baseColumn);
                baseColumns.add(baseColumn);
                baseColumn = new BaseColumn(12);
                baseColumn.label = "TABLE_NAME";
                baseColumn.name = "TABLE_NAME";
                this.setCommonResultSetMetaData(baseColumn);
                baseColumns.add(baseColumn);
            }
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            baseStatement.setupForDatabaseMetaData(baseColumns, 18, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
            ResultSet resultSet = baseStatement.executeQuery(string4);
            Object var6_16 = null;
            return resultSet;
        }
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: {
                    if (this.implDatabaseMetaData.insertsAreDetectedForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(141);
                    }
                    bl = this.implDatabaseMetaData.insertsAreDetectedForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.insertsAreDetectedScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(142);
                    }
                    bl = this.implDatabaseMetaData.insertsAreDetectedScrollInsensitive;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.insertsAreDetectedScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(143);
                    }
                    bl = this.implDatabaseMetaData.insertsAreDetectedScrollSensitive;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"insertsAreDetected"};
                    throw this.exceptions.getException(6003, stringArray);
                }
            }
            boolean bl2 = bl;
            Object var4_6 = null;
            return bl2;
        }
    }

    public boolean isCatalogAtStart() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.isCatalogAtStart == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(57);
            }
            boolean bl = this.implDatabaseMetaData.isCatalogAtStart;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isReadOnly() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.isReadOnly == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(3);
            }
            boolean bl = this.implDatabaseMetaData.isReadOnly;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.locatorsUpdateCopy == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(145);
                if (this.implDatabaseMetaData.locatorsUpdateCopy == null) {
                    boolean bl = false;
                    Object var3_4 = null;
                    return bl;
                }
            }
            boolean bl = this.implDatabaseMetaData.locatorsUpdateCopy;
            Object var3_5 = null;
            return bl;
        }
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.nullPlusNonNullIsNull == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(31);
            }
            boolean bl = this.implDatabaseMetaData.nullPlusNonNullIsNull;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.nullsAreSortedAtEnd == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(7);
            }
            boolean bl = this.implDatabaseMetaData.nullsAreSortedAtEnd;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.nullsAreSortedAtStart == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(6);
            }
            boolean bl = this.implDatabaseMetaData.nullsAreSortedAtStart;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.nullsAreSortedHigh == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(4);
            }
            boolean bl = this.implDatabaseMetaData.nullsAreSortedHigh;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean nullsAreSortedLow() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.nullsAreSortedLow == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(5);
            }
            boolean bl = this.implDatabaseMetaData.nullsAreSortedLow;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: {
                    if (this.implDatabaseMetaData.othersDeletesAreVisibleForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(129);
                    }
                    bl = this.implDatabaseMetaData.othersDeletesAreVisibleForwardOnly;
                    bl = false;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.othersDeletesAreVisibleScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(130);
                    }
                    bl = this.implDatabaseMetaData.othersDeletesAreVisibleScrollInsensitive;
                    bl = false;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.othersDeletesAreVisibleScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(131);
                    }
                    bl = this.implDatabaseMetaData.othersDeletesAreVisibleScrollSensitive;
                    bl = false;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"othersDeletesAreVisible"};
                    throw this.exceptions.getException(6003, stringArray);
                }
            }
            boolean bl2 = bl;
            Object var4_6 = null;
            return bl2;
        }
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: {
                    if (this.implDatabaseMetaData.othersInsertsAreVisibleForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(132);
                    }
                    bl = this.implDatabaseMetaData.othersInsertsAreVisibleForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.othersInsertsAreVisibleScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(133);
                    }
                    bl = this.implDatabaseMetaData.othersInsertsAreVisibleScrollInsensitive;
                    bl = false;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.othersInsertsAreVisibleScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(134);
                    }
                    bl = this.implDatabaseMetaData.othersInsertsAreVisibleScrollSensitive;
                    bl = false;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"othersInsertsAreVisible"};
                    throw this.exceptions.getException(6003, stringArray);
                }
            }
            boolean bl2 = bl;
            Object var4_6 = null;
            return bl2;
        }
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: {
                    if (this.implDatabaseMetaData.othersUpdatesAreVisibleForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(126);
                    }
                    bl = this.implDatabaseMetaData.othersUpdatesAreVisibleForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.othersUpdatesAreVisibleScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(127);
                    }
                    bl = this.implDatabaseMetaData.othersUpdatesAreVisibleScrollInsensitive;
                    bl = false;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.othersUpdatesAreVisibleScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(128);
                    }
                    bl = this.implDatabaseMetaData.othersUpdatesAreVisibleScrollSensitive;
                    bl = false;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"othersUpdatesAreVisible"};
                    throw this.exceptions.getException(6003, stringArray);
                }
            }
            boolean bl2 = bl;
            Object var4_6 = null;
            return bl2;
        }
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: {
                    if (this.implDatabaseMetaData.ownDeletesAreVisibleForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(120);
                    }
                    bl = this.implDatabaseMetaData.ownDeletesAreVisibleForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.ownDeletesAreVisibleScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(121);
                    }
                    bl = this.implDatabaseMetaData.ownDeletesAreVisibleScrollInsensitive;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.ownDeletesAreVisibleScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(122);
                    }
                    bl = this.implDatabaseMetaData.ownDeletesAreVisibleScrollSensitive;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"ownDeletesAreVisible"};
                    throw this.exceptions.getException(6003, stringArray);
                }
            }
            boolean bl2 = bl = false;
            Object var4_6 = null;
            return bl2;
        }
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: {
                    if (this.implDatabaseMetaData.ownInsertsAreVisibleForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(123);
                    }
                    bl = this.implDatabaseMetaData.ownInsertsAreVisibleForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.ownInsertsAreVisibleScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(124);
                    }
                    bl = this.implDatabaseMetaData.ownInsertsAreVisibleScrollInsensitive;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.ownInsertsAreVisibleScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(125);
                    }
                    bl = this.implDatabaseMetaData.ownInsertsAreVisibleScrollSensitive;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"ownInsertsAreVisible"};
                    throw this.exceptions.getException(6003, stringArray);
                }
            }
            boolean bl2 = bl = false;
            Object var4_6 = null;
            return bl2;
        }
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: {
                    if (this.implDatabaseMetaData.ownUpdatesAreVisibleForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(117);
                    }
                    bl = this.implDatabaseMetaData.ownUpdatesAreVisibleForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.ownUpdatesAreVisibleScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(118);
                    }
                    bl = this.implDatabaseMetaData.ownUpdatesAreVisibleScrollInsensitive;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.ownUpdatesAreVisibleScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(119);
                    }
                    bl = this.implDatabaseMetaData.ownUpdatesAreVisibleScrollSensitive;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"ownUpdatesAreVisible"};
                    throw this.exceptions.getException(6003, stringArray);
                }
            }
            boolean bl2 = bl = false;
            Object var4_6 = null;
            return bl2;
        }
    }

    private void setCommonResultSetMetaData(BaseColumn baseColumn) {
        if (baseColumn.type == 12) {
            baseColumn.displaySize = 128;
        }
        baseColumn.isSigned = false;
        baseColumn.isWritable = false;
        baseColumn.isDefinitelyWritable = false;
        baseColumn.isReadOnly = true;
        baseColumn.isSearchable = false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesLowerCaseIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(14);
            }
            boolean bl = this.implDatabaseMetaData.storesLowerCaseIdentifiers;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesLowerCaseQuotedIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(18);
            }
            boolean bl = this.implDatabaseMetaData.storesLowerCaseQuotedIdentifiers;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesMixedCaseIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(15);
            }
            boolean bl = this.implDatabaseMetaData.storesMixedCaseIdentifiers;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesMixedCaseQuotedIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(19);
            }
            boolean bl = this.implDatabaseMetaData.storesMixedCaseQuotedIdentifiers;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesUpperCaseIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(13);
            }
            boolean bl = this.implDatabaseMetaData.storesUpperCaseIdentifiers;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesUpperCaseQuotedIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(17);
            }
            boolean bl = this.implDatabaseMetaData.storesUpperCaseQuotedIdentifiers;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsANSI92EntryLevelSQL == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(47);
            }
            boolean bl = this.implDatabaseMetaData.supportsANSI92EntryLevelSQL;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsANSI92FullSQL == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(49);
            }
            boolean bl = this.implDatabaseMetaData.supportsANSI92FullSQL;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsANSI92IntermediateSQL == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(48);
            }
            boolean bl = this.implDatabaseMetaData.supportsANSI92IntermediateSQL;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsAlterTableWithAddColumn == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(28);
            }
            boolean bl = this.implDatabaseMetaData.supportsAlterTableWithAddColumn;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsAlterTableWithDropColumn == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(29);
            }
            boolean bl = this.implDatabaseMetaData.supportsAlterTableWithDropColumn;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsBatchUpdates() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = true;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCatalogsInDataManipulation == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(64);
            }
            boolean bl = this.implDatabaseMetaData.supportsCatalogsInDataManipulation;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCatalogsInIndexDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(67);
            }
            boolean bl = this.implDatabaseMetaData.supportsCatalogsInIndexDefinitions;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCatalogsInPrivilegeDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(68);
            }
            boolean bl = this.implDatabaseMetaData.supportsCatalogsInPrivilegeDefinitions;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCatalogsInProcedureCalls == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(65);
            }
            boolean bl = this.implDatabaseMetaData.supportsCatalogsInProcedureCalls;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCatalogsInTableDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(66);
            }
            boolean bl = this.implDatabaseMetaData.supportsCatalogsInTableDefinitions;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsColumnAliasing() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsColumnAliasing == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(30);
            }
            boolean bl = this.implDatabaseMetaData.supportsColumnAliasing;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsConvert() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsConvert == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(32);
            }
            boolean bl = this.implDatabaseMetaData.supportsConvert;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = this.implDatabaseMetaData.supportsConvert(n, n2);
            Object var5_5 = null;
            return bl;
        }
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCoreSQLGrammar == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(45);
            }
            boolean bl = this.implDatabaseMetaData.supportsCoreSQLGrammar;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCorrelatedSubqueries == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(77);
            }
            boolean bl = this.implDatabaseMetaData.supportsCorrelatedSubqueries;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(111);
            }
            boolean bl = this.implDatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsDataManipulationTransactionsOnly == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(112);
            }
            boolean bl = this.implDatabaseMetaData.supportsDataManipulationTransactionsOnly;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsDifferentTableCorrelationNames == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(34);
            }
            boolean bl = this.implDatabaseMetaData.supportsDifferentTableCorrelationNames;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsExpressionsInOrderBy == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(35);
            }
            boolean bl = this.implDatabaseMetaData.supportsExpressionsInOrderBy;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsExtendedSQLGrammar == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(46);
            }
            boolean bl = this.implDatabaseMetaData.supportsExtendedSQLGrammar;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsFullOuterJoins == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(52);
            }
            boolean bl = this.implDatabaseMetaData.supportsFullOuterJoins;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsGroupBy() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsGroupBy == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(37);
            }
            boolean bl = this.implDatabaseMetaData.supportsGroupBy;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsGroupByBeyondSelect == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(39);
            }
            boolean bl = this.implDatabaseMetaData.supportsGroupByBeyondSelect;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsGroupByUnrelated == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(38);
            }
            boolean bl = this.implDatabaseMetaData.supportsGroupByUnrelated;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsIntegrityEnhancementFacility == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(50);
            }
            boolean bl = this.implDatabaseMetaData.supportsIntegrityEnhancementFacility;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsLikeEscapeClause == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(40);
            }
            boolean bl = this.implDatabaseMetaData.supportsLikeEscapeClause;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsLimitedOuterJoins == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(53);
            }
            boolean bl = this.implDatabaseMetaData.supportsLimitedOuterJoins;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsMinimumSQLGrammar == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(44);
            }
            boolean bl = this.implDatabaseMetaData.supportsMinimumSQLGrammar;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsMixedCaseIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(12);
            }
            boolean bl = this.implDatabaseMetaData.supportsMixedCaseIdentifiers;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsMixedCaseQuotedIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(16);
            }
            boolean bl = this.implDatabaseMetaData.supportsMixedCaseQuotedIdentifiers;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsMultipleResultSets == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(41);
            }
            boolean bl = this.implDatabaseMetaData.supportsMultipleResultSets;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsMultipleTransactions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(42);
            }
            boolean bl = this.implDatabaseMetaData.supportsMultipleTransactions;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsNonNullableColumns == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(43);
            }
            boolean bl = this.implDatabaseMetaData.supportsNonNullableColumns;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOpenCursorsAcrossCommit == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(80);
            }
            boolean bl = this.implDatabaseMetaData.supportsOpenCursorsAcrossCommit;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOpenCursorsAcrossRollback == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(81);
            }
            boolean bl = this.implDatabaseMetaData.supportsOpenCursorsAcrossRollback;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOpenStatementsAcrossCommit == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(82);
            }
            boolean bl = this.implDatabaseMetaData.supportsOpenStatementsAcrossCommit;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOpenStatementsAcrossRollback == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(83);
            }
            boolean bl = this.implDatabaseMetaData.supportsOpenStatementsAcrossRollback;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOrderByUnrelated == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(36);
            }
            boolean bl = this.implDatabaseMetaData.supportsOrderByUnrelated;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsOuterJoins() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOuterJoins == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(51);
            }
            boolean bl = this.implDatabaseMetaData.supportsOuterJoins;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsPositionedDelete() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsPositionedDelete == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(69);
            }
            boolean bl = this.implDatabaseMetaData.supportsPositionedDelete;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsPositionedUpdate == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(70);
            }
            boolean bl = this.implDatabaseMetaData.supportsPositionedUpdate;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            switch (n) {
                default: {
                    String[] stringArray = new String[]{"supportsResultSetConcurrency"};
                    throw this.exceptions.getException(6003, stringArray);
                }
                case 1003: 
                case 1004: 
                case 1005: 
            }
            switch (n2) {
                default: {
                    String[] stringArray = new String[]{"supportsResultSetConcurrency"};
                    throw this.exceptions.getException(6003, stringArray);
                }
                case 1007: 
                case 1008: 
            }
            boolean bl = n != 1005;
            Object var5_7 = null;
            return bl;
        }
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: {
                    bl = true;
                    break;
                }
                case 1004: {
                    bl = true;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(116);
                    }
                    bl = this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"supportsResultSetType"};
                    throw this.exceptions.getException(6003, stringArray);
                }
            }
            boolean bl2 = bl;
            Object var4_6 = null;
            return bl2;
        }
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSchemasInDataManipulation == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(59);
            }
            boolean bl = this.implDatabaseMetaData.supportsSchemasInDataManipulation;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSchemasInIndexDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(62);
            }
            boolean bl = this.implDatabaseMetaData.supportsSchemasInIndexDefinitions;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSchemasInPrivilegeDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(63);
            }
            boolean bl = this.implDatabaseMetaData.supportsSchemasInPrivilegeDefinitions;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSchemasInProcedureCalls == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(60);
            }
            boolean bl = this.implDatabaseMetaData.supportsSchemasInProcedureCalls;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSchemasInTableDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(61);
            }
            boolean bl = this.implDatabaseMetaData.supportsSchemasInTableDefinitions;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSelectForUpdate == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(71);
            }
            boolean bl = this.implDatabaseMetaData.supportsSelectForUpdate;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsStoredProcedures() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsStoredProcedures == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(72);
            }
            boolean bl = this.implDatabaseMetaData.supportsStoredProcedures;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSubqueriesInComparisons == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(73);
            }
            boolean bl = this.implDatabaseMetaData.supportsSubqueriesInComparisons;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSubqueriesInExists == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(74);
            }
            boolean bl = this.implDatabaseMetaData.supportsSubqueriesInExists;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSubqueriesInIns == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(75);
            }
            boolean bl = this.implDatabaseMetaData.supportsSubqueriesInIns;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSubqueriesInQuantifieds == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(76);
            }
            boolean bl = this.implDatabaseMetaData.supportsSubqueriesInQuantifieds;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsTableCorrelationNames == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(33);
            }
            boolean bl = this.implDatabaseMetaData.supportsTableCorrelationNames;
            Object var3_3 = null;
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            switch (n) {
                case 2: {
                    if (this.implDatabaseMetaData.supportsTransactionIsolationLevelReadCommited != null) return this.implDatabaseMetaData.supportsTransactionIsolationLevelReadCommited;
                    this.implDatabaseMetaData.initializeNonResultSetMetaData(107);
                    return this.implDatabaseMetaData.supportsTransactionIsolationLevelReadCommited;
                }
                case 1: {
                    if (this.implDatabaseMetaData.supportsTransactionIsolationLevelReadUncommited != null) return this.implDatabaseMetaData.supportsTransactionIsolationLevelReadUncommited;
                    this.implDatabaseMetaData.initializeNonResultSetMetaData(108);
                    return this.implDatabaseMetaData.supportsTransactionIsolationLevelReadUncommited;
                }
                case 4: {
                    if (this.implDatabaseMetaData.supportsTransactionIsolationLevelRepeatableRead != null) return this.implDatabaseMetaData.supportsTransactionIsolationLevelRepeatableRead;
                    this.implDatabaseMetaData.initializeNonResultSetMetaData(109);
                    return this.implDatabaseMetaData.supportsTransactionIsolationLevelRepeatableRead;
                }
                case 8: {
                    if (this.implDatabaseMetaData.supportsTransactionIsolationLevelSerializable != null) return this.implDatabaseMetaData.supportsTransactionIsolationLevelSerializable;
                    this.implDatabaseMetaData.initializeNonResultSetMetaData(110);
                    return this.implDatabaseMetaData.supportsTransactionIsolationLevelSerializable;
                }
            }
            return false;
        }
    }

    public boolean supportsTransactions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsTransactions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(106);
            }
            boolean bl = this.implDatabaseMetaData.supportsTransactions;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsUnion() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsUnion == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(78);
            }
            boolean bl = this.implDatabaseMetaData.supportsUnion;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean supportsUnionAll() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsUnionAll == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(79);
            }
            boolean bl = this.implDatabaseMetaData.supportsUnionAll;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: {
                    if (this.implDatabaseMetaData.updatesAreDetectedForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(135);
                    }
                    bl = this.implDatabaseMetaData.updatesAreDetectedForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.updatesAreDetectedScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(136);
                    }
                    bl = this.implDatabaseMetaData.updatesAreDetectedScrollInsensitive;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.updatesAreDetectedScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(137);
                    }
                    bl = this.implDatabaseMetaData.updatesAreDetectedScrollSensitive;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"updatesAreDetected"};
                    throw this.exceptions.getException(6003, stringArray);
                }
            }
            boolean bl2 = bl;
            Object var4_6 = null;
            return bl2;
        }
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.usesLocalFilePerTable == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(11);
            }
            boolean bl = this.implDatabaseMetaData.usesLocalFilePerTable;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean usesLocalFiles() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.usesLocalFiles == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(10);
            }
            boolean bl = this.implDatabaseMetaData.usesLocalFiles;
            Object var3_3 = null;
            return bl;
        }
    }

    private void validateClosedState() throws SQLException {
        if (this.connection != null && this.connection.isClosed()) {
            this.connection = null;
        }
        if (this.connection == null) {
            throw this.exceptions.getException(6010);
        }
    }
}

