/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.comedia.event.CSpinEvent;
import org.comedia.event.CSpinListener;
import org.comedia.ui.CSpinEdit;

public class CCalendar
extends JComponent
implements ActionListener,
CSpinListener,
FocusListener {
    private final int startYear = 1900;
    private final int endYear = 2100;
    private boolean enabled = true;
    GregorianCalendar calendar = new GregorianCalendar();
    DateFormatSymbols format = new DateFormatSymbols();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel monthPanel = new JPanel();
    JComboBox monthComboBox;
    CSpinEdit yearComboBox = new CSpinEdit();
    GridLayout gridLayout1 = new GridLayout();
    Border border1;
    JPanel dayPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    Border border2;
    TitledBorder titledBorder1;
    CalendarPanel calendarPanel = new CalendarPanel();

    public CCalendar() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public CCalendar(Date date) {
        this();
        this.setDate(date);
    }

    public Date getDate() {
        return this.calendar.getTime();
    }

    public void setDate(Date date) {
        this.calendar.setTime(date);
        this.monthComboBox.setSelectedIndex(this.calendar.get(2));
        this.yearComboBox.setValue(this.calendar.get(1));
        this.calendarPanel.repaint();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.yearComboBox.setEnabled(bl);
        this.monthComboBox.setEnabled(bl);
    }

    private void jbInit() throws Exception {
        this.monthComboBox = new JComboBox<String>(this.format.getMonths());
        this.monthComboBox.setSelectedIndex(this.calendar.get(2));
        this.monthComboBox.addActionListener(this);
        this.yearComboBox.setMinimum(1900);
        this.yearComboBox.setMaximum(2100);
        this.yearComboBox.setValue(this.calendar.get(1));
        this.yearComboBox.getTextField().addActionListener(this);
        this.yearComboBox.getTextField().addFocusListener(this);
        this.yearComboBox.getTextField().setHorizontalAlignment(2);
        this.yearComboBox.getSpinButton().addSpinListener(this);
        this.border1 = BorderFactory.createEmptyBorder(11, 11, 11, 11);
        this.border2 = BorderFactory.createEmptyBorder(0, 11, 11, 11);
        this.titledBorder1 = new TitledBorder("");
        this.setLayout(this.borderLayout1);
        this.monthPanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setHgap(11);
        this.gridLayout1.setVgap(5);
        this.monthPanel.setBorder(this.border1);
        this.dayPanel.setLayout(this.borderLayout2);
        this.dayPanel.setBorder(this.border2);
        this.add((Component)this.monthPanel, "North");
        this.monthPanel.add((Component)this.monthComboBox, null);
        this.monthPanel.add((Component)this.yearComboBox, null);
        this.add((Component)this.dayPanel, "Center");
        this.dayPanel.add((Component)this.calendarPanel, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.monthComboBox.getSelectedIndex();
        int n2 = this.yearComboBox.getValue();
        int n3 = this.calendar.get(5);
        this.calendar.set(5, 1);
        this.calendar.set(1, n2);
        this.calendar.set(2, n);
        if (n3 > this.calendar.getActualMaximum(5)) {
            this.calendar.set(5, this.calendar.getActualMaximum(5));
        } else {
            this.calendar.set(5, n3);
        }
        this.calendarPanel.repaint();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.actionPerformed(null);
    }

    public void spinEventPerformed(CSpinEvent cSpinEvent) {
        this.actionPerformed(null);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        CCalendar cCalendar = new CCalendar();
        JFrame jFrame = new JFrame("Gregorian Calendar");
        jFrame.setContentPane(cCalendar);
        jFrame.setDefaultCloseOperation(3);
        ((Component)jFrame).setSize(300, 300);
        ((Component)jFrame).setLocation(300, 300);
        jFrame.show();
    }

    private class CalendarPanel
    extends JPanel
    implements MouseListener {
        public CalendarPanel() {
            this.addMouseListener(this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            Dimension dimension = this.getSize();
            int n2 = dimension.width / 7;
            int n3 = dimension.height / 7;
            int n4 = mouseEvent.getX() / n2;
            int n5 = mouseEvent.getY() / n3;
            if (n5 == 0 || !CCalendar.this.enabled) {
                return;
            }
            if ((n = --n5 * 7 + n4 + this.findFirstDay()) > 0 && n <= CCalendar.this.calendar.getActualMaximum(5)) {
                CCalendar.this.calendar.set(5, n);
                this.repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private Font findFont(Graphics graphics, String string, int n, int n2) {
            FontMetrics fontMetrics;
            int n3 = 6;
            Font font = new Font(this.getFont().getName(), this.getFont().getStyle(), n3);
            while ((fontMetrics = graphics.getFontMetrics(font)).getHeight() <= n2 && fontMetrics.stringWidth(string) <= n) {
                font = new Font(this.getFont().getName(), this.getFont().getStyle(), ++n3);
            }
            return font;
        }

        private int findFirstDay() {
            int n;
            int n2 = CCalendar.this.calendar.get(7);
            for (n = CCalendar.this.calendar.get(5); n > 1 || n2 != CCalendar.this.calendar.getFirstDayOfWeek(); --n) {
                n2 = --n2 < 1 ? 7 : n2;
            }
            return n;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = dimension.width / 7;
            int n2 = dimension.height / 7;
            Font font = this.findFont(graphics, "Www", n, n2);
            graphics.setFont(font);
            int n3 = CCalendar.this.calendar.get(5);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(Color.gray);
            graphics.fillRect(0, 0, dimension.width, n2);
            int n4 = this.findFirstDay();
            int n5 = CCalendar.this.calendar.getFirstDayOfWeek();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n6 = 0;
            while (n6 < 7) {
                int n7 = 0;
                while (n7 < 7) {
                    String string;
                    int n8 = n7 * n;
                    int n9 = n6 * n2;
                    if (n6 == 0) {
                        graphics.setColor(Color.white);
                        string = CCalendar.this.format.getShortWeekdays()[n5];
                        n5 = ++n5 > 7 ? 1 : n5;
                    } else {
                        if (n4 == n3) {
                            graphics.setColor(Color.blue);
                            graphics.fillRect(n8, n9, n, n2);
                        }
                        if (n4 == n3) {
                            graphics.setColor(Color.white);
                        } else {
                            graphics.setColor(Color.black);
                        }
                        string = n4 > 0 && n4 <= CCalendar.this.calendar.getActualMaximum(5) ? new Integer(n4).toString() : "";
                        ++n4;
                    }
                    graphics.drawString(string, n8 += (n - fontMetrics.stringWidth(string)) / 2, (n9 += (n2 - fontMetrics.getHeight()) / 2) + fontMetrics.getAscent());
                    ++n7;
                }
                ++n6;
            }
            graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, false);
        }
    }
}

