/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableModel;
import org.comedia.ui.CTableNavigator;
import org.comedia.ui.CTableScroller;

public class CDataTable
extends JTable {
    protected EventListenerList listenerList = new EventListenerList();
    private boolean delete = true;
    private boolean insert = true;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public CDataTable() {
        this.setAutoResizeMode(3);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = CDataTable.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = CDataTable.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ItemListener == null ? CDataTable.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) {
                ((ItemListener)objectArray[n + 1]).itemStateChanged(itemEvent);
            }
            n -= 2;
        }
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean bl) {
        this.delete = bl;
    }

    public boolean isInsert() {
        return this.insert;
    }

    public void setInsert(boolean bl) {
        this.insert = bl;
    }

    public int getRowCount() {
        int n = super.getRowCount();
        if (this.insert) {
            ++n;
        }
        return n;
    }

    public Object getValueAt(int n, int n2) {
        if (n < this.getModel().getRowCount()) {
            return this.getModel().getValueAt(n, this.convertColumnIndexToModel(n2));
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n >= this.getModel().getRowCount()) {
            if (this.getModel() instanceof DefaultTableModel) {
                ((DefaultTableModel)this.getModel()).addRow(new Object[this.getModel().getColumnCount()]);
            } else {
                return;
            }
        }
        this.getModel().setValueAt(object, n, this.convertColumnIndexToModel(n2));
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl) {
            this.fireItemStateChanged(null);
        }
        return bl;
    }

    public void editingStopped(ChangeEvent changeEvent) {
        super.editingStopped(changeEvent);
        this.fireItemStateChanged(null);
    }

    public void editingCanceled(ChangeEvent changeEvent) {
        super.editingCanceled(changeEvent);
        this.fireItemStateChanged(null);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isAltDown() || keyEvent.isMetaDown() || keyEvent.isAltGraphDown() || keyEvent.getID() != 401) {
            super.processKeyEvent(keyEvent);
            return;
        }
        if (keyEvent.getKeyCode() == 155 && !keyEvent.isShiftDown() && !keyEvent.isControlDown()) {
            int n;
            int n2 = n = this.getSelectedRow() >= 0 ? this.getSelectedRow() : 0;
            if (this.getModel() instanceof DefaultTableModel) {
                Rectangle rectangle;
                ((DefaultTableModel)this.getModel()).insertRow(n, new Object[this.getColumnCount()]);
                this.removeEditor();
                this.setRowSelectionInterval(n, n);
                if (this.getAutoscrolls() && (rectangle = this.getCellRect(n, this.getSelectedColumn(), false)) != null) {
                    this.scrollRectToVisible(rectangle);
                }
            }
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 127 && !keyEvent.isShiftDown() && keyEvent.isControlDown() && !keyEvent.isActionKey()) {
            if (this.getSelectedRow() >= 0 && this.getModel() instanceof DefaultTableModel) {
                Object object;
                if (this.getAutoscrolls() && (object = this.getCellRect(this.getSelectedRow(), this.getSelectedColumn(), false)) != null) {
                    this.scrollRectToVisible((Rectangle)object);
                }
                if (JOptionPane.showConfirmDialog(null, "You are about to delete " + this.getSelectedRowCount() + " row(s)?", "Confirmation", 0, 3) == 0) {
                    this.removeEditor();
                    object = this.getSelectedRows();
                    int n = ((Object)object).length - 1;
                    while (n >= 0) {
                        if (!this.insert || object[n] != this.getRowCount() - 1) {
                            ((DefaultTableModel)this.getModel()).removeRow((int)object[n]);
                        }
                        --n;
                    }
                }
            }
            keyEvent.consume();
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame jFrame = new JFrame("Comedia Data Grid Test");
        CDataTable cDataTable = new CDataTable();
        CTableScroller cTableScroller = new CTableScroller();
        jFrame.getContentPane().add((Component)cTableScroller, "Center");
        CTableNavigator cTableNavigator = new CTableNavigator(cDataTable);
        jFrame.getContentPane().add((Component)cTableNavigator, "South");
        ((Component)jFrame).setLocation(100, 100);
        ((Component)jFrame).setSize(305, 310);
        jFrame.setDefaultCloseOperation(3);
        jFrame.show();
        DefaultTableModel defaultTableModel = (DefaultTableModel)cDataTable.getModel();
        Object[] objectArray = new String[]{"0", "value 1", "value 2", "value 3"};
        defaultTableModel.addColumn("Id");
        defaultTableModel.addColumn("Column 1");
        defaultTableModel.addColumn("Column 2");
        defaultTableModel.addColumn("Column 3");
        int n = 1;
        while (n < 100) {
            objectArray[0] = new Integer(n).toString();
            defaultTableModel.addRow(objectArray);
            ++n;
        }
        cTableScroller.setTable(cDataTable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

