/*
 * Decompiled with CFR 0.152.
 */
package com.nqadmin.swingSet;

import com.nqadmin.swingSet.SSTextDocument;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.sql.RowSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class SSComboBox
extends JComponent {
    private JTextField textField = new JTextField();
    private JComboBox cmbDisplayed = new JComboBox();
    final MyComboListener cmbListener = new MyComboListener();
    final MyTextFieldDocumentListener textFieldDocumentListener = new MyTextFieldDocumentListener();
    private int option = 0;
    int[] mappingValues = null;
    public static final int YES_NO_OPTION = 0;
    public static final int YES = 1;
    public static final int NO = 0;
    public static final int SEX_OPTION = 1;
    public static final int GENDER_OPTION = 1;
    public static final int MALE = 1;
    public static final int FEMALE = 0;
    public static final int INCLUDE_EXCLUDE_OPTION = 2;
    public static final int EXCLUDE = 0;
    public static final int INCLUDE = 1;

    public SSComboBox() {
    }

    public SSComboBox(SSTextDocument sSTextDocument) {
        this.setDocument(sSTextDocument);
    }

    public int getSelectedIndex() {
        return this.cmbDisplayed.getSelectedIndex();
    }

    public int getSelectedValue() {
        if (this.mappingValues != null) {
            return this.mappingValues[this.cmbDisplayed.getSelectedIndex()];
        }
        return this.cmbDisplayed.getSelectedIndex();
    }

    public void bind(RowSet rowSet, String string) {
        this.textField.setDocument(new SSTextDocument(rowSet, string));
        try {
            this.textField.setText(String.valueOf(rowSet.getInt(string)));
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.setDisplay();
        this.addListeners();
    }

    private void setDisplay() {
        Document document = this.textField.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            if (string != null) {
                int n = 0;
                if (!string.trim().equals("")) {
                    n = Integer.parseInt(string);
                }
                if (this.mappingValues == null && n != this.cmbDisplayed.getSelectedIndex()) {
                    this.cmbDisplayed.setSelectedIndex(n);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
    }

    private void addListeners() {
        this.textField.getDocument().addDocumentListener(this.textFieldDocumentListener);
        this.cmbDisplayed.addActionListener(this.cmbListener);
    }

    public void setDocument(SSTextDocument sSTextDocument) {
        this.textField.setDocument(sSTextDocument);
        this.setDisplay();
        this.addListeners();
    }

    public JComboBox getComboBox() {
        return this.cmbDisplayed;
    }

    public boolean setOption(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.cmbDisplayed.addItem(stringArray[i]);
        }
        return true;
    }

    public void setMappingValues(int[] nArray) {
        this.mappingValues = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.mappingValues[i] = nArray[i];
        }
    }

    public boolean setOption(String[] stringArray, int[] nArray) {
        int n;
        if (stringArray.length != nArray.length) {
            return false;
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.cmbDisplayed.addItem(stringArray[n]);
        }
        this.mappingValues = new int[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            this.mappingValues[n] = nArray[n];
        }
        return true;
    }

    public void setOption(int n, int[] nArray) {
        this.mappingValues = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.mappingValues[i] = nArray[i];
        }
        this.setOption(n);
    }

    public boolean setOption(int n) {
        this.option = n;
        if (n == 0) {
            this.cmbDisplayed.addItem(new String("NO"));
            this.cmbDisplayed.addItem(new String("YES"));
        } else if (n == 1 || n == 1) {
            this.cmbDisplayed.addItem(new String("FEMALE"));
            this.cmbDisplayed.addItem(new String("MALE"));
        } else if (n == 2) {
            this.cmbDisplayed.addItem(new String("INCLUDE"));
            this.cmbDisplayed.addItem(new String("EXCLUDE"));
        } else {
            return false;
        }
        return true;
    }

    private class MyComboListener
    implements ActionListener {
        private MyComboListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SSComboBox.this.textField.getDocument().removeDocumentListener(SSComboBox.this.textFieldDocumentListener);
            int n = SSComboBox.this.cmbDisplayed.getSelectedIndex();
            try {
                String string = SSComboBox.this.textField.getText();
                int n2 = -1;
                string.trim();
                if (!string.equals("")) {
                    n2 = Integer.parseInt(string);
                }
                if (n2 != n) {
                    SSComboBox.this.textField.setText(String.valueOf(n));
                }
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            SSComboBox.this.textField.getDocument().addDocumentListener(SSComboBox.this.textFieldDocumentListener);
        }
    }

    private class MyTextFieldDocumentListener
    implements DocumentListener {
        private MyTextFieldDocumentListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            SSComboBox.this.cmbDisplayed.removeActionListener(SSComboBox.this.cmbListener);
            Document document = SSComboBox.this.textField.getDocument();
            try {
                String string = document.getText(0, document.getLength());
                if (string != null) {
                    int n = 0;
                    if (!string.trim().equals("")) {
                        n = Integer.parseInt(string);
                    }
                    if (SSComboBox.this.mappingValues == null && n != SSComboBox.this.cmbDisplayed.getSelectedIndex() || SSComboBox.this.mappingValues != null && SSComboBox.this.mappingValues[SSComboBox.this.cmbDisplayed.getSelectedIndex()] != n) {
                        if (SSComboBox.this.mappingValues == null && (n < 0 || n >= SSComboBox.this.cmbDisplayed.getItemCount())) {
                            System.out.println("Error: value from DB:" + n + "  items in combo box: " + SSComboBox.this.cmbDisplayed.getItemCount());
                        } else if (SSComboBox.this.mappingValues != null) {
                            int n2;
                            for (n2 = 0; n2 < SSComboBox.this.mappingValues.length; ++n2) {
                                if (SSComboBox.this.mappingValues[n2] != n) continue;
                                SSComboBox.this.cmbDisplayed.setSelectedIndex(n2);
                                break;
                            }
                            if (n2 == SSComboBox.this.mappingValues.length) {
                                System.out.println("change ERROR: could not find a corresponding item in combo for value " + n);
                            }
                        } else {
                            SSComboBox.this.cmbDisplayed.setSelectedIndex(n);
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            SSComboBox.this.cmbDisplayed.addActionListener(SSComboBox.this.cmbListener);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            SSComboBox.this.cmbDisplayed.removeActionListener(SSComboBox.this.cmbListener);
            Document document = SSComboBox.this.textField.getDocument();
            try {
                String string = document.getText(0, document.getLength());
                if (string != null) {
                    int n = 0;
                    if (!string.trim().equals("")) {
                        n = Integer.parseInt(string);
                    }
                    if (SSComboBox.this.mappingValues == null && n != SSComboBox.this.cmbDisplayed.getSelectedIndex() || SSComboBox.this.mappingValues != null && SSComboBox.this.mappingValues[SSComboBox.this.cmbDisplayed.getSelectedIndex()] != n) {
                        if (SSComboBox.this.mappingValues == null && (n < 0 || n >= SSComboBox.this.cmbDisplayed.getItemCount())) {
                            System.out.println("Error: value from DB:" + n + "  items in combo box: " + SSComboBox.this.cmbDisplayed.getItemCount());
                        } else if (SSComboBox.this.mappingValues != null) {
                            int n2;
                            for (n2 = 0; n2 < SSComboBox.this.mappingValues.length; ++n2) {
                                if (SSComboBox.this.mappingValues[n2] != n) continue;
                                SSComboBox.this.cmbDisplayed.setSelectedIndex(n2);
                                break;
                            }
                            if (n2 == SSComboBox.this.mappingValues.length) {
                                System.out.println("insert ERROR: could not find a corresponding item in combo for value " + n);
                            }
                        } else {
                            SSComboBox.this.cmbDisplayed.setSelectedIndex(n);
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            SSComboBox.this.cmbDisplayed.addActionListener(SSComboBox.this.cmbListener);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
        }
    }
}

