/*
 * Decompiled with CFR 0.152.
 */
package com.nqadmin.swingSet;

import com.nqadmin.swingSet.SSCellEditing;
import com.nqadmin.swingSet.SSDataValue;
import com.nqadmin.swingSet.SSTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.sql.Date;
import java.sql.SQLException;
import java.util.EventObject;
import java.util.GregorianCalendar;
import javax.sql.RowSet;
import javax.sql.RowSetMetaData;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SSDataGrid
extends JTable {
    Component window = null;
    private RowSet rowset = null;
    private int columnCount = -1;
    private int rowCount = -1;
    private RowSetMetaData metaData = null;
    SSTableModel tableModel = null;
    JScrollPane scrollPane = null;
    protected int[] hiddenColumns = null;
    protected String[] hiddenColumnNames = null;

    public SSDataGrid(RowSet rowSet) {
        this.rowset = rowSet;
        this.init();
    }

    public SSDataGrid() {
        this.tableModel = new SSTableModel();
    }

    public void setMessageWindow(Component component) {
        this.window = component;
        this.tableModel.setMessageWindow(this.window);
    }

    private void init() {
        try {
            this.rowset.execute();
            if (this.tableModel == null) {
                this.tableModel = new SSTableModel(this.rowset);
            } else {
                this.tableModel.setRowSet(this.rowset);
            }
            this.rowCount = this.tableModel.getRowCount();
            this.columnCount = this.tableModel.getColumnCount();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.setModel(this.tableModel);
        this.tableModel.setMessageWindow(this.window);
        this.tableModel.setJTable(this);
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = tableColumnModel.getColumnCount() - 1; i >= 0; --i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n = -1;
            if (this.hiddenColumns != null) {
                for (n = 0; n < this.hiddenColumns.length; ++n) {
                    if (this.hiddenColumns[n] != i) continue;
                    tableColumn.setMaxWidth(0);
                    tableColumn.setMinWidth(0);
                    tableColumn.setPreferredWidth(0);
                    break;
                }
                if (n != this.hiddenColumns.length) continue;
                tableColumn.setMinWidth(100);
                continue;
            }
            tableColumn.setMinWidth(100);
        }
        this.addKeyListener(new KeyAdapter(){
            private boolean controlPressed = false;

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 17) {
                    this.controlPressed = true;
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 17) {
                    this.controlPressed = false;
                }
                if (keyEvent.getKeyCode() == 88) {
                    int n;
                    if (!this.controlPressed) {
                        return;
                    }
                    int n2 = SSDataGrid.this.getSelectedRowCount();
                    if (n2 == 0) {
                        return;
                    }
                    int[] nArray = SSDataGrid.this.getSelectedRows();
                    if (SSDataGrid.this.window != null && (n = JOptionPane.showConfirmDialog(SSDataGrid.this.window, "You are about to delete " + nArray.length + " rows. " + "\nAre you sure you want to delete the rows?")) != 0) {
                        return;
                    }
                    for (n = nArray.length - 1; n >= 0; --n) {
                        SSDataGrid.this.tableModel.deleteRow(nArray[n]);
                    }
                    SSDataGrid.this.updateUI();
                }
            }
        });
        this.setAutoResizeMode(0);
        this.scrollPane = new JScrollPane(this, 20, 30);
    }

    public void setRowSet(RowSet rowSet) {
        boolean bl = false;
        if (this.rowset != null) {
            bl = true;
        }
        if (this.rowset == null) {
            this.rowset = rowSet;
            this.init();
        } else {
            this.rowset = rowSet;
            try {
                this.tableModel.setRowSet(this.rowset);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        if (bl) {
            this.updateUI();
        }
    }

    public void setPreferredSize(Dimension dimension) {
        this.scrollPane.setPreferredSize(dimension);
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    public void setDefaultValues(int[] nArray, Object[] objectArray) {
        if (this.tableModel == null) {
            this.tableModel = new SSTableModel();
        }
        this.tableModel.setDefaultValues(nArray, objectArray);
    }

    public void setDefaultValues(String[] stringArray, Object[] objectArray) throws SQLException {
        int[] nArray = null;
        if (this.tableModel == null) {
            this.tableModel = new SSTableModel();
        }
        if (stringArray != null) {
            nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = this.rowset.findColumn(stringArray[i]) - 1;
            }
        }
        this.tableModel.setDefaultValues(nArray, objectArray);
    }

    public Object getDefaultValue(int n) {
        return this.tableModel.getDefaultValue(n);
    }

    public Object getDefaultValue(String string) throws SQLException {
        int n = this.rowset.findColumn(string);
        return this.tableModel.getDefaultValue(n - 1);
    }

    public void updateUI() {
        super.updateUI();
    }

    public void setPrimaryColumn(int n) {
        this.tableModel.setPrimaryColumn(n);
    }

    public void setPrimaryColumn(String string) throws SQLException {
        int n = this.rowset.findColumn(string) - 1;
        this.tableModel.setPrimaryColumn(n);
    }

    public void setSSDataValue(SSDataValue sSDataValue) {
        this.tableModel.setSSDataValue(sSDataValue);
    }

    public void setDateRenderer(int n) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setCellRenderer(new DateRenderer());
        tableColumn.setCellEditor(new DateEditor());
    }

    public void setDateRenderer(String string) throws SQLException {
        int n = this.rowset.findColumn(string) - 1;
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setCellRenderer(new DateRenderer());
        tableColumn.setCellEditor(new DateEditor());
    }

    public void setComboRenderer(int n, Object[] objectArray, Object[] objectArray2) {
        this.setRowHeight(20);
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setCellRenderer(new ComboRenderer(objectArray, objectArray2));
        tableColumn.setCellEditor(new ComboEditor(objectArray, objectArray2));
        tableColumn.setMinWidth(250);
    }

    public void setComboRenderer(String string, Object[] objectArray, Object[] objectArray2) throws SQLException {
        int n = this.rowset.findColumn(string) - 1;
        this.setRowHeight(20);
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setCellRenderer(new ComboRenderer(objectArray, objectArray2));
        tableColumn.setCellEditor(new ComboEditor(objectArray, objectArray2));
        tableColumn.setMinWidth(250);
    }

    public void setHeaders(String[] stringArray) {
        this.tableModel.setHeaders(stringArray);
    }

    public void setUneditableColumns(int[] nArray) {
        this.tableModel.setUneditableColumns(nArray);
    }

    public void setUneditableColumns(String[] stringArray) throws SQLException {
        int[] nArray = null;
        if (stringArray != null) {
            nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = this.rowset.findColumn(stringArray[i]) - 1;
            }
        }
        this.tableModel.setUneditableColumns(nArray);
    }

    public void setHiddenColumns(int[] nArray) {
        this.hiddenColumns = nArray;
        this.tableModel.setHiddenColumns(nArray);
    }

    public void setHiddenColumns(String[] stringArray) throws SQLException {
        this.hiddenColumns = null;
        if (stringArray != null) {
            this.hiddenColumns = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.hiddenColumns[i] = this.rowset.findColumn(stringArray[i]) - 1;
            }
            TableColumnModel tableColumnModel = this.getColumnModel();
            for (int i = 0; i < this.hiddenColumns.length; ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(this.hiddenColumns[i]);
                tableColumn.setMinWidth(0);
                tableColumn.setMaxWidth(0);
                tableColumn.setPreferredWidth(0);
            }
            this.updateUI();
        }
        this.tableModel.setHiddenColumns(this.hiddenColumns);
    }

    public void setSSCellEditing(SSCellEditing sSCellEditing) {
        this.tableModel.setSSCellEditing(sSCellEditing);
    }

    private String dateMask(String string, KeyEvent keyEvent) {
        switch (string.length()) {
            case 1: {
                if (keyEvent.getKeyChar() != '/') break;
                string = "0" + string;
                break;
            }
            case 2: {
                if (keyEvent.getKeyChar() == '/') break;
                string = string + "/";
                break;
            }
            case 4: {
                if (keyEvent.getKeyChar() != '/') break;
                String string2 = string.substring(0, 3);
                string = string2 = string2 + "0" + string.substring(3, 4);
                break;
            }
            case 5: {
                if (keyEvent.getKeyChar() == '/') break;
                string = string + "/";
            }
        }
        return string;
    }

    static /* synthetic */ String access$200(SSDataGrid sSDataGrid, String string, KeyEvent keyEvent) {
        return sSDataGrid.dateMask(string, keyEvent);
    }

    private class ComboEditor
    extends DefaultCellEditor {
        Object[] underlyingValues = null;
        int clickCountToStart = 2;

        public ComboEditor(Object[] objectArray, Object[] objectArray2) {
            super(new JComboBox<Object>(objectArray));
            this.underlyingValues = objectArray2;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
            }
            return true;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JComboBox jComboBox = (JComboBox)this.getComponent();
            jComboBox.setSelectedIndex(this.getIndexOf(object));
            return jComboBox;
        }

        public Object getCellEditorValue() {
            if (this.underlyingValues == null) {
                return new Integer(((JComboBox)this.getComponent()).getSelectedIndex());
            }
            int n = ((JComboBox)this.getComponent()).getSelectedIndex();
            if (n == -1) {
                return this.underlyingValues[0];
            }
            return this.underlyingValues[n];
        }

        private int getIndexOf(Object object) {
            if (this.underlyingValues == null) {
                return (Integer)object;
            }
            for (int i = 0; i < this.underlyingValues.length; ++i) {
                if (!this.underlyingValues[i].equals(object)) continue;
                return i;
            }
            return 0;
        }
    }

    private class ComboRenderer
    extends JComboBox
    implements TableCellRenderer {
        Object[] underlyingValues = null;

        public ComboRenderer(Object[] objectArray, Object[] objectArray2) {
            super(objectArray);
            this.underlyingValues = objectArray2;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.getItemCount() > 0) {
                this.setSelectedIndex(this.getIndexOf(object));
            } else {
                System.out.println("Combo Renderer: No item in combo that corresponds to " + object);
            }
            return this;
        }

        private int getIndexOf(Object object) {
            if (object == null) {
                return 0;
            }
            if (this.underlyingValues == null) {
                return (Integer)object;
            }
            for (int i = 0; i < this.underlyingValues.length; ++i) {
                if (!this.underlyingValues[i].equals(object)) continue;
                return i;
            }
            return 0;
        }
    }

    private class DateRenderer
    extends DefaultTableCellRenderer {
        private DateRenderer() {
        }

        public void setValue(Object object) {
            if (object instanceof Date) {
                Date date = (Date)object;
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
                String string = "" + (gregorianCalendar.get(2) + 1) + "/" + gregorianCalendar.get(5) + "/" + gregorianCalendar.get(1);
                this.setHorizontalAlignment(0);
                this.setText(string);
            } else {
                super.setValue(object);
            }
        }
    }

    private class DateEditor
    extends DefaultCellEditor {
        public DateEditor() {
            super(new JTextField());
            super.setClickCountToStart(2);
            KeyListener[] keyListenerArray = this.getComponent().getKeyListeners();
            for (int i = 0; i < keyListenerArray.length; ++i) {
                this.getComponent().removeKeyListener(keyListenerArray[i]);
            }
            this.getComponent().addKeyListener(new KeyListener(this, SSDataGrid.this){
                private final /* synthetic */ SSDataGrid val$this$0;
                private final /* synthetic */ DateEditor this$1;
                {
                    this.this$1 = dateEditor;
                    this.val$this$0 = sSDataGrid;
                }

                public void keyReleased(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                }

                public synchronized void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8 || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 36 || keyEvent.getKeyCode() == 35 || keyEvent.getKeyCode() == 10) {
                        return;
                    }
                    String string = ((JTextField)this.this$1.getComponent()).getText();
                    String string2 = SSDataGrid.access$200(DateEditor.access$100(this.this$1), string, keyEvent);
                    ((JTextField)this.this$1.getComponent()).setText(string2);
                }
            });
        }

        public synchronized Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof Date) {
                Date date = (Date)object;
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
                String string = "" + (gregorianCalendar.get(2) + 1) + "/" + gregorianCalendar.get(5) + "/" + gregorianCalendar.get(1);
                return super.getTableCellEditorComponent(jTable, string, bl, n, n2);
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() >= this.getClickCountToStart();
            }
            return true;
        }

        static /* synthetic */ SSDataGrid access$100(DateEditor dateEditor) {
            return dateEditor.SSDataGrid.this;
        }
    }
}

