/*
 * Decompiled with CFR 0.152.
 */
package com.nqadmin.swingSet;

import com.nqadmin.swingSet.SSCellEditing;
import com.nqadmin.swingSet.SSDataValue;
import java.awt.Component;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.sql.RowSet;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class SSTableModel
extends AbstractTableModel {
    RowSet rowset = null;
    ResultSetMetaData metaData = null;
    int rowCount = 0;
    int columnCount = 0;
    HashMap defaultValuesMap = null;
    private boolean inInsertRow = false;
    Component component = null;
    JTable table = null;
    String[] headers = null;
    int primaryColumn = -1;
    Object primaryValue = null;
    SSDataValue dataValue = null;
    SSCellEditing cellEditing = null;
    int[] uneditableColumns = null;
    int[] hiddenColumns = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$Object;

    public SSTableModel() {
    }

    public SSTableModel(RowSet rowSet) throws SQLException {
        this.rowset = rowSet;
        this.init();
    }

    public void setRowSet(RowSet rowSet) throws SQLException {
        this.rowset = rowSet;
        this.init();
    }

    public void setSSCellEditing(SSCellEditing sSCellEditing) {
        this.cellEditing = sSCellEditing;
    }

    private void init() {
        try {
            this.metaData = this.rowset.getMetaData();
            this.columnCount = this.metaData.getColumnCount();
            this.rowset.last();
            this.rowCount = this.rowset.getRow();
            this.rowset.first();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getRowCount() {
        return this.rowCount + 1;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.uneditableColumns != null) {
            for (int i = 0; i < this.uneditableColumns.length; ++i) {
                if (n2 != this.uneditableColumns[i]) continue;
                return false;
            }
        }
        if (this.cellEditing != null) {
            return this.cellEditing.isCellEditable(n, n2);
        }
        return true;
    }

    public Object getValueAt(int n, int n2) {
        Object object;
        block11: {
            object = null;
            if (n == this.rowCount) {
                object = this.getDefaultValue(n2);
                return object;
            }
            try {
                this.rowset.absolute(n + 1);
                int n3 = this.metaData.getColumnType(n2 + 1);
                switch (n3) {
                    case -6: 
                    case 4: 
                    case 5: {
                        object = new Integer(this.rowset.getInt(n2 + 1));
                        break;
                    }
                    case -5: {
                        object = new Long(this.rowset.getLong(n2 + 1));
                        break;
                    }
                    case 6: 
                    case 8: {
                        object = new Double(this.rowset.getDouble(n2 + 1));
                        break;
                    }
                    case -7: {
                        object = new Boolean(this.rowset.getBoolean(n2 + 1));
                        break;
                    }
                    case 91: {
                        object = this.rowset.getDate(n2 + 1);
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        object = this.rowset.getString(n2 + 1);
                        break;
                    }
                    default: {
                        System.out.println("SSTableModel.getValueAt(): Unknown data type");
                        break;
                    }
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                if (this.component == null) break block11;
                JOptionPane.showMessageDialog(this.component, "Error while retrieving value.\n" + sQLException.getMessage());
            }
        }
        return object;
    }

    public void setValueAt(Object object, int n, int n2) {
        block16: {
            int n3;
            if (this.cellEditing != null && (n3 = n == this.rowCount ? this.cellEditing.cellUpdateRequested(n, n2, null, object) : this.cellEditing.cellUpdateRequested(n, n2, this.getValueAt(n, n2), object)) == 0) {
                return;
            }
            if (n == this.rowCount) {
                this.insertRow(object, n2);
                return;
            }
            try {
                if (this.rowset.getRow() != n + 1) {
                    this.rowset.absolute(n + 1);
                }
                if (object == null) {
                    this.rowset.updateNull(n2 + 1);
                    return;
                }
                n3 = this.metaData.getColumnType(n2 + 1);
                switch (n3) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.rowset.updateInt(n2 + 1, (int)((Integer)object));
                        break;
                    }
                    case -5: {
                        break;
                    }
                    case 6: 
                    case 8: {
                        this.rowset.updateDouble(n2 + 1, (double)((Double)object));
                        break;
                    }
                    case -7: {
                        this.rowset.updateBoolean(n2 + 1, (boolean)((Boolean)object));
                        break;
                    }
                    case 91: {
                        if (object instanceof String) {
                            if (this.getSQLDate((String)object) == null) {
                                this.rowset.updateNull(n2 + 1);
                                break;
                            }
                            this.rowset.updateDate(n2 + 1, this.getSQLDate((String)object));
                            break;
                        }
                        this.rowset.updateDate(n2 + 1, (Date)object);
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        this.rowset.updateString(n2 + 1, (String)object);
                        break;
                    }
                    default: {
                        System.out.println("SSTableModel.setValueAt(): Unknown data type");
                    }
                }
                this.rowset.updateRow();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                if (this.component == null) break block16;
                JOptionPane.showMessageDialog(this.component, "Error while updating the value.\n" + sQLException.getMessage());
            }
        }
    }

    private void insertRow(Object object, int n) {
        block17: {
            if (object == null) {
                return;
            }
            try {
                if (!this.inInsertRow) {
                    this.rowset.moveToInsertRow();
                    this.setDefaults();
                    this.inInsertRow = true;
                    if (this.dataValue != null) {
                        this.setPrimaryColumn();
                    }
                }
                int n2 = this.metaData.getColumnType(n + 1);
                switch (n2) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.rowset.updateInt(n + 1, (int)((Integer)object));
                        break;
                    }
                    case -5: {
                        break;
                    }
                    case 6: 
                    case 8: {
                        this.rowset.updateDouble(n + 1, (double)((Double)object));
                        break;
                    }
                    case -7: {
                        this.rowset.updateBoolean(n + 1, (boolean)((Boolean)object));
                        break;
                    }
                    case 91: {
                        if (object instanceof String) {
                            this.rowset.updateDate(n + 1, this.getSQLDate((String)object));
                            break;
                        }
                        this.rowset.updateDate(n + 1, (Date)object);
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        this.rowset.updateString(n + 1, (String)object);
                        break;
                    }
                    default: {
                        System.out.println("SSTableModel.setValueAt(): Unknown data type");
                    }
                }
                this.rowset.insertRow();
                if (this.rowCount != 0) {
                    this.rowset.moveToCurrentRow();
                } else {
                    this.rowset.first();
                }
                this.rowset.refreshRow();
                if (this.table != null) {
                    this.table.updateUI();
                }
                this.inInsertRow = false;
                ++this.rowCount;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                if (this.component == null) break block17;
                JOptionPane.showMessageDialog(this.component, "Error while trying to insert row.\n" + sQLException.getMessage());
            }
        }
    }

    private void setDefaults() {
        block12: {
            if (this.defaultValuesMap == null) {
                return;
            }
            Set set = this.defaultValuesMap.keySet();
            Iterator iterator = set.iterator();
            try {
                block10: while (iterator.hasNext()) {
                    Integer n = (Integer)iterator.next();
                    int n2 = this.metaData.getColumnType(n + 1);
                    switch (n2) {
                        case -6: 
                        case 4: 
                        case 5: {
                            this.rowset.updateInt(n + 1, (int)((Integer)this.defaultValuesMap.get(n)));
                            continue block10;
                        }
                        case -5: {
                            this.rowset.updateLong(n + 1, (long)((Long)this.defaultValuesMap.get(n)));
                            continue block10;
                        }
                        case 6: 
                        case 8: {
                            this.rowset.updateDouble(n + 1, (double)((Double)this.defaultValuesMap.get(n)));
                            continue block10;
                        }
                        case -7: {
                            this.rowset.updateBoolean(n + 1, (boolean)((Boolean)this.defaultValuesMap.get(n)));
                            continue block10;
                        }
                        case 91: {
                            this.rowset.updateDate(n + 1, (Date)this.defaultValuesMap.get(n));
                            continue block10;
                        }
                        case -1: 
                        case 1: 
                        case 12: {
                            this.rowset.updateString(n + 1, (String)this.defaultValuesMap.get(n));
                            continue block10;
                        }
                    }
                    System.out.println("SSTableModel.setValueAt(): Unknown data type");
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                if (this.component == null) break block12;
                JOptionPane.showMessageDialog(this.component, "Error while inserting row.\n" + sQLException.getMessage());
            }
        }
    }

    public Class getColumnClass(int n) {
        int n2;
        try {
            n2 = this.metaData.getColumnType(n + 1);
        }
        catch (SQLException sQLException) {
            return super.getColumnClass(n);
        }
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                return class$java$lang$String == null ? (class$java$lang$String = SSTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case -7: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = SSTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            case -6: 
            case 4: 
            case 5: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = SSTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case -5: {
                return class$java$lang$Long == null ? (class$java$lang$Long = SSTableModel.class$("java.lang.Long")) : class$java$lang$Long;
            }
            case 6: 
            case 8: {
                return class$java$lang$Double == null ? (class$java$lang$Double = SSTableModel.class$("java.lang.Double")) : class$java$lang$Double;
            }
            case 91: {
                return class$java$sql$Date == null ? (class$java$sql$Date = SSTableModel.class$("java.sql.Date")) : class$java$sql$Date;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = SSTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public boolean deleteRow(int n) {
        block3: {
            if (n < this.rowCount) {
                try {
                    this.rowset.absolute(n + 1);
                    this.rowset.deleteRow();
                    --this.rowCount;
                    return true;
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    if (this.component == null) break block3;
                    JOptionPane.showMessageDialog(this.component, "Error while deleting row.\n" + sQLException.getMessage());
                }
            }
        }
        return false;
    }

    public void setDefaultValues(int[] nArray, Object[] objectArray) {
        if (nArray == null || objectArray == null) {
            this.defaultValuesMap = null;
        }
        if (this.defaultValuesMap == null) {
            this.defaultValuesMap = new HashMap();
        } else {
            this.defaultValuesMap.clear();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.defaultValuesMap.put(new Integer(nArray[i]), objectArray[i]);
        }
    }

    public Object getDefaultValue(int n) {
        Object var2_2 = null;
        if (this.defaultValuesMap != null) {
            var2_2 = this.defaultValuesMap.get(new Integer(n));
        }
        return var2_2;
    }

    public void setMessageWindow(Component component) {
        this.component = component;
    }

    public void setJTable(JTable jTable) {
        this.table = jTable;
    }

    public void setPrimaryColumn(int n) {
        this.primaryColumn = n;
    }

    public void setSSDataValue(SSDataValue sSDataValue) {
        this.dataValue = sSDataValue;
    }

    private void setPrimaryColumn() {
        block10: {
            try {
                int n = this.metaData.getColumnType(this.primaryColumn + 1);
                switch (n) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.rowset.updateInt(this.primaryColumn + 1, (int)((Integer)this.dataValue.getPrimaryColumnValue()));
                        break;
                    }
                    case -5: {
                        this.rowset.updateLong(this.primaryColumn + 1, (long)((Long)this.dataValue.getPrimaryColumnValue()));
                        break;
                    }
                    case 6: 
                    case 8: {
                        this.rowset.updateDouble(this.primaryColumn + 1, (double)((Double)this.dataValue.getPrimaryColumnValue()));
                        break;
                    }
                    case -7: {
                        this.rowset.updateBoolean(this.primaryColumn + 1, (boolean)((Boolean)this.dataValue.getPrimaryColumnValue()));
                        break;
                    }
                    case 91: {
                        this.rowset.updateDate(this.primaryColumn + 1, (Date)this.dataValue.getPrimaryColumnValue());
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        this.rowset.updateString(this.primaryColumn + 1, (String)this.dataValue.getPrimaryColumnValue());
                        break;
                    }
                    default: {
                        System.out.println("SSTableModel.setPrimaryColumn(): Unknown data type");
                        break;
                    }
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                if (this.component == null) break block10;
                JOptionPane.showMessageDialog(this.component, "Error while inserting Primary Key value.\n" + sQLException.getMessage());
            }
        }
    }

    private Date getSQLDate(String string) {
        if (string.trim().equals("")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", false);
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken() + "-" + string2 + "-" + string3;
        return Date.valueOf(string4);
    }

    public void setHeaders(String[] stringArray) {
        this.headers = stringArray;
    }

    public String getColumnName(int n) {
        if (this.headers != null && n < this.headers.length) {
            return this.headers[n];
        }
        return "";
    }

    public void setUneditableColumns(int[] nArray) {
        this.uneditableColumns = nArray;
    }

    public void setHiddenColumns(int[] nArray) {
        this.hiddenColumns = nArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

