/*
 * Decompiled with CFR 0.152.
 */
package com.nqadmin.swingSet;

import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;

public class SSTextDocument
extends PlainDocument {
    int columnType = -1;
    RowSet rs = null;
    String columnName = null;
    int columnIndex = -1;
    int pkIndex = -1;
    long pkValue = -1L;
    SimpleAttributeSet attribute = new SimpleAttributeSet();
    MyRowSetListener rowSetListener = new MyRowSetListener();
    MyDocumentListener documentListener = new MyDocumentListener();

    public SSTextDocument(RowSet rowSet, String string) {
        this.rs = rowSet;
        this.columnName = string;
        try {
            this.columnIndex = this.rs.findColumn(this.columnName);
            ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
            this.columnType = resultSetMetaData.getColumnType(this.columnIndex);
            if (this.rs.getRow() != 0) {
                String string2 = this.getText();
                this.insertString(0, string2, this.attribute);
                this.insertUpdate(new AbstractDocument.DefaultDocumentEvent(this, 0, this.getLength(), DocumentEvent.EventType.INSERT), this.attribute);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.rs.addRowSetListener(this.rowSetListener);
        this.addDocumentListener(this.documentListener);
    }

    public SSTextDocument(RowSet rowSet, int n) {
        this.rs = rowSet;
        this.columnIndex = n;
        try {
            String string;
            ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
            this.columnType = resultSetMetaData.getColumnType(this.columnIndex);
            this.columnName = resultSetMetaData.getColumnName(this.columnIndex);
            if (this.rs.getRow() != 0 && (string = this.getText()) != null && string.length() > 0) {
                string = string.replace('\r', ' ');
                this.insertString(0, string, this.attribute);
                this.insertUpdate(new AbstractDocument.DefaultDocumentEvent(this, 0, this.getLength(), DocumentEvent.EventType.INSERT), this.attribute);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.rs.addRowSetListener(this.rowSetListener);
        this.addDocumentListener(this.documentListener);
    }

    private void updateText(String string) {
        try {
            string.trim();
            switch (this.columnType) {
                case 16: {
                    if (string.equals("")) {
                        this.rs.updateNull(this.columnName);
                        break;
                    }
                    boolean bl = Boolean.getBoolean(string);
                    this.rs.updateBoolean(this.columnName, bl);
                    break;
                }
                case 5: {
                    if (string.equals("")) {
                        this.rs.updateNull(this.columnName);
                        break;
                    }
                    int n = Integer.parseInt(string);
                    this.rs.updateInt(this.columnName, n);
                    break;
                }
                case 4: {
                    if (string.equals("")) {
                        this.rs.updateNull(this.columnName);
                        break;
                    }
                    int n = Integer.parseInt(string);
                    this.rs.updateInt(this.columnName, n);
                    break;
                }
                case -5: {
                    if (string.equals("")) {
                        this.rs.updateNull(this.columnName);
                        break;
                    }
                    long l = Long.parseLong(string);
                    this.rs.updateLong(this.columnName, l);
                    break;
                }
                case 8: {
                    if (string.equals("")) {
                        this.rs.updateNull(this.columnName);
                        break;
                    }
                    double d = Double.parseDouble(string);
                    this.rs.updateDouble(this.columnName, d);
                    break;
                }
                case 6: {
                    if (string.equals("")) {
                        this.rs.updateNull(this.columnName);
                        break;
                    }
                    float f = Float.parseFloat(string);
                    this.rs.updateFloat(this.columnName, f);
                    break;
                }
                case 12: {
                    this.rs.updateString(this.columnName, string);
                    break;
                }
                case 91: {
                    if (string.equals("")) {
                        this.rs.updateNull(this.columnName);
                        break;
                    }
                    if (string.length() == 10) {
                        this.rs.updateDate(this.columnName, this.getSQLDate(string));
                    }
                    break;
                }
                default: {
                    System.out.println("Unknown data type");
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private String getText() {
        String string = null;
        try {
            switch (this.columnType) {
                case 16: {
                    string = String.valueOf(this.rs.getBoolean(this.columnName));
                    break;
                }
                case 4: 
                case 5: {
                    string = String.valueOf(this.rs.getInt(this.columnName));
                    break;
                }
                case -5: {
                    string = String.valueOf(this.rs.getLong(this.columnName));
                    break;
                }
                case 8: {
                    string = String.valueOf(this.rs.getDouble(this.columnName));
                    break;
                }
                case 6: {
                    string = String.valueOf(this.rs.getFloat(this.columnName));
                    break;
                }
                case 12: {
                    String string2 = this.rs.getString(this.columnName);
                    if (string2 == null) {
                        string = "";
                        break;
                    }
                    string = String.valueOf(string2);
                    break;
                }
                case 91: {
                    Date date = this.rs.getDate(this.columnName);
                    if (date == null) {
                        string = "";
                        break;
                    }
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(date);
                    string = "";
                    if (gregorianCalendar.get(2) + 1 < 10) {
                        string = "0";
                    }
                    string = string + (gregorianCalendar.get(2) + 1) + "/";
                    if (gregorianCalendar.get(5) < 10) {
                        string = string + "0";
                    }
                    string = string + gregorianCalendar.get(5) + "/";
                    string = string + gregorianCalendar.get(1);
                    break;
                }
                default: {
                    System.out.println(this.columnName + " : UNKNOWN DATA TYPE ");
                }
            }
            if (this.columnName == "fiscal_end") {
                System.out.println(string);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return string;
    }

    public Date getSQLDate(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", false);
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken() + "-" + string2 + "-" + string3;
        return Date.valueOf(string4);
    }

    private class MyRowSetListener
    implements RowSetListener {
        private MyRowSetListener() {
        }

        public void cursorMoved(RowSetEvent rowSetEvent) {
            SSTextDocument.this.removeDocumentListener(SSTextDocument.this.documentListener);
            try {
                if (SSTextDocument.this.rs.getRow() != 0) {
                    String string = SSTextDocument.this.getText();
                    if (string == null) {
                        string = "";
                    }
                    SSTextDocument.this.replace(0, SSTextDocument.this.getLength(), string, null);
                } else if (SSTextDocument.this.getLength() > 0) {
                    SSTextDocument.this.remove(0, SSTextDocument.this.getLength());
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            SSTextDocument.this.addDocumentListener(SSTextDocument.this.documentListener);
        }

        public void rowChanged(RowSetEvent rowSetEvent) {
            SSTextDocument.this.removeDocumentListener(SSTextDocument.this.documentListener);
            try {
                if (SSTextDocument.this.rs.getRow() != 0) {
                    String string = SSTextDocument.this.getText();
                    if (string == null) {
                        string = "";
                    }
                    SSTextDocument.this.replace(0, SSTextDocument.this.getLength(), string, null);
                } else if (SSTextDocument.this.getLength() > 0) {
                    SSTextDocument.this.remove(0, SSTextDocument.this.getLength());
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            SSTextDocument.this.addDocumentListener(SSTextDocument.this.documentListener);
        }

        public void rowSetChanged(RowSetEvent rowSetEvent) {
            SSTextDocument.this.removeDocumentListener(SSTextDocument.this.documentListener);
            try {
                if (SSTextDocument.this.rs.getRow() != 0) {
                    String string = SSTextDocument.this.getText();
                    if (string == null) {
                        string = "";
                    }
                    SSTextDocument.this.replace(0, SSTextDocument.this.getLength(), string, null);
                } else if (SSTextDocument.this.getLength() > 0) {
                    SSTextDocument.this.remove(0, SSTextDocument.this.getLength());
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            SSTextDocument.this.addDocumentListener(SSTextDocument.this.documentListener);
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            SSTextDocument.this.rs.removeRowSetListener(SSTextDocument.this.rowSetListener);
            try {
                SSTextDocument.this.updateText(SSTextDocument.this.getText(0, SSTextDocument.this.getLength()));
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            SSTextDocument.this.rs.addRowSetListener(SSTextDocument.this.rowSetListener);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            SSTextDocument.this.rs.removeRowSetListener(SSTextDocument.this.rowSetListener);
            try {
                SSTextDocument.this.updateText(SSTextDocument.this.getText(0, SSTextDocument.this.getLength()));
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            SSTextDocument.this.rs.addRowSetListener(SSTextDocument.this.rowSetListener);
        }
    }
}

