/*
 * Decompiled with CFR 0.152.
 */
package org.merlin.beans.font;

import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.merlin.beans.numberfield.NumberFieldBean;

public class FontChooserBean
extends Container
implements PropertyChangeListener,
ItemListener {
    protected Font oFont = new Font("Serif", 0, 10);
    protected Choice name;
    protected Checkbox bold;
    protected Checkbox italic;
    protected NumberFieldBean size;
    protected boolean suppressEvents;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$java$awt$Component;

    public FontChooserBean() {
        this.setLayout(new GridLayout(2, 2));
        this.name = new Choice();
        this.add(this.name);
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < fonts.length) {
            this.name.addItem(fonts[i]);
            ++i;
        }
        this.name.select(this.oFont.getName());
        this.name.addItemListener(this);
        try {
            this.size = (NumberFieldBean)Beans.instantiate(this.getClass().getClassLoader(), "org.merlin.beans.numberfield.NumberFieldBean");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.add((Component)Beans.getInstanceOf(this.size, class$java$awt$Component == null ? (class$java$awt$Component = FontChooserBean.class$("java.awt.Component")) : class$java$awt$Component));
        this.size.setColumns(3);
        this.size.setValue(this.oFont.getSize());
        this.size.setMinimum(1);
        this.size.setMaximum(128);
        this.size.setStep(1);
        this.size.addPropertyChangeListener(this);
        this.bold = new Checkbox("bold");
        this.add(this.bold);
        this.bold.setState(this.oFont.isBold());
        this.bold.setFont(new Font("TimesRoman", 1, 12));
        this.bold.addItemListener(this);
        this.italic = new Checkbox("italic");
        this.add(this.italic);
        this.italic.setState(this.oFont.isBold());
        this.italic.setFont(new Font("TimesRoman", 2, 12));
        this.italic.addItemListener(this);
    }

    public void setStyle(Font f) {
        this.suppressEvents = true;
        this.name.select(f.getName());
        this.bold.setState(f.isBold());
        this.italic.setState(f.isItalic());
        this.size.setValue(f.getSize());
        this.suppressEvents = false;
        this.fireStateChange();
    }

    public Font getStyle() {
        return new Font(this.name.getSelectedItem(), 0 | (this.bold.getState() ? 1 : 0) | (this.italic.getState() ? 2 : 0), this.size.getValue());
    }

    public void itemStateChanged(ItemEvent e) {
        this.fireStateChange();
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.fireStateChange();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    protected void fireStateChange() {
        if (!this.suppressEvents) {
            this.oFont = this.getStyle();
            this.listeners.firePropertyChange("style", this.oFont, this.oFont);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

