/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.plaf.basic;

import com.l2fprod.common.swing.JOutlookBar;
import com.l2fprod.common.swing.PercentLayout;
import com.l2fprod.common.swing.PercentLayoutAnimator;
import com.l2fprod.common.swing.plaf.OutlookBarUI;
import com.l2fprod.common.util.JVM;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class BasicOutlookBarUI
extends BasicTabbedPaneUI
implements OutlookBarUI {
    private ContainerListener tabListener;
    private Map buttonToTab;
    private Map tabToButton;
    private Component nextVisibleComponent;
    private PercentLayoutAnimator animator;

    public static ComponentUI createUI(JComponent c) {
        return new BasicOutlookBarUI();
    }

    public JScrollPane makeScrollPane(Component component) {
        JScrollPane scroll = new JScrollPane();
        scroll.setBorder(BorderFactory.createEmptyBorder());
        if (component instanceof Scrollable) {
            scroll.getViewport().setView(component);
        } else {
            scroll.getViewport().setView(new ScrollableJPanel(component));
        }
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        return scroll;
    }

    protected void installDefaults() {
        super.installDefaults();
        TabLayout layout = new TabLayout();
        this.tabPane.setLayout(layout);
        layout.setLayoutConstraints(this.tabPane);
        this.updateTabLayoutOrientation();
        this.buttonToTab = new HashMap();
        this.tabToButton = new HashMap();
        LookAndFeel.installBorder(this.tabPane, "OutlookBar.border");
        LookAndFeel.installColors(this.tabPane, "OutlookBar.background", "OutlookBar.foreground");
        this.tabPane.setOpaque(true);
        Component[] components = this.tabPane.getComponents();
        int c = components.length;
        for (int i = 0; i < c; ++i) {
            this.tabAdded(components[i]);
        }
    }

    protected void uninstallDefaults() {
        ArrayList tabs = new ArrayList(this.buttonToTab.values());
        Iterator iter = tabs.iterator();
        while (iter.hasNext()) {
            Component tab = (Component)iter.next();
            this.tabRemoved(tab);
        }
        super.uninstallDefaults();
    }

    protected void installListeners() {
        this.tabListener = this.createTabListener();
        this.tabPane.addContainerListener(this.tabListener);
        super.installListeners();
    }

    protected ContainerListener createTabListener() {
        return new ContainerTabHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removeContainerListener(this.tabListener);
    }

    public Rectangle getTabBounds(JTabbedPane pane, int index) {
        Component tab = pane.getComponentAt(index);
        return tab.getBounds();
    }

    public int getTabRunCount(JTabbedPane pane) {
        return 0;
    }

    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        int index = -1;
        int c = pane.getTabCount();
        for (int i = 0; i < c; ++i) {
            if (!pane.getComponentAt(i).contains(x, y)) continue;
            index = i;
            break;
        }
        return index;
    }

    protected int indexOfComponent(Component component) {
        int index = -1;
        Component[] components = this.tabPane.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] != component) continue;
            index = i;
            break;
        }
        return index;
    }

    protected TabButton createTabButton() {
        TabButton button = new TabButton();
        button.setOpaque(true);
        return button;
    }

    protected void tabAdded(final Component newTab) {
        TabButton button = (TabButton)this.tabToButton.get(newTab);
        if (button == null) {
            button = this.createTabButton();
            this.buttonToTab.put(button, newTab);
            this.tabToButton.put(newTab, button);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Component current = BasicOutlookBarUI.this.getVisibleComponent();
                    Component target = newTab;
                    if (((JOutlookBar)BasicOutlookBarUI.this.tabPane).isAnimated() && current != target && current != null && target != null) {
                        if (BasicOutlookBarUI.this.animator != null) {
                            BasicOutlookBarUI.this.animator.stop();
                        }
                        BasicOutlookBarUI.this.animator = new PercentLayoutAnimator(this, BasicOutlookBarUI.this.tabPane, (PercentLayout)BasicOutlookBarUI.this.tabPane.getLayout()){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void stop() {
                                super.stop();
                                BasicOutlookBarUI.access$700(1.access$600(this.this$1)).setSelectedComponent(1.access$500(this.this$1));
                                BasicOutlookBarUI.access$802(1.access$600(this.this$1), null);
                            }
                        };
                        BasicOutlookBarUI.this.nextVisibleComponent = newTab;
                        BasicOutlookBarUI.this.animator.setTargetPercent(current, 1.0f, 0.0f);
                        BasicOutlookBarUI.this.animator.setTargetPercent(newTab, 0.0f, 1.0f);
                        BasicOutlookBarUI.this.animator.start();
                    } else {
                        BasicOutlookBarUI.this.nextVisibleComponent = null;
                        BasicOutlookBarUI.this.tabPane.setSelectedComponent(newTab);
                    }
                }

                static /* synthetic */ Component access$500(1 x0) {
                    return x0.newTab;
                }

                static /* synthetic */ BasicOutlookBarUI access$600(1 x0) {
                    return x0.BasicOutlookBarUI.this;
                }
            });
        } else {
            this.tabPane.remove(button);
        }
        this.updateTabButtonAt(this.tabPane.indexOfComponent(newTab));
        int index = this.indexOfComponent(newTab);
        this.tabPane.add((Component)button, index);
        if (JVM.current().isOneDotFive()) {
            this.assureRectsCreated(this.tabPane.getTabCount());
        }
    }

    protected void tabRemoved(Component removedTab) {
        TabButton button = (TabButton)this.tabToButton.get(removedTab);
        this.tabPane.remove(button);
        this.buttonToTab.remove(button);
        this.tabToButton.remove(removedTab);
    }

    protected void updateTabButtonAt(int index) {
        TabButton button = this.buttonForTab(index);
        button.setText(this.tabPane.getTitleAt(index));
        button.setIcon(this.tabPane.getIconAt(index));
        button.setDisabledIcon(this.tabPane.getDisabledIconAt(index));
        button.setToolTipText(this.tabPane.getToolTipTextAt(index));
        button.setDisplayedMnemonicIndex(this.tabPane.getDisplayedMnemonicIndexAt(index));
        button.setMnemonic(this.tabPane.getMnemonicAt(index));
        button.setEnabled(this.tabPane.isEnabledAt(index));
        button.setHorizontalAlignment(((JOutlookBar)this.tabPane).getAlignmentAt(index));
    }

    protected TabButton buttonForTab(int index) {
        Component component = this.tabPane.getComponentAt(index);
        return (TabButton)this.tabToButton.get(component);
    }

    protected void updateTabLayoutOrientation() {
        TabLayout layout = (TabLayout)this.tabPane.getLayout();
        int placement = this.tabPane.getTabPlacement();
        if (placement == 1 || placement == 3) {
            layout.setOrientation(0);
        } else {
            layout.setOrientation(1);
        }
    }

    protected boolean requestFocusForVisibleComponent0() {
        Component visibleComponent = this.getVisibleComponent();
        if (visibleComponent.isFocusTraversable()) {
            visibleComponent.requestFocus();
            return true;
        }
        return visibleComponent instanceof JComponent && ((JComponent)visibleComponent).requestDefaultFocus();
    }

    protected MouseListener createMouseListener() {
        return new MouseAdapter(){};
    }

    public void paint(Graphics g, JComponent c) {
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
    }

    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
    }

    static /* synthetic */ JTabbedPane access$700(BasicOutlookBarUI x0) {
        return x0.tabPane;
    }

    private static class ScrollableJPanel
    extends JPanel
    implements Scrollable {
        public ScrollableJPanel(Component component) {
            this.setLayout(new BorderLayout(0, 0));
            this.add("Center", component);
            this.setOpaque(false);
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 16;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return super.getPreferredSize();
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 16;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    protected static class TabButton
    extends JButton
    implements UIResource {
        public TabButton() {
        }

        public TabButton(ButtonUI ui) {
            this.setUI(ui);
        }
    }

    protected class TabLayout
    extends PercentLayout {
        protected TabLayout() {
        }

        public void addLayoutComponent(Component component, Object constraints) {
            if (constraints == null) {
                if (component instanceof TabButton) {
                    super.addLayoutComponent(component, "");
                } else {
                    super.addLayoutComponent(component, "100%");
                }
            } else {
                super.addLayoutComponent(component, constraints);
            }
        }

        public void setLayoutConstraints(Container parent) {
            Component[] components = parent.getComponents();
            int c = components.length;
            for (int i = 0; i < c; ++i) {
                if (components[i] instanceof TabButton) continue;
                super.addLayoutComponent(components[i], "100%");
            }
        }

        public void layoutContainer(Container parent) {
            int selectedIndex = BasicOutlookBarUI.this.tabPane.getSelectedIndex();
            Component visibleComponent = BasicOutlookBarUI.this.getVisibleComponent();
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    BasicOutlookBarUI.this.setVisibleComponent(null);
                }
            } else {
                Component selectedComponent = BasicOutlookBarUI.this.tabPane.getComponentAt(selectedIndex);
                boolean shouldChangeFocus = false;
                if (selectedComponent != null) {
                    if (selectedComponent != visibleComponent && visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                        shouldChangeFocus = true;
                    }
                    BasicOutlookBarUI.this.setVisibleComponent(selectedComponent);
                    Component[] components = parent.getComponents();
                    for (int i = 0; i < components.length; ++i) {
                        if (components[i] instanceof UIResource || !components[i].isVisible() || components[i] == selectedComponent) continue;
                        components[i].setVisible(false);
                    }
                    if (BasicOutlookBarUI.this.nextVisibleComponent != null) {
                        BasicOutlookBarUI.this.nextVisibleComponent.setVisible(true);
                    }
                }
                super.layoutContainer(parent);
                if (shouldChangeFocus && !BasicOutlookBarUI.this.requestFocusForVisibleComponent0()) {
                    BasicOutlookBarUI.this.tabPane.requestFocus();
                }
            }
        }
    }

    class ContainerTabHandler
    extends ContainerAdapter {
        ContainerTabHandler() {
        }

        public void componentAdded(ContainerEvent e) {
            if (!(e.getChild() instanceof UIResource)) {
                Component newTab = e.getChild();
                BasicOutlookBarUI.this.tabAdded(newTab);
            }
        }

        public void componentRemoved(ContainerEvent e) {
            if (!(e.getChild() instanceof UIResource)) {
                Component oldTab = e.getChild();
                BasicOutlookBarUI.this.tabRemoved(oldTab);
            }
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("tabPropertyChangedAtIndex".equals(name)) {
                int index = (Integer)e.getNewValue();
                BasicOutlookBarUI.this.updateTabButtonAt(index);
            } else if ("tabPlacement".equals(name)) {
                BasicOutlookBarUI.this.updateTabLayoutOrientation();
            }
        }
    }
}

