/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.util;

import com.microsoft.util.UtilException;
import com.microsoft.util.UtilProperties;
import com.microsoft.util.UtilTransliteratorForASCII;
import com.microsoft.util.UtilTransliteratorForUCS2;
import com.microsoft.util.UtilTransliteratorUsingSunIO;
import com.microsoft.util.UtilTransliteratorUsingTable;
import com.microsoft.util.UtilTransliteratorUsingVM;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public abstract class UtilTransliterator {
    private static String footprint = "$Revision:   1.9.1.0  $";
    private Reader _r;
    protected byte[] bytesCache;
    protected char[] charsCache;

    public static UtilTransliterator GetNewTransliterator(String string) throws UtilException {
        String string2 = string.toUpperCase();
        if (string2.equals("ASCII")) {
            return new UtilTransliteratorForASCII();
        }
        if (string2.equals("UCS2")) {
            return new UtilTransliteratorForUCS2();
        }
        UtilProperties utilProperties = new UtilProperties("transliteration.properties");
        String string3 = utilProperties.getProperty("translit.name." + string2);
        String string4 = utilProperties.getProperty("translit.type." + string2);
        if (string3 == null) {
            throw new UtilException(1011, string2);
        }
        if ("TABLE".equalsIgnoreCase(string4)) {
            String string5 = String.valueOf(string3) + ".t";
            return new UtilTransliteratorUsingTable(string5);
        }
        if ("CLASS".equalsIgnoreCase(string4)) {
            try {
                Class<?> clazz = Class.forName(string3);
                return (UtilTransliterator)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UtilException(1006, string3);
            }
            catch (Exception exception) {
                throw new UtilException(1010, string3);
            }
        }
        if ("VM".equalsIgnoreCase(string4)) {
            return new UtilTransliteratorUsingVM(string3);
        }
        if ("SUNIO".equalsIgnoreCase(string4)) {
            return new UtilTransliteratorUsingSunIO(string3);
        }
        if ("ASCII".equalsIgnoreCase(string4)) {
            return new UtilTransliteratorForASCII();
        }
        if ("UCS2".equalsIgnoreCase(string4)) {
            return new UtilTransliteratorForUCS2();
        }
        throw new UtilException(1004);
    }

    public abstract String decode(byte[] var1, int var2, int var3) throws UtilException;

    public synchronized InputStream decodeAsAsciiStream(InputStream inputStream) throws UtilException {
        this._r = this.decodeAsReader(inputStream);
        return new InputStream(this){
            private Reader r;
            private char[] chars;
            {
                this.r = utilTransliterator._r;
            }

            public void close() throws IOException {
                this.r.close();
            }

            public int read() throws IOException {
                int n = this.r.read();
                if (n == -1) {
                    return -1;
                }
                return n & 0xFF;
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3;
                if (this.chars == null || this.chars.length < n2) {
                    this.chars = new char[n2];
                }
                if ((n3 = this.r.read(this.chars)) == -1 || n3 == 0) {
                    return n3;
                }
                int n4 = 0;
                while (n4 < n3) {
                    byArray[n4 + n] = (byte)this.chars[n4];
                    ++n4;
                }
                return n3;
            }
        };
    }

    public abstract Reader decodeAsReader(InputStream var1) throws UtilException;

    public abstract void encode(InputStream var1, int var2, OutputStream var3) throws UtilException;

    public abstract void encode(Reader var1, int var2, OutputStream var3) throws UtilException;

    public abstract byte[] encode(String var1) throws UtilException;

    public abstract byte[] encode(String var1, int[] var2) throws UtilException;

    public byte[] getBytesCache() {
        return this.bytesCache;
    }

    public char[] getCharsCache() {
        return this.charsCache;
    }

    public abstract int getMaxBytesPerChar();

    public abstract int getMaxCharsPerByte();

    public abstract boolean isFixedBytesPerChar();

    public void setCacheSize(int n) {
        int n2 = this.getMaxBytesPerChar();
        if (n2 == 0) {
            n2 = 1;
        }
        this.bytesCache = new byte[n2 * n];
        n2 = this.getMaxCharsPerByte();
        if (n2 == 0) {
            n2 = 1;
        }
        this.charsCache = new char[n2 * n];
    }
}

