/*
 * Decompiled with CFR 0.152.
 */
package net.janino;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.janino.Descriptor;
import net.janino.IClass;
import net.janino.IClassLoader;
import net.janino.Java;
import net.janino.MethodDescriptor;
import net.janino.util.ClassFile;

public class ClassFileIClass
extends IClass {
    private static final boolean DEBUG = false;
    private final ClassFile classFile;
    private final IClassLoader iClassLoader;
    private final short accessFlags;
    private final Map resolvedFields = new HashMap();
    private final Map resolvedClasses = new HashMap();
    private final Map resolvedMethods = new HashMap();

    public ClassFileIClass(ClassFile classFile, IClassLoader iClassLoader) throws ClassNotFoundException {
        this.classFile = classFile;
        this.iClassLoader = iClassLoader;
        this.accessFlags = classFile.accessFlags;
    }

    public IClass getComponentType() {
        return null;
    }

    public IClass[] getDeclaredIClasses() throws Java.CompileException {
        ClassFile.InnerClassesAttribute innerClassesAttribute = this.classFile.getInnerClassesAttribute();
        if (innerClassesAttribute == null) {
            return new IClass[0];
        }
        List list = innerClassesAttribute.getEntries();
        ArrayList<IClass> arrayList = new ArrayList<IClass>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ClassFile.InnerClassesAttribute.Entry entry = (ClassFile.InnerClassesAttribute.Entry)iterator.next();
            if (entry.outerClassInfoIndex != this.classFile.thisClass) continue;
            try {
                arrayList.add(this.resolveClass(entry.innerClassInfoIndex));
            }
            catch (ClassNotFoundException classNotFoundException) {
                Java.compileError(classNotFoundException.getMessage());
                return new IClass[0];
            }
        }
        return arrayList.toArray(new IClass[arrayList.size()]);
    }

    public IClass.IConstructor[] getDeclaredIConstructors() {
        ArrayList<IClass.IInvocable> arrayList = new ArrayList<IClass.IInvocable>();
        Iterator iterator = this.classFile.methodInfos.iterator();
        while (iterator.hasNext()) {
            IClass.IInvocable iInvocable;
            ClassFile.MethodInfo methodInfo = (ClassFile.MethodInfo)iterator.next();
            try {
                iInvocable = this.resolveMethod(methodInfo);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.getMessage());
            }
            if (!(iInvocable instanceof IClass.IConstructor)) continue;
            arrayList.add(iInvocable);
        }
        return arrayList.toArray(new IClass.IConstructor[arrayList.size()]);
    }

    public IClass.IField[] getDeclaredIFields() {
        IClass.IField[] iFieldArray = new IClass.IField[this.classFile.fieldInfos.size()];
        int n = 0;
        while (n < this.classFile.fieldInfos.size()) {
            try {
                iFieldArray[n] = this.resolveField((ClassFile.FieldInfo)this.classFile.fieldInfos.get(n));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.getMessage());
            }
            ++n;
        }
        return iFieldArray;
    }

    public IClass.IMethod[] getDeclaredIMethods() {
        ArrayList<IClass.IInvocable> arrayList = new ArrayList<IClass.IInvocable>();
        Iterator iterator = this.classFile.methodInfos.iterator();
        while (iterator.hasNext()) {
            IClass.IInvocable iInvocable;
            ClassFile.MethodInfo methodInfo = (ClassFile.MethodInfo)iterator.next();
            try {
                iInvocable = this.resolveMethod(methodInfo);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.getMessage());
            }
            if (!(iInvocable instanceof IClass.IMethod)) continue;
            arrayList.add(iInvocable);
        }
        return arrayList.toArray(new IClass.IMethod[arrayList.size()]);
    }

    public IClass getDeclaringIClass() throws Java.CompileException {
        ClassFile.InnerClassesAttribute innerClassesAttribute = this.classFile.getInnerClassesAttribute();
        if (innerClassesAttribute == null) {
            return null;
        }
        List list = innerClassesAttribute.getEntries();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ClassFile.InnerClassesAttribute.Entry entry = (ClassFile.InnerClassesAttribute.Entry)iterator.next();
            if (entry.innerClassInfoIndex != this.classFile.thisClass) continue;
            if (entry.outerClassInfoIndex == 0) {
                return null;
            }
            try {
                return this.resolveClass(entry.outerClassInfoIndex);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Java.compileError(classNotFoundException.getMessage());
                return null;
            }
        }
        return null;
    }

    public String getDescriptor() {
        return Descriptor.fromClassName(this.classFile.getThisClassName());
    }

    public IClass[] getInterfaces() throws Java.CompileException {
        return this.resolveClasses(this.classFile.interfaces);
    }

    public IClass getOuterIClass() throws Java.CompileException {
        ClassFile.InnerClassesAttribute innerClassesAttribute = this.classFile.getInnerClassesAttribute();
        if (innerClassesAttribute == null) {
            return null;
        }
        List list = innerClassesAttribute.getEntries();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ClassFile.InnerClassesAttribute.Entry entry = (ClassFile.InnerClassesAttribute.Entry)iterator.next();
            if (entry.innerClassInfoIndex != this.classFile.thisClass) continue;
            if (entry.outerClassInfoIndex == 0) {
                return null;
            }
            if ((entry.innerClassAccessFlags & 8) != 0) {
                return null;
            }
            try {
                return this.resolveClass(entry.outerClassInfoIndex);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Java.compileError(classNotFoundException.getMessage());
                return null;
            }
        }
        return null;
    }

    public IClass getSuperclass() throws Java.CompileException {
        try {
            return this.resolveClass(this.classFile.superclass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Java.compileError(classNotFoundException.getMessage());
            return Java.getIClassLoader().OBJECT;
        }
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isPrimitiveNumeric() {
        return false;
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public void resolveAllClasses() throws ClassNotFoundException {
        short s = 0;
        while (s < this.classFile.constantPool.size()) {
            ClassFile.ConstantPoolInfo constantPoolInfo = this.classFile.getConstantPoolInfo(s);
            if (constantPoolInfo instanceof ClassFile.ConstantClassInfo) {
                this.resolveClass(s);
            } else if (constantPoolInfo instanceof ClassFile.ConstantNameAndTypeInfo) {
                short s2 = ((ClassFile.ConstantNameAndTypeInfo)constantPoolInfo).getDescriptorIndex();
                String string = this.classFile.getConstantUtf8(s2);
                if (string.charAt(0) == '(') {
                    MethodDescriptor methodDescriptor = new MethodDescriptor(string);
                    this.resolveClass(methodDescriptor.returnFD);
                    int n = 0;
                    while (n < methodDescriptor.parameterFDs.length) {
                        this.resolveClass(methodDescriptor.parameterFDs[n]);
                        ++n;
                    }
                } else {
                    this.resolveClass(string);
                }
            }
            s = (short)(s + 1);
        }
    }

    private IClass resolveClass(String string) throws ClassNotFoundException {
        IClass iClass = (IClass)this.resolvedClasses.get(string);
        if (iClass != null) {
            return iClass;
        }
        iClass = this.iClassLoader.loadIClass(string);
        this.resolvedClasses.put(string, iClass);
        return iClass;
    }

    private IClass resolveClass(short s) throws ClassNotFoundException {
        return this.resolveClass(Descriptor.fromInternalForm(this.classFile.getConstantClassName(s)));
    }

    private IClass[] resolveClasses(short[] sArray) throws Java.CompileException {
        IClass[] iClassArray = new IClass[sArray.length];
        int n = 0;
        while (n < iClassArray.length) {
            try {
                iClassArray[n] = this.resolveClass(sArray[n]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Java.compileError(classNotFoundException.getMessage());
                return new IClass[0];
            }
            ++n;
        }
        return iClassArray;
    }

    private IClass.IField resolveField(final ClassFile.FieldInfo fieldInfo) throws ClassNotFoundException {
        Object object;
        Object object2;
        IClass.IField iField = (IClass.IField)this.resolvedFields.get(fieldInfo);
        if (iField != null) {
            return iField;
        }
        final String string = this.classFile.getConstantUtf8(fieldInfo.getNameIndex());
        String string2 = this.classFile.getConstantUtf8(fieldInfo.getDescriptorIndex());
        final IClass iClass = this.resolveClass(string2);
        ClassFile.ConstantValueAttribute constantValueAttribute = null;
        ClassFile.AttributeInfo[] attributeInfoArray = fieldInfo.getAttributes();
        int n = 0;
        while (n < attributeInfoArray.length) {
            object2 = attributeInfoArray[n];
            if (object2 instanceof ClassFile.ConstantValueAttribute) {
                constantValueAttribute = (ClassFile.ConstantValueAttribute)object2;
                break;
            }
            ++n;
        }
        object2 = null;
        if (constantValueAttribute != null) {
            object = this.classFile.getConstantPoolInfo(constantValueAttribute.getConstantValueIndex());
            if (object instanceof ClassFile.ConstantValuePoolInfo) {
                object2 = ((ClassFile.ConstantValuePoolInfo)object).getValue(this.classFile);
            } else {
                throw new RuntimeException("Unexpected constant pool info type \"" + object.getClass().getName() + "\"");
            }
        }
        object = object2;
        short s = fieldInfo.getAccessFlags();
        final int n2 = (s & 1) != 0 ? 3 : ((s & 4) != 0 ? 1 : ((s & 2) != 0 ? 0 : 2));
        iField = new IClass.IField(this){

            public int getAccess() {
                return n2;
            }

            public Object getConstantValue() throws Java.CompileException {
                return object;
            }

            public String getName() {
                return string;
            }

            public IClass getType() throws Java.CompileException {
                return iClass;
            }

            public boolean isStatic() {
                return (fieldInfo.getAccessFlags() & 8) != 0;
            }
        };
        this.resolvedFields.put(fieldInfo, iField);
        return iField;
    }

    public void resolveHalf() throws ClassNotFoundException {
        this.resolveClass(this.classFile.superclass);
        int n = 0;
        while (n < this.classFile.interfaces.length) {
            this.resolveClass(this.classFile.interfaces[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.classFile.methodInfos.size()) {
            this.resolveMethod((ClassFile.MethodInfo)this.classFile.methodInfos.get(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.classFile.fieldInfos.size()) {
            this.resolveField((ClassFile.FieldInfo)this.classFile.fieldInfos.get(n3));
            ++n3;
        }
    }

    private IClass.IInvocable resolveMethod(final ClassFile.MethodInfo methodInfo) throws ClassNotFoundException {
        int n;
        Object object;
        IClass.IInvocable iInvocable = (IClass.IInvocable)this.resolvedMethods.get(methodInfo);
        if (iInvocable != null) {
            return iInvocable;
        }
        final String string = this.classFile.getConstantUtf8(methodInfo.getNameIndex());
        MethodDescriptor methodDescriptor = new MethodDescriptor(this.classFile.getConstantUtf8(methodInfo.getDescriptorIndex()));
        final IClass iClass = this.resolveClass(methodDescriptor.returnFD);
        final IClass[] iClassArray = new IClass[methodDescriptor.parameterFDs.length];
        int n2 = 0;
        while (n2 < iClassArray.length) {
            iClassArray[n2] = this.resolveClass(methodDescriptor.parameterFDs[n2]);
            ++n2;
        }
        IClass[] iClassArray2 = null;
        ClassFile.AttributeInfo[] attributeInfoArray = methodInfo.getAttributes();
        int n3 = 0;
        while (n3 < attributeInfoArray.length) {
            object = attributeInfoArray[n3];
            if (object instanceof ClassFile.ExceptionsAttribute) {
                short[] sArray = ((ClassFile.ExceptionsAttribute)object).getExceptionIndexes();
                iClassArray2 = new IClass[sArray.length];
                n = 0;
                while (n < sArray.length) {
                    iClassArray2[n] = this.resolveClass(sArray[n]);
                    ++n;
                }
            }
            ++n3;
        }
        object = iClassArray2 == null ? new IClass[]{} : iClassArray2;
        short s = methodInfo.getAccessFlags();
        int n4 = (s & 1) != 0 ? 3 : ((s & 4) != 0 ? 1 : (n = (s & 2) != 0 ? 0 : 2));
        iInvocable = string.equals("<init>") ? new IClass.IConstructor((IClass[])object, this){
            private final /* synthetic */ IClass[] val$thrownExceptions;
            {
                this.val$thrownExceptions = iClassArray2;
            }

            public int getAccess() {
                return n;
            }

            public IClass[] getParameterTypes() throws Java.CompileException {
                IClass iClass = this.getOuterIClass();
                if (iClass != null) {
                    if (iClassArray.length < 1) {
                        throw new RuntimeException("Inner class constructor lacks magic first parameter");
                    }
                    if (iClassArray[0] != iClass) {
                        throw new RuntimeException("Magic first parameter of inner class constructor has type \"" + iClassArray[0].toString() + "\" instead of that of its enclosing instance (\"" + iClass.toString() + "\")");
                    }
                    IClass[] iClassArray2 = new IClass[iClassArray.length - 1];
                    System.arraycopy(iClassArray, 1, iClassArray2, 0, iClassArray2.length);
                    return iClassArray2;
                }
                return iClassArray;
            }

            public IClass[] getThrownExceptions() throws Java.CompileException {
                return this.val$thrownExceptions;
            }
        } : new IClass.IMethod((IClass[])object, this){
            private final /* synthetic */ IClass[] val$thrownExceptions;
            {
                this.val$thrownExceptions = iClassArray2;
            }

            public int getAccess() {
                return n;
            }

            public String getName() {
                return string;
            }

            public IClass[] getParameterTypes() throws Java.CompileException {
                return iClassArray;
            }

            public IClass getReturnType() throws Java.CompileException {
                return iClass;
            }

            public IClass[] getThrownExceptions() throws Java.CompileException {
                return this.val$thrownExceptions;
            }

            public boolean isAbstract() {
                return (methodInfo.getAccessFlags() & 0x400) != 0;
            }

            public boolean isStatic() {
                return (methodInfo.getAccessFlags() & 8) != 0;
            }
        };
        this.resolvedMethods.put(methodInfo, iInvocable);
        return iInvocable;
    }
}

