/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import net.sourceforge.jtds.jdbc.BlobImpl;
import net.sourceforge.jtds.jdbc.ClobImpl;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.JtdsPreparedStatement;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.ParamInfo;
import net.sourceforge.jtds.jdbc.Support;
import net.sourceforge.jtds.jdbc.UniqueIdentifier;

public class JtdsCallableStatement
extends JtdsPreparedStatement
implements CallableStatement {
    JtdsCallableStatement(ConnectionJDBC2 connection, String sql, int resultSetType, int concurrency) throws SQLException {
        super(connection, sql, resultSetType, concurrency, false);
    }

    int findParameter(String name, boolean set) throws SQLException {
        int i = 0;
        while (i < this.parameters.length) {
            if (this.parameters[i].name != null && this.parameters[i].name.equalsIgnoreCase(name)) {
                return i + 1;
            }
            ++i;
        }
        if (set && !name.equalsIgnoreCase("@return_status")) {
            int i2 = 0;
            while (i2 < this.parameters.length) {
                if (this.parameters[i2].name == null) {
                    this.parameters[i2].name = name;
                    return i2 + 1;
                }
                ++i2;
            }
        }
        throw new SQLException(Messages.get("error.callable.noparam", name), "07000");
    }

    protected void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException(Messages.get("error.generic.closed", "CallableStatement"), "HY010");
        }
    }

    public boolean wasNull() throws SQLException {
        this.checkOpen();
        return this.paramWasNull;
    }

    public byte getByte(int parameterIndex) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, true);
        return ((Integer)Support.convert(this, pi.value, -6, null)).byteValue();
    }

    public double getDouble(int parameterIndex) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, true);
        return (Double)Support.convert(this, pi.value, 8, null);
    }

    public float getFloat(int parameterIndex) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, true);
        return ((Double)Support.convert(this, pi.value, 6, null)).floatValue();
    }

    public int getInt(int parameterIndex) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, true);
        return (Integer)Support.convert(this, pi.value, 4, null);
    }

    public long getLong(int parameterIndex) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, true);
        return (Long)Support.convert(this, pi.value, -5, null);
    }

    public short getShort(int parameterIndex) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, true);
        return ((Integer)Support.convert(this, pi.value, 5, null)).shortValue();
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, true);
        return (Boolean)Support.convert(this, pi.value, 16, null);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, true);
        return (byte[])Support.convert(this, pi.value, -3, this.connection.getCharSet());
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        if (sqlType == 3 || sqlType == 2) {
            this.registerOutParameter(parameterIndex, sqlType, -1);
        } else {
            this.registerOutParameter(parameterIndex, sqlType, 0);
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, false);
        pi.isOutput = true;
        pi.jdbcType = sqlType == 2005 ? -1 : (sqlType == 2004 ? -4 : sqlType);
        pi.scale = scale;
    }

    public Object getObject(int parameterIndex) throws SQLException {
        Object value = this.getParameter((int)parameterIndex, (boolean)true).value;
        if (value instanceof UniqueIdentifier) {
            return value.toString();
        }
        return value;
    }

    public String getString(int parameterIndex) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, true);
        return (String)Support.convert(this, pi.value, 12, this.connection.getCharSet());
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.notImplemented("CallableStatement.registerOutParameter(int, int, String");
    }

    public byte getByte(String parameterName) throws SQLException {
        return this.getByte(this.findParameter(parameterName, false));
    }

    public double getDouble(String parameterName) throws SQLException {
        return this.getDouble(this.findParameter(parameterName, false));
    }

    public float getFloat(String parameterName) throws SQLException {
        return this.getFloat(this.findParameter(parameterName, false));
    }

    public int getInt(String parameterName) throws SQLException {
        return this.getInt(this.findParameter(parameterName, false));
    }

    public long getLong(String parameterName) throws SQLException {
        return this.getLong(this.findParameter(parameterName, false));
    }

    public short getShort(String parameterName) throws SQLException {
        return this.getShort(this.findParameter(parameterName, false));
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        return this.getBoolean(this.findParameter(parameterName, false));
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        return this.getBytes(this.findParameter(parameterName, false));
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.setByte(this.findParameter(parameterName, false), x);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.setDouble(this.findParameter(parameterName, false), x);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.setFloat(this.findParameter(parameterName, false), x);
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(this.findParameter(parameterName, true), sqlType);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.setInt(this.findParameter(parameterName, true), x);
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.findParameter(parameterName, true), sqlType);
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.findParameter(parameterName, true), sqlType, scale);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this.setLong(this.findParameter(parameterName, true), x);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.setShort(this.findParameter(parameterName, true), x);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBoolean(this.findParameter(parameterName, true), x);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytes(this.findParameter(parameterName, true), x);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, true);
        return (BigDecimal)Support.convert(this, pi.value, 3, null);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, true);
        BigDecimal bd = (BigDecimal)Support.convert(this, pi.value, 3, null);
        return bd.setScale(scale);
    }

    public URL getURL(int parameterIndex) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, true);
        String url = (String)Support.convert(this, pi.value, 12, this.connection.getCharSet());
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new SQLException(Messages.get("error.resultset.badurl", url), "22000");
        }
    }

    public Array getArray(int parameterIndex) throws SQLException {
        this.notImplemented("CallableStatement.getArray");
        return null;
    }

    public Blob getBlob(int parameterIndex) throws SQLException {
        byte[] value = this.getBytes(parameterIndex);
        if (value == null) {
            return null;
        }
        return new BlobImpl((Object)this.connection, value);
    }

    public Clob getClob(int parameterIndex) throws SQLException {
        String value = this.getString(parameterIndex);
        if (value == null) {
            return null;
        }
        return new ClobImpl(this.connection, value);
    }

    public Date getDate(int parameterIndex) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, true);
        return (Date)Support.convert(this, pi.value, 91, null);
    }

    public Ref getRef(int parameterIndex) throws SQLException {
        this.notImplemented("CallableStatement.getRef");
        return null;
    }

    public Time getTime(int parameterIndex) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, true);
        return (Time)Support.convert(this, pi.value, 92, null);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, true);
        return (Timestamp)Support.convert(this, pi.value, 93, null);
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setAsciiStream(this.findParameter(parameterName, true), x, length);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setBinaryStream(this.findParameter(parameterName, true), x, length);
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setCharacterStream(this.findParameter(parameterName, true), reader, length);
    }

    public Object getObject(String parameterName) throws SQLException {
        return this.getObject(this.findParameter(parameterName, false));
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        this.setObject(this.findParameter(parameterName, true), x);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject(this.findParameter(parameterName, true), x, targetSqlType);
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(this.findParameter(parameterName, true), x, targetSqlType, scale);
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        this.notImplemented("CallableStatement.getObject(int, Map)");
        return null;
    }

    public String getString(String parameterName) throws SQLException {
        return this.getString(this.findParameter(parameterName, false));
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.notImplemented("CallableStatement.registerOutParameter(String, int, String");
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.notImplemented("CallableStatement.setNull(String, int, String");
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.setString(this.findParameter(parameterName, true), x);
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.getBigDecimal(this.findParameter(parameterName, false));
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimal(this.findParameter(parameterName, true), x);
    }

    public URL getURL(String parameterName) throws SQLException {
        return this.getURL(this.findParameter(parameterName, false));
    }

    public void setURL(String parameterName, URL x) throws SQLException {
        this.setObject(this.findParameter(parameterName, true), (Object)x);
    }

    public Array getArray(String parameterName) throws SQLException {
        return this.getArray(this.findParameter(parameterName, false));
    }

    public Blob getBlob(String parameterName) throws SQLException {
        return this.getBlob(this.findParameter(parameterName, false));
    }

    public Clob getClob(String parameterName) throws SQLException {
        return this.getClob(this.findParameter(parameterName, false));
    }

    public Date getDate(String parameterName) throws SQLException {
        return this.getDate(this.findParameter(parameterName, false));
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this.setDate(this.findParameter(parameterName, true), x);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        Date date = this.getDate(parameterIndex);
        if (date != null && cal != null) {
            TimeZone timeZone = TimeZone.getDefault();
            long newTime = date.getTime();
            newTime -= (long)cal.getTimeZone().getRawOffset();
            date = new Date(newTime += (long)timeZone.getRawOffset());
        }
        return date;
    }

    public Ref getRef(String parameterName) throws SQLException {
        return this.getRef(this.findParameter(parameterName, false));
    }

    public Time getTime(String parameterName) throws SQLException {
        return this.getTime(this.findParameter(parameterName, false));
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.setTime(this.findParameter(parameterName, true), x);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        Time time = this.getTime(parameterIndex);
        if (time != null && cal != null) {
            TimeZone timeZone = TimeZone.getDefault();
            long newTime = time.getTime();
            newTime -= (long)cal.getTimeZone().getRawOffset();
            time = new Time(newTime += (long)timeZone.getRawOffset());
        }
        return time;
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.getTimestamp(this.findParameter(parameterName, false));
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestamp(this.findParameter(parameterName, true), x);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(parameterIndex);
        if (timestamp != null && cal != null) {
            TimeZone timeZone = TimeZone.getDefault();
            long newTime = ((java.util.Date)timestamp).getTime();
            newTime -= (long)cal.getTimeZone().getRawOffset();
            timestamp = new Timestamp(newTime += (long)timeZone.getRawOffset());
        }
        return timestamp;
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        return this.getObject(this.findParameter(parameterName, false), map);
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.getDate(this.findParameter(parameterName, false), cal);
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.getTime(this.findParameter(parameterName, false), cal);
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findParameter(parameterName, false), cal);
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate(this.findParameter(parameterName, true), x, cal);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime(this.findParameter(parameterName, true), x, cal);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(this.findParameter(parameterName, true), x, cal);
    }
}

