/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.Lex;
import electric.util.Strings;
import electric.util.io.FastBufferedReader;
import electric.util.io.FastReader;
import electric.util.io.Streams;
import electric.xml.Attribute;
import electric.xml.CData;
import electric.xml.Comment;
import electric.xml.DocType;
import electric.xml.Element;
import electric.xml.Fragment;
import electric.xml.Implementation;
import electric.xml.Instruction;
import electric.xml.NamespaceException;
import electric.xml.Node;
import electric.xml.NodeList;
import electric.xml.NodeWriter;
import electric.xml.Parent;
import electric.xml.ParseException;
import electric.xml.Text;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.EntityReference;
import org.w3c.dom.ProcessingInstruction;

public class Document
extends Parent
implements org.w3c.dom.Document {
    public static final int KEEP_WHITESPACE = 1;
    public static final int MAJOR_VERSION = 6;
    public static final int MINOR_VERSION = 0;
    private static final Implementation implementation = new Implementation();
    private static final String[] NO_STRINGS = new String[0];
    private static final String XMLDECL_START = "<?xml ";
    private static final String XMLDECL_STOP = "?>";
    private Hashtable context;
    private boolean stripped = true;
    private String version = "1.0";
    private String encoding = "UTF-8";
    private boolean standalone = false;
    private boolean setStandalone = false;
    private boolean writeXMLDecl = true;

    public Document() {
    }

    public Document(Hashtable hashtable) {
        this.context = hashtable;
    }

    public Document(String string) throws ParseException {
        this(string, 0);
    }

    public Document(String string, int n) throws ParseException {
        this.parse(new FastReader(string), null, n);
    }

    public Document(byte[] byArray) throws ParseException {
        this(byArray, null, 0);
    }

    public Document(byte[] byArray, int n) throws ParseException {
        this(byArray, null, n);
    }

    public Document(byte[] byArray, Hashtable hashtable) throws ParseException {
        this(byArray, hashtable, 0);
    }

    public Document(byte[] byArray, Hashtable hashtable, int n) throws ParseException {
        try {
            this.parse(new FastReader(Strings.toString(byArray)), hashtable, n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ParseException(unsupportedEncodingException.toString());
        }
    }

    public Document(File file) throws ParseException {
        this(file, 0);
    }

    public Document(File file, int n) throws ParseException {
        try {
            this.parse(new FastBufferedReader(Streams.getReader(file)), null, n);
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.toString());
        }
    }

    public Document(InputStream inputStream) throws ParseException {
        this(inputStream, 0);
    }

    public Document(InputStream inputStream, int n) throws ParseException {
        try {
            this.parse(new FastBufferedReader(Streams.getReader(inputStream)), null, n);
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.toString());
        }
    }

    public Document(Reader reader) throws ParseException {
        this.parse(reader, null, 0);
    }

    public Document(Reader reader, int n) throws ParseException {
        this(reader, null, n);
    }

    public Document(Reader reader, Hashtable hashtable) throws ParseException {
        this(reader, hashtable, 0);
    }

    public Document(Reader reader, Hashtable hashtable, int n) throws ParseException {
        this.parse(reader, hashtable, n);
    }

    public Document(Element element) {
        this.setRoot(element);
    }

    public Document(Document document) {
        super(document);
        this.context = document.context;
        this.version = document.version;
        this.encoding = document.encoding;
        this.standalone = document.standalone;
        this.setStandalone = document.setStandalone;
        this.writeXMLDecl = document.writeXMLDecl;
    }

    public boolean isStripped() {
        return this.stripped;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parse(Reader reader, Hashtable hashtable, int n) throws ParseException {
        if ((n & 1) != 0) {
            this.stripped = false;
        }
        Lex lex = new Lex(reader, "<>=/:", 1);
        try {
            try {
                this.parse(lex, hashtable, this.stripped);
            }
            catch (Exception exception) {
                throw new ParseException(exception.getClass().getName() + ": " + exception.getMessage() + "\n" + lex.getLocation());
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        reader.close();
        return;
    }

    private void parse(Lex lex, Hashtable hashtable, boolean bl) throws IOException, NamespaceException {
        this.context = hashtable;
        int n = 0;
        this.writeXMLDecl = false;
        while (true) {
            StringBuffer stringBuffer;
            if ((stringBuffer = lex.readWhitespace()) != null && !bl) {
                new Text(this).setString(stringBuffer.toString());
            }
            lex.mark(2);
            int n2 = lex.peekRead();
            int n3 = lex.peekRead();
            lex.reset();
            if (n2 == -1) break;
            if (n3 == 33 && lex.peekString("<!--")) {
                new Comment(lex, this);
                continue;
            }
            if (n3 == 33 && lex.peekString("<!DOCTYPE")) {
                new DocType(lex, this);
                continue;
            }
            if (n3 == 63 && lex.peekString(XMLDECL_START)) {
                this.writeXMLDecl = true;
                this.parseXMLDecl(lex);
                continue;
            }
            if (n3 == 63) {
                new Instruction(lex, this);
                continue;
            }
            new Element(lex, this, bl);
            ++n;
        }
        if (n != 1) {
            throw new IOException("the document does not have exactly one root");
        }
        lex.skipWhitespace();
        if (lex.read() != -1) {
            throw new IOException("extra stuff at the end");
        }
    }

    public Object clone() {
        return new Document(this);
    }

    public Document getDocument() {
        return this;
    }

    public Element getRoot() {
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof Element) {
                return (Element)node;
            }
            node = node.next;
        }
        return null;
    }

    public Element newRoot() {
        return this.setRoot(new Element());
    }

    public Element setRoot(Element element) {
        Element element2 = this.getRoot();
        if (element2 != null) {
            element2.replaceWith(element);
        } else {
            this.addChild(element);
        }
        return element;
    }

    public Element setRoot(String string) {
        Element element = this.newRoot();
        element.setName(string);
        return element;
    }

    public Element setRoot(String string, String string2) {
        Element element = this.newRoot();
        element.setName(string, string2);
        return element;
    }

    public DocType getDocType() {
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof DocType) {
                return (DocType)node;
            }
            node = node.next;
        }
        return null;
    }

    public void write(NodeWriter nodeWriter) throws IOException {
        if (this.writeXMLDecl) {
            this.writeXMLDecl(nodeWriter);
        }
        Node node = this.children.first;
        while (node != null) {
            nodeWriter.write(node);
            if (node.next != null && this.stripped) {
                nodeWriter.writeEOL();
            }
            node = node.next;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
        this.writeXMLDecl = true;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
        this.writeXMLDecl = true;
    }

    public boolean getStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean bl) {
        this.standalone = bl;
        this.setStandalone = true;
        this.writeXMLDecl = true;
    }

    public void setWriteXMLDecl(boolean bl) {
        this.writeXMLDecl = bl;
    }

    public boolean getWriteXMLDecl() {
        return this.writeXMLDecl;
    }

    private void parseXMLDecl(Lex lex) throws IOException {
        lex.skip(XMLDECL_START.length());
        int n = 0;
        do {
            String string = lex.readToken();
            lex.readChar(61);
            lex.skipWhitespace();
            int n2 = lex.read();
            String string2 = null;
            if (n2 == 34) {
                string2 = lex.readToPattern("\"", 66);
            } else if (n2 == 39) {
                string2 = lex.readToPattern("'", 66);
            } else {
                throw new IOException("missing quote at start of XMLDecl attribute");
            }
            if (string.equals("version")) {
                this.setVersion(string2);
            } else if (string.equals("encoding")) {
                this.setEncoding(string2);
            } else if (string.equals("standalone")) {
                this.setStandalone(string2.equals("yes"));
            } else {
                throw new IOException(string + " is invalid attribute for XMLDecl");
            }
            lex.skipWhitespace();
        } while ((n = lex.peek()) != 63);
        lex.readChar(63);
        lex.readChar(62);
    }

    private void writeXMLDecl(NodeWriter nodeWriter) throws IOException {
        nodeWriter.writeIndent();
        nodeWriter.write(XMLDECL_START);
        nodeWriter.write("version='");
        nodeWriter.write(this.version);
        nodeWriter.write("' encoding='");
        nodeWriter.write(this.encoding);
        nodeWriter.write("'");
        if (this.setStandalone) {
            nodeWriter.write(" standalone='");
            nodeWriter.write(this.standalone ? "yes" : "no");
            nodeWriter.write("'");
        }
        nodeWriter.write(XMLDECL_STOP);
        nodeWriter.writeEOL();
    }

    public Hashtable getContext() {
        return this.context;
    }

    public void setContext(Hashtable hashtable) {
        this.context = hashtable;
    }

    public String getNamespace(String string) {
        return this.context == null ? null : (String)this.context.get(string);
    }

    protected void addNamespacePrefixes(String string, Vector vector, Vector vector2) {
        if (this.context == null) {
            return;
        }
        Enumeration enumeration = this.context.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (vector.contains(string2) || !this.context.get(string2).equals(string)) continue;
            vector2.addElement(string2);
        }
    }

    public String getNamespacePrefix(String string) {
        if (this.context == null) {
            return null;
        }
        Enumeration enumeration = this.context.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.context.get(string2).equals(string)) continue;
            return string2;
        }
        return null;
    }

    public org.w3c.dom.Node appendChild(org.w3c.dom.Node node) throws DOMException {
        Instruction instruction;
        if (node instanceof Instruction && (instruction = (Instruction)node).getTarget().startsWith("xml")) {
            Lex lex = new Lex(XMLDECL_START + instruction.getContent() + XMLDECL_STOP, "<>=/:", 1);
            try {
                this.parseXMLDecl(lex);
                return instruction;
            }
            catch (IOException iOException) {
                throw new DOMException(5, iOException.toString());
            }
        }
        return super.appendChild(node);
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeName() {
        return "#document";
    }

    public Attr createAttribute(String string) {
        return new Attribute(string, null);
    }

    public Attr createAttributeNS(String string, String string2) {
        String[] stringArray = Element.getParts(string2);
        Attribute attribute = new Attribute(stringArray[0], stringArray[1], null);
        attribute.namespace = string;
        return attribute;
    }

    public CDATASection createCDATASection(String string) {
        return new CData(string);
    }

    public org.w3c.dom.Comment createComment(String string) {
        return new Comment(string);
    }

    public DocumentFragment createDocumentFragment() {
        return new Fragment();
    }

    public org.w3c.dom.Element createElement(String string) {
        return new Element(string);
    }

    public org.w3c.dom.Element createElementNS(String string, String string2) {
        String[] stringArray = Element.getParts(string2);
        Element element = new Element(stringArray[1]);
        element.prefix = stringArray[0];
        element.namespace = string;
        return element;
    }

    public EntityReference createEntityReference(String string) {
        return null;
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) {
        return new Instruction(string, string2);
    }

    public org.w3c.dom.Text createTextNode(String string) {
        return new Text(string);
    }

    public DocumentType getDoctype() {
        return this.getDocType();
    }

    public org.w3c.dom.Element getDocumentElement() {
        return this.getRoot();
    }

    public org.w3c.dom.Element getElementById(String string) {
        return this.getElementWithId(string);
    }

    public org.w3c.dom.NodeList getElementsByTagName(String string) {
        NodeList nodeList = new NodeList();
        Element element = this.getRoot();
        if (element != null) {
            element.addElementsByTagName(string, nodeList);
        }
        return nodeList;
    }

    public org.w3c.dom.NodeList getElementsByTagNameNS(String string, String string2) {
        NodeList nodeList = new NodeList();
        Element element = this.getRoot();
        if (element != null) {
            element.addElementsByTagNameNS(string, string2, nodeList);
        }
        return nodeList;
    }

    public DOMImplementation getImplementation() {
        return implementation;
    }

    public org.w3c.dom.Node importNode(org.w3c.dom.Node node, boolean bl) {
        return node.cloneNode(bl);
    }
}

