/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class CIniFile {
    private CItemArray sections = new CItemArray();
    private URL url = null;

    public CIniFile() {
    }

    public CIniFile(String string) throws IOException {
        this(new File(string));
    }

    public CIniFile(File file) throws IOException {
        this(file.toURL());
    }

    public CIniFile(URL uRL) throws IOException {
        this.url = uRL;
        this.loadFromStream(uRL.openStream());
    }

    private OutputStream createOutputStream() throws IOException {
        if (this.url.getProtocol().equals("file")) {
            return new FileOutputStream(this.url.getFile());
        }
        return this.url.openConnection().getOutputStream();
    }

    private CItemArray addSection(String string) {
        CItemArray cItemArray = new CItemArray();
        this.sections.putValue(string, cItemArray);
        return cItemArray;
    }

    public void clear() {
        this.sections.clear();
    }

    public void deleteKey(String string, String string2) {
        CItemArray cItemArray = (CItemArray)this.sections.getValue(string);
        if (cItemArray != null) {
            cItemArray.removeValue(string2);
        }
    }

    public void eraseSection(String string) {
        this.sections.removeValue(string);
    }

    public boolean valueExists(String string, String string2) {
        CItemArray cItemArray = this.readSection(string);
        return cItemArray != null && cItemArray.getValue(string2) != null;
    }

    public boolean isSectionExists(String string) {
        return this.readSection(string) != null;
    }

    private String readLine(InputStream inputStream) throws IOException {
        int n;
        String string = "";
        do {
            if ((n = inputStream.read()) < 0 || n == 10 || n == 13) continue;
            string = string + (char)n;
        } while (n >= 0 && n != 10);
        return n >= 0 || string.length() > 0 ? string.trim() : null;
    }

    private String[] splitLine(String string) {
        String[] stringArray = new String[3];
        int n = 0;
        boolean bl = false;
        stringArray[0] = "";
        stringArray[1] = "";
        stringArray[2] = "";
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '=' && n == 0) {
                n = 1;
            } else if (c == ';' && !bl && n < 2) {
                n = 2;
            } else {
                if (c == '\"' && n == 1) {
                    bl = !bl;
                }
                int n3 = n;
                stringArray[n3] = stringArray[n3] + c;
            }
            ++n2;
        }
        return stringArray;
    }

    public void loadFromStream(InputStream inputStream) throws IOException {
        this.sections.clear();
        String string = this.readLine(inputStream);
        if (string == null) {
            return;
        }
        CItemArray cItemArray = new CItemArray();
        this.sections.putValue("", cItemArray);
        while (string != null) {
            if (string.startsWith("[")) {
                if ((string = string.substring(1)).endsWith("]")) {
                    string = string.substring(0, string.length() - 1);
                }
                cItemArray = new CItemArray();
                this.sections.putValue(string, cItemArray);
            } else {
                String[] stringArray = this.splitLine(string);
                cItemArray.putValue(stringArray[0].toUpperCase(), string);
            }
            string = this.readLine(inputStream);
        }
    }

    private CItemArray readSection(String string) {
        return (CItemArray)this.sections.getValue(string);
    }

    private CItemArray readSections() {
        return this.sections;
    }

    public String unwrapString(String string) {
        if ((string = string.trim()).startsWith("\"") && string.length() > 0) {
            String string2 = "";
            int n = 1;
            while (n < string.length()) {
                if (string.charAt(n) == '\\') {
                    ++n;
                }
                if (string.charAt(n) != '\"' || string.charAt(n - 1) == '\\') {
                    string2 = string2 + string.charAt(n);
                }
                ++n;
            }
            return string2;
        }
        return string;
    }

    public String readString(String string, String string2, String string3) {
        CItemArray cItemArray = (CItemArray)this.sections.getValue(string);
        if (cItemArray == null) {
            return string3;
        }
        String string4 = (String)cItemArray.getValue(string2);
        if (string4 == null) {
            return string3;
        }
        String[] stringArray = this.splitLine(string4);
        return this.unwrapString(stringArray[1]);
    }

    public void rename(String string, boolean bl) throws IOException {
        this.rename(new File(string), bl);
    }

    public void rename(File file, boolean bl) throws IOException {
        this.rename(file.toURL(), bl);
    }

    public void rename(URL uRL, boolean bl) throws IOException {
        this.url = uRL;
        if (bl) {
            this.loadFromStream(uRL.openStream());
        }
    }

    private void writeLine(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes());
    }

    public void saveToStream(OutputStream outputStream) throws IOException {
        boolean bl = true;
        int n = 0;
        while (n < this.sections.size()) {
            String string = this.sections.getKey(n);
            String string2 = "[" + string + "]";
            if (!string2.equals("[]")) {
                if (!bl) {
                    string2 = "\r\n" + string2;
                }
                this.writeLine(outputStream, string2);
                bl = false;
            }
            CItemArray cItemArray = (CItemArray)this.sections.getValue(n);
            int n2 = 0;
            while (n2 < cItemArray.size()) {
                string2 = (String)cItemArray.getValue(n2);
                if (!bl) {
                    string2 = "\r\n" + string2;
                }
                this.writeLine(outputStream, string2);
                bl = false;
                ++n2;
            }
            ++n;
        }
    }

    public void flush() throws IOException {
        this.saveToStream(this.createOutputStream());
    }

    private String wrapString(String string) {
        if (string.indexOf(32) >= 0 || string.indexOf(9) >= 0 || string.indexOf(34) >= 0 || string.indexOf(59) >= 0) {
            String string2 = "\"";
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) == '\"' || string.charAt(n) == '\\') {
                    string2 = string2 + '\\';
                }
                string2 = string2 + string.charAt(n);
                ++n;
            }
            return string2 + "\"";
        }
        return string;
    }

    public void writeString(String string, String string2, String string3) {
        String string4;
        CItemArray cItemArray = (CItemArray)this.sections.getValue(string);
        if (cItemArray == null) {
            cItemArray = this.addSection(string);
        }
        if ((string4 = (String)cItemArray.getValue(string2)) == null) {
            string4 = string2 + "=" + this.wrapString(string3);
        } else {
            String[] stringArray = this.splitLine(string4);
            string4 = stringArray[0] + "=" + this.wrapString(string3);
            if (stringArray[2].length() > 0) {
                string4 = string4 + ";" + stringArray[2];
            }
        }
        cItemArray.putValue(string2, string4);
    }

    public int readInteger(String string, String string2, int n) {
        String string3 = this.readString(string, string2, new Integer(n).toString());
        try {
            return new Integer(string3);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public void writeInteger(String string, String string2, int n) {
        this.writeString(string, string2, new Integer(n).toString());
    }

    public boolean readBool(String string, String string2, boolean bl) {
        return this.readInteger(string, string2, bl ? 1 : 0) != 0;
    }

    public void writeBool(String string, String string2, boolean bl) {
        this.writeString(string, string2, bl ? "1" : "0");
    }

    public double readFloat(String string, String string2, double d) {
        String string3 = this.readString(string, string2, new Double(d).toString());
        try {
            return new Double(string3);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public void writeFloat(String string, String string2, double d) {
        this.writeString(string, string2, new Double(d).toString());
    }

    public Date readDateTime(String string, String string2, Date date) {
        String string3 = this.readString(string, string2, date.toString());
        try {
            return new SimpleDateFormat().parse(string3);
        }
        catch (Exception exception) {
            return date;
        }
    }

    public void writeDateTime(String string, String string2, Date date) {
        this.writeString(string, string2, new SimpleDateFormat().format(date));
    }

    public static void main(String[] stringArray) {
        try {
            CIniFile cIniFile = new CIniFile("test.ini");
            boolean bl = cIniFile.readBool("Main", "BoolVal", false);
            System.out.println("BoolVal = " + bl);
            cIniFile.writeBool("Main", "BoolVal", !bl);
            System.out.println("Param1 = " + cIniFile.readString("Other X", "Param1", ""));
            System.out.println("Param2 = " + cIniFile.readInteger("Other X", "param2", 123));
            System.out.println("Param3 = " + cIniFile.readDateTime("Other X", "param3", new Date()));
            cIniFile.writeString("Other x", "param1", "..\"xxx\"...");
            cIniFile.writeDateTime("Other x", "param3", new Date());
            cIniFile.flush();
        }
        catch (Exception exception) {
            System.out.println("Ooopps..");
            System.out.println(exception.getMessage());
        }
    }

    private class CItemArray
    extends ArrayList {
        private CItemArray() {
        }

        private String normalizeKey(String string) {
            boolean bl = false;
            String string2 = "";
            int n = 0;
            while (n < string.length()) {
                if (!bl || string.charAt(n) != ' ' && string.charAt(n) != '\t') {
                    string2 = string2 + string.charAt(n);
                }
                bl = string.charAt(n) == ' ' || string.charAt(n) == '\t';
                ++n;
            }
            return string2;
        }

        public String getKey(int n) {
            return ((CItemHolder)this.get((int)n)).key;
        }

        public Object getValue(int n) {
            return ((CItemHolder)this.get((int)n)).value;
        }

        public Object getValue(String string) {
            string = this.normalizeKey(string);
            int n = 0;
            while (n < this.size()) {
                CItemHolder cItemHolder = (CItemHolder)this.get(n);
                if (cItemHolder.key.equalsIgnoreCase(string)) {
                    return cItemHolder.value;
                }
                ++n;
            }
            return null;
        }

        public void putValue(String string, Object object) {
            if ((string = this.normalizeKey(string)).length() > 0) {
                int n = 0;
                while (n < this.size()) {
                    CItemHolder cItemHolder = (CItemHolder)this.get(n);
                    if (cItemHolder.key.equalsIgnoreCase(string)) {
                        cItemHolder.value = object;
                        this.set(n, cItemHolder);
                        return;
                    }
                    ++n;
                }
            }
            this.add(new CItemHolder(string, object));
        }

        public void removeValue(int n) {
            this.remove(n);
        }

        public void removeValue(String string) {
            string = this.normalizeKey(string);
            int n = 0;
            while (n < this.size()) {
                CItemHolder cItemHolder = (CItemHolder)this.get(n);
                if (cItemHolder.key.equalsIgnoreCase(string)) {
                    this.remove(n);
                    return;
                }
                ++n;
            }
        }

        private class CItemHolder {
            public String key;
            public Object value;

            public CItemHolder(String string, Object object) {
                this.key = string;
                this.value = object;
            }
        }
    }
}

