/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.util.scanner;

import org.comedia.util.scanner.CScanner;

public class CCppScanner
extends CScanner {
    String[] cTypes = new String[]{"int", "long", "short", "char", "bool", "float", "double", "void"};
    String[] cKeywords = new String[]{"return", "if", "else", "while", "do", "switch", "case", "default", "typedef", "union", "class", "struct", "true", "false", "goto", "break", "continue", "for", "operator", "static", "public", "private", "protected", "friend", "this"};

    protected int lowRunLex(CScanner.Lexem lexem) {
        this.innerStartLex(lexem);
        if (lexem.tokenType != 0) {
            return lexem.tokenType;
        }
        this.innerProcCComment(lexem);
        if (lexem.tokenType != 0) {
            return lexem.tokenType;
        }
        char c = lexem.token.charAt(0);
        if (c == '/' && this.bufferPos < this.bufferLen && this.buffer.charAt(this.bufferPos) == '/') {
            return this.innerProcLineComment(lexem);
        }
        if (new String("{}()[]").indexOf(c) >= 0) {
            lexem.tokenType = 32;
            return 32;
        }
        if (new String(":;.,").indexOf(c) >= 0) {
            lexem.tokenType = 64;
            return 64;
        }
        if (new String("=+-<>/*^@#?%!|&~").indexOf(c) >= 0) {
            char c2;
            char c3;
            char c4 = c3 = this.bufferPos < this.bufferLen ? this.buffer.charAt(this.bufferPos) : (char)'\u0000';
            if (new String("+-!|~&*/>%").indexOf(c) >= 0 && c3 == '=' || c == '<' && c3 == '=' || new String("<>|&+-").indexOf(c) >= 0 && c3 == c || c == '-' && c3 == '>') {
                lexem.token = lexem.token + c3;
                ++this.bufferPos;
            }
            char c5 = c2 = c3 != '\u0000' && this.bufferPos < this.bufferLen ? this.buffer.charAt(this.bufferPos) : (char)'\u0000';
            if (c == '>' && c3 == '>' && c2 == '=' || c == '<' && c3 == '<' && c2 == '=') {
                lexem.token = lexem.token + c2;
                ++this.bufferPos;
            }
            lexem.tokenType = 16;
            return 16;
        }
        if (c == '\"') {
            return this.innerProcCString(lexem);
        }
        this.innerProcIdent(lexem);
        if (lexem.tokenType == 8) {
            if (this.showType && this.searchForString(lexem.token, this.types)) {
                lexem.tokenType = 4;
                return 4;
            }
            if (this.showKeyword && this.searchForString(lexem.token, this.keywords)) {
                lexem.tokenType = 2;
                return 2;
            }
        }
        return lexem.tokenType;
    }

    public static String wrapString(String string) {
        String string2 = "\"";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\t': {
                    string2 = string2 + "\\t";
                    break;
                }
                case '\n': {
                    string2 = string2 + "\\n";
                    break;
                }
                case '\r': {
                    string2 = string2 + "\\r";
                    break;
                }
                case '\u0000': {
                    string2 = string2 + "\\0";
                    break;
                }
                case '\"': 
                case '\'': 
                case '\\': {
                    string2 = string2 + '\\';
                }
                default: {
                    string2 = string2 + c;
                }
            }
            ++n;
        }
        return string2 + "\"";
    }

    public static String unwrapString(String string) {
        if ((string = CScanner.unwrapString(string)).length() == 0) {
            return "";
        }
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            int n2 = string.charAt(n);
            if (n2 == 92) {
                if (++n >= string.length()) break;
                n2 = string.charAt(n);
                switch (n2) {
                    case 110: {
                        n2 = 10;
                        break;
                    }
                    case 114: {
                        n2 = 13;
                        break;
                    }
                    case 116: {
                        n2 = 9;
                        break;
                    }
                    case 48: {
                        n2 = 0;
                    }
                }
            }
            string2 = string2 + (char)n2;
            ++n;
        }
        return string2;
    }

    public CCppScanner() {
        this.keywords = this.cKeywords;
        this.types = this.cTypes;
    }

    public static void main(String[] stringArray) {
        System.out.println("*********** C Scanner Test *************");
        CCppScanner cCppScanner = new CCppScanner();
        cCppScanner.setBuffer("while(1.0e2=i.a >>= \t\r\n-> \"string\\\"\")\n// comment\n/*second\ncomment*/{xxx}");
        cCppScanner.setShowEol(true);
        cCppScanner.setShowSpace(true);
        cCppScanner.setShowComment(true);
        cCppScanner.setShowKeyword(true);
        cCppScanner.setShowType(true);
        String string = "The test \"string\"";
        System.out.println("Start string: " + string);
        string = CCppScanner.wrapString(string);
        System.out.println("Wrapped string: " + string);
        string = CCppScanner.unwrapString(string);
        System.out.println("Unwrapped string: " + string);
        System.out.println();
        System.out.println("Initial string: " + cCppScanner.getBuffer());
        while (cCppScanner.lex() != 32768) {
            switch (cCppScanner.getTokenType()) {
                case 0: {
                    System.out.print("Type: Unknown ");
                    break;
                }
                case 1: {
                    System.out.print("Type: Comment ");
                    break;
                }
                case 2: {
                    System.out.print("Type: Keyword ");
                    break;
                }
                case 4: {
                    System.out.print("Type: Type ");
                    break;
                }
                case 8: {
                    System.out.print("Type: Ident ");
                    break;
                }
                case 14: {
                    System.out.print("Type: Alpha ");
                    break;
                }
                case 16: {
                    System.out.print("Type: Operator ");
                    break;
                }
                case 32: {
                    System.out.print("Type: Brace ");
                    break;
                }
                case 64: {
                    System.out.print("Type: Separator ");
                    break;
                }
                case 128: {
                    System.out.print("Type: Eol ");
                    break;
                }
                case 224: {
                    System.out.print("Type: Lf ");
                    break;
                }
                case 256: {
                    System.out.print("Type: Space ");
                    break;
                }
                case 512: {
                    System.out.print("Type: Int ");
                    break;
                }
                case 1024: {
                    System.out.print("Type: Float ");
                    break;
                }
                case 2048: {
                    System.out.print("Type: String ");
                    break;
                }
                case 4096: {
                    System.out.print("Type: Bool ");
                    break;
                }
                case 32768: {
                    System.out.print("Type: Eof ");
                }
            }
            System.out.println("Value: '" + cCppScanner.getToken() + "' Pos: " + cCppScanner.getPosition() + " Line: " + cCppScanner.getLineNo());
        }
    }
}

