/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.util.scanner;

public class CScanner {
    public static final int UNKNOWN = 0;
    public static final int COMMENT = 1;
    public static final int KEYWORD = 2;
    public static final int TYPE = 4;
    public static final int IDENT = 8;
    public static final int ALPHA = 14;
    public static final int OPERATOR = 16;
    public static final int BRACE = 32;
    public static final int SEPARATOR = 64;
    public static final int EOL = 128;
    public static final int LF = 224;
    public static final int SPACE = 256;
    public static final int DELIM = 496;
    public static final int INT = 512;
    public static final int FLOAT = 1024;
    public static final int STRING = 2048;
    public static final int BOOL = 4096;
    public static final int CONST = 7680;
    public static final int EOF = 32768;
    protected String buffer;
    protected int bufferPos;
    protected int bufferLine;
    protected int bufferLen;
    protected Lexem current;
    protected Lexem next;
    protected boolean showComment = false;
    protected boolean showString = true;
    protected boolean showEol = false;
    protected boolean showKeyword = true;
    protected boolean showType = true;
    protected boolean showSpace = false;
    protected String[] operators;
    protected String[] types;
    protected String[] keywords;

    public CScanner() {
        this.setBuffer("");
    }

    protected int lowRunLex(Lexem lexem) {
        int n = this.innerStartLex(lexem);
        if (n != 0) {
            return n;
        }
        char c = lexem.token.charAt(0);
        if (new String("(){}[]").indexOf(c) >= 0) {
            lexem.tokenType = 32;
            return 32;
        }
        if (c == ',' || c == '.' || c == ';' || c == ':') {
            lexem.tokenType = 64;
            return 64;
        }
        if (CScanner.isDelim(c)) {
            lexem.tokenType = 16;
            return 16;
        }
        if (CScanner.isQuote(c)) {
            char c2 = c;
            while (this.bufferPos < this.bufferLen) {
                c = this.buffer.charAt(this.bufferPos);
                if (c == '\n' || c == '\r') break;
                lexem.token = lexem.token + c;
                ++this.bufferPos;
                if (c == c2) break;
            }
            lexem.tokenType = 2048;
            return 2048;
        }
        n = CScanner.isDigit(c) ? 512 : 8;
        while (this.bufferPos < this.bufferLen) {
            c = this.buffer.charAt(this.bufferPos);
            if (CScanner.isDelim(c) || CScanner.isQuote(c)) break;
            if (n == 512 && c == '.') {
                n = 1024;
            }
            lexem.token = lexem.token + c;
            ++this.bufferPos;
        }
        lexem.tokenType = n;
        return lexem.tokenType;
    }

    protected int runLex(Lexem lexem) {
        int n;
        while (!(((n = this.lowRunLex(lexem)) == 128 || n == 224) && this.showEol || n == 1 && this.showComment || n != 128 && n != 224 && n != 1)) {
        }
        if (n == 2048 && !this.showString) {
            lexem.token = CScanner.unwrapString(lexem.token);
        }
        lexem.tokenType = n;
        return lexem.tokenType;
    }

    protected void extractToken() {
        if (this.next.token.length() != 0 && this.next.tokenType != 0) {
            this.current.tokenType = this.next.tokenType;
            this.current.lineNo = this.next.lineNo;
            this.current.position = this.next.position;
            this.current.token = this.next.token;
            this.next = new Lexem();
        } else {
            this.runLex(this.current);
        }
    }

    protected void extractNextToken() {
        if (this.next.token.length() == 0 && this.next.tokenType == 0) {
            this.runLex(this.next);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected int innerStartLex(Lexem var1_1) {
        var1_1.lineNo = this.bufferLine;
        var1_1.position = this.bufferPos;
        var1_1.token = "";
        if (this.bufferPos >= this.bufferLen) {
            var1_1.tokenType = 32768;
            return 32768;
        }
        if (!this.showSpace || !CScanner.isWhite(this.buffer.charAt(this.bufferPos))) ** GOTO lbl19
        do {
            var1_1.token = var1_1.token + this.buffer.charAt(this.bufferPos);
            ++this.bufferPos;
        } while (this.bufferPos < this.bufferLen && CScanner.isWhite(this.buffer.charAt(this.bufferPos)));
        var1_1.tokenType = 256;
        return 256;
lbl-1000:
        // 1 sources

        {
            ++this.bufferPos;
            if (this.bufferPos < this.bufferLen) continue;
            var1_1.position = this.bufferPos;
            var1_1.tokenType = 32768;
            return 32768;
lbl19:
            // 2 sources

            ** while (CScanner.isWhite((char)this.buffer.charAt((int)this.bufferPos)))
        }
lbl20:
        // 1 sources

        var1_1.position = this.bufferPos;
        var1_1.token = "" + this.buffer.charAt(this.bufferPos);
        ++this.bufferPos;
        if (var1_1.token.charAt(0) == '\r') {
            var1_1.tokenType = 224;
            return 224;
        }
        if (var1_1.token.charAt(0) == '\n') {
            ++this.bufferLine;
            var1_1.tokenType = 128;
            return 128;
        }
        var1_1.tokenType = 0;
        return 0;
    }

    protected int innerProcLineComment(Lexem lexem) {
        while (this.bufferPos < this.bufferLen) {
            char c = this.buffer.charAt(this.bufferPos);
            lexem.token = lexem.token + c;
            ++this.bufferPos;
            if (c != '\n') continue;
            ++this.bufferLine;
            break;
        }
        lexem.tokenType = 1;
        return 1;
    }

    protected int innerProcCComment(Lexem lexem) {
        lexem.tokenType = 0;
        if (lexem.token.charAt(0) == '/' && this.bufferPos < this.bufferLen && this.buffer.charAt(this.bufferPos) == '*') {
            lexem.tokenType = 1;
            int n = 0;
            while (this.bufferPos < this.bufferLen) {
                char c = this.buffer.charAt(this.bufferPos);
                lexem.token = lexem.token + c;
                ++this.bufferPos;
                if (c == '/' && n == 42 && lexem.token.length() > 3) break;
                if (c == '\n') {
                    ++this.bufferLine;
                }
                n = c;
            }
        }
        return lexem.tokenType;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int innerProcIdent(Lexem lexem) {
        char c;
        block9: {
            c = lexem.token.charAt(0);
            lexem.tokenType = 0;
            if (!CScanner.isDigit(c) && !CScanner.isLetter(c)) {
                if (new String("._,$").indexOf(c) < 0) return lexem.tokenType;
            }
            if (c == '.') {
                if (this.bufferPos < this.bufferLen && CScanner.isDigit(this.buffer.charAt(this.bufferPos))) {
                    lexem.tokenType = 1024;
                    break block9;
                } else {
                    lexem.tokenType = 64;
                    return 64;
                }
            }
            lexem.tokenType = CScanner.isDigit(c) ? 512 : 8;
        }
        while (this.bufferPos < this.bufferLen) {
            c = this.buffer.charAt(this.bufferPos);
            if (!CScanner.isDigit(c) && !CScanner.isLetter(c) && new String("._,$").indexOf(c) < 0) {
                return lexem.tokenType;
            }
            if (lexem.tokenType == 512 && c == '.') {
                lexem.tokenType = 1024;
            } else if (c == '.') {
                return lexem.tokenType;
            }
            lexem.token = lexem.token + c;
            ++this.bufferPos;
        }
        return lexem.tokenType;
    }

    protected int innerProcString(Lexem lexem) {
        lexem.tokenType = 0;
        char c = lexem.token.charAt(0);
        if (CScanner.isQuote(c)) {
            lexem.tokenType = 2048;
            char c2 = c;
            while (this.bufferPos < this.bufferLen) {
                c = this.buffer.charAt(this.bufferPos);
                if (c == '\n' || c == '\r') break;
                lexem.token = lexem.token + c;
                ++this.bufferPos;
                if (c == c2) break;
            }
        }
        return lexem.tokenType;
    }

    protected int innerProcCString(Lexem lexem) {
        lexem.tokenType = 0;
        char c = lexem.token.charAt(0);
        if (CScanner.isQuote(c)) {
            lexem.tokenType = 2048;
            char c2 = c;
            while (this.bufferPos < this.bufferLen) {
                c = this.buffer.charAt(this.bufferPos);
                if (c == '\n' || c == '\r') break;
                lexem.token = lexem.token + c;
                ++this.bufferPos;
                if (c == '\\' && this.bufferPos < this.bufferLen && this.buffer.charAt(this.bufferPos) == c2) {
                    lexem.token = lexem.token + c2;
                    ++this.bufferPos;
                    continue;
                }
                if (c == c2) break;
            }
        }
        return lexem.tokenType;
    }

    protected int innerProcPasString(Lexem lexem) {
        lexem.tokenType = 0;
        char c = lexem.token.charAt(0);
        if (CScanner.isQuote(c)) {
            lexem.tokenType = 2048;
            char c2 = c;
            while (this.bufferPos < this.bufferLen) {
                c = this.buffer.charAt(this.bufferPos);
                if (c == '\n' || c == '\r') break;
                lexem.token = lexem.token + c;
                ++this.bufferPos;
                if (c == c2 && this.bufferPos < this.bufferLen && this.buffer.charAt(this.bufferPos) == c2) {
                    lexem.token = lexem.token + c2;
                    ++this.bufferPos;
                    continue;
                }
                if (c == c2) break;
            }
        }
        return lexem.tokenType;
    }

    protected boolean searchForString(String string, String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void restart() {
        this.setBuffer(this.buffer);
    }

    public static String wrapString(String string) {
        return "\"" + string + "\"";
    }

    public static String unwrapString(String string) {
        if (string.length() == 0) {
            return string;
        }
        char c = string.charAt(0);
        int n = 0;
        int n2 = string.length() - 1;
        if (c == '\"' || c == '\'') {
            ++n;
            if (n2 > 0 && string.charAt(n2) == c) {
                --n2;
            }
        }
        return string.substring(n, n2 + 1);
    }

    public static boolean isAlpha(char c) {
        return c >= ' ' && !CScanner.isDelim(c) && !CScanner.isDigit(c);
    }

    public static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isDelim(char c) {
        return new String(":;,+-<>/*%^=()[]|&~@#$\\`{}!? \t\n\r").indexOf(c) >= 0;
    }

    public static boolean isWhite(char c) {
        return c == ' ' || c == '\t';
    }

    public static boolean isEol(char c) {
        return c == '\n';
    }

    public static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }

    public int lex() {
        this.extractToken();
        return this.current.tokenType;
    }

    public int gotoNextToken() {
        return this.lex();
    }

    public boolean isShowComment() {
        return this.showComment;
    }

    public void setShowComment(boolean bl) {
        this.showComment = bl;
    }

    public boolean isShowEol() {
        return this.showEol;
    }

    public void setShowEol(boolean bl) {
        this.showEol = bl;
    }

    public boolean isShowString() {
        return this.showString;
    }

    public void setShowString(boolean bl) {
        this.showString = bl;
    }

    public boolean isShowKeyword() {
        return this.showKeyword;
    }

    public void setShowKeyword(boolean bl) {
        this.showKeyword = bl;
    }

    public boolean isShowType() {
        return this.showType;
    }

    public void setShowType(boolean bl) {
        this.showType = bl;
    }

    public boolean isShowSpace() {
        return this.showSpace;
    }

    public void setShowSpace(boolean bl) {
        this.showSpace = bl;
    }

    public String getBuffer() {
        return this.buffer.toString();
    }

    public void setBuffer(String string) {
        this.buffer = string;
        this.bufferLen = string.length();
        this.bufferPos = 0;
        this.bufferLine = 0;
        this.current = new Lexem();
        this.current.tokenType = 32768;
        this.next = new Lexem();
    }

    public int getBufferPos() {
        return this.bufferPos;
    }

    public int getPosition() {
        return this.current.position;
    }

    public int getLineNo() {
        return this.current.lineNo;
    }

    public String getToken() {
        return this.current.token;
    }

    public int getTokenType() {
        return this.current.tokenType;
    }

    public int getNextPosition() {
        this.extractNextToken();
        return this.next.position;
    }

    public int getNextLineNo() {
        this.extractNextToken();
        return this.next.lineNo;
    }

    public String getNextToken() {
        this.extractNextToken();
        return this.next.token;
    }

    public int getNextTokenType() {
        this.extractNextToken();
        return this.next.tokenType;
    }

    public static void main(String[] stringArray) {
        System.out.println("*********** Scanner Test *************");
        CScanner cScanner = new CScanner();
        cScanner.setBuffer("while(1.0e2*i := \t\r\n> \"string''\")\n// comment\n/*second\ncomment*/{xxx}");
        cScanner.setShowEol(true);
        cScanner.setShowSpace(true);
        String string = "The test \"string\"";
        System.out.println("Start string: " + string);
        string = CScanner.wrapString(string);
        System.out.println("Wrapped string: " + string);
        string = CScanner.unwrapString(string);
        System.out.println("Unwrapped string: " + string);
        System.out.println();
        System.out.println("Initial string: " + cScanner.getBuffer());
        while (cScanner.lex() != 32768) {
            switch (cScanner.getTokenType()) {
                case 0: {
                    System.out.print("Type: Unknown ");
                    break;
                }
                case 1: {
                    System.out.print("Type: Comment ");
                    break;
                }
                case 2: {
                    System.out.print("Type: Keyword ");
                    break;
                }
                case 4: {
                    System.out.print("Type: Type ");
                    break;
                }
                case 8: {
                    System.out.print("Type: Ident ");
                    break;
                }
                case 14: {
                    System.out.print("Type: Alpha ");
                    break;
                }
                case 16: {
                    System.out.print("Type: Operator ");
                    break;
                }
                case 32: {
                    System.out.print("Type: Brace ");
                    break;
                }
                case 64: {
                    System.out.print("Type: Separator ");
                    break;
                }
                case 128: {
                    System.out.print("Type: Eol ");
                    break;
                }
                case 224: {
                    System.out.print("Type: Lf ");
                    break;
                }
                case 256: {
                    System.out.print("Type: Space ");
                    break;
                }
                case 512: {
                    System.out.print("Type: Int ");
                    break;
                }
                case 1024: {
                    System.out.print("Type: Float ");
                    break;
                }
                case 2048: {
                    System.out.print("Type: String ");
                    break;
                }
                case 4096: {
                    System.out.print("Type: Bool ");
                    break;
                }
                case 32768: {
                    System.out.print("Type: Eof ");
                }
            }
            System.out.println("Value: '" + cScanner.getToken() + "' Pos: " + cScanner.getPosition() + " Line: " + cScanner.getLineNo());
        }
    }

    protected class Lexem {
        public String token = "";
        public int tokenType = 0;
        public int position = 0;
        public int lineNo = 0;

        protected Lexem() {
        }
    }
}

