/**
 * FontDialogBean.java  1.00 97/08/09 Merlin Hughes
 *
 * Copyright (c) 1997 Merlin Hughes, All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * for commercial and non-commercial purposes and without fee is
 * hereby granted provided that this copyright notice appears in
 * all copies.
 *
 * http://prominence.com/                         ego@merlin.org
 */

package org.merlin.beans.font;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.util.*;

public class FontDialogBean extends Container implements ActionListener, ItemListener {
  protected Window dialog;
  protected Label sample;
  protected FontSelectorBean selector;
  public Button change;

  public FontDialogBean () {
    sample = new Label ("abcABC012...");
    change = new Button ("Change...");
    setLayout (new BorderLayout ());
    add ("Center", sample);
    add ("East", change);

    change.addActionListener (this);
  }

  public void setStyle (Font f) {
    sample.setFont (f);
  }

  public Font getStyle () {
    return sample.getFont ();
  }

  public void removeNotify () {
    if (dialog != null) {
      dialog.dispose ();
      dialog = null;
    }
    super.removeNotify ();
  }

  public void actionPerformed (ActionEvent e) {
    createDialog ();
    selector.setStyle (sample.getFont ());
    dialog.pack ();
    dialog.setVisible (true);
  }

  protected synchronized void createDialog () {
    if (dialog == null) {
      Container c = this;
      while (c.getParent () != null)
        c = c.getParent ();
      if (c instanceof Frame)
        dialog = new Dialog ((Frame) c, "Select a Font", true);
      else
        dialog = new Frame ("Select Font");
      try {
        selector = (FontSelectorBean) Beans.instantiate (getClass ().getClassLoader (), "org.merlin.beans.font.FontSelectorBean");
      } catch (Exception ex) {
        ex.printStackTrace ();
      }
      dialog.add ("Center", (Component) Beans.getInstanceOf (selector, Component.class));

      selector.addItemListener (this);

      dialog.addWindowListener (new WindowAdapter () {
        public void windowClosing (WindowEvent e) {
//          dialog.setVisible (false);
          dialog.dispose (); // windows
        }
      });
    }
  }

  public void itemStateChanged (ItemEvent e) {
//    dialog.setVisible (false);
    dialog.dispose (); // windows
    if (e.getStateChange () == e.SELECTED) {
      sample.setFont ((Font) e.getItem ());
      fireFontEvent ();
    }
  }

  protected Vector listeners = new Vector ();

  public void addFontListener (FontListener l) {
    listeners.addElement (l);
  }

  public void removeFontListener (FontListener l) {
    listeners.removeElement (l);
  }

  protected void fireFontEvent () {
    FontEvent event = new FontEvent (this, FontEvent.FONT_SELECTED, getStyle ());
    Vector listeners = (Vector) this.listeners.clone ();

    for (int i = 0; i < listeners.size (); ++ i)
      ((FontListener) listeners.elementAt (i)).fontSelected (event);
  }
}
