/**
 * FontEvent.java  1.00 97/08/09 Merlin Hughes
 *
 * Copyright (c) 1997 Merlin Hughes, All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * for commercial and non-commercial purposes and without fee is
 * hereby granted provided that this copyright notice appears in
 * all copies.
 *
 * http://prominence.com/                         ego@merlin.org
 */

package org.merlin.beans.font;

import java.awt.*;

public class FontEvent extends AWTEvent {
  public static final int FONT_SELECTED = RESERVED_ID_MAX + 1;

  protected Font font;
  
  public FontEvent (Component source, int id, Font font) {
    super (source, id);
    this.font = font;
  }

  public Font getFont () {
    return font;
  }

  public String paramString () {
    return "FONT_SELECTED,font=" + font;
  }
}
