/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import java.awt.*;
import java.io.IOException;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.*;

/** Creates a JTree with Drag and Drop facilities.
* <p>
* Create and use an object of DNDTree instead of a JTree to include Drag and Drop features for your tree.
* @version 1.01 03/01/2001
* @author Prathap G
*/
public class DNDTree extends JATree implements DropTargetListener,DragSourceListener, DragGestureListener{
	/** The Drop position. */
	private DropTarget dropTarget = null;
	/** The Drag node.*/
	private DragSource dragSource = null;
	/** The dragged node.*/
    protected DefaultMutableTreeNode fromNode=null;
	/** The droppped node.*/
    protected DefaultMutableTreeNode dropnode=null;
	/** The TreeModel for the tree.*/
	private DefaultTreeModel treemodel=null;

	/** Returns a new instance of the DNDTree for the specified TreeModel.*/
	public DNDTree(TreeModel model){
		super(model);
		treemodel=(DefaultTreeModel)model;
		dropTarget = new DropTarget (this, this);
		dragSource = new DragSource();
		dragSource.createDefaultDragGestureRecognizer( this, DnDConstants.ACTION_MOVE, this);
	}

	/** Internally implemented, Do not override!*/
	public void dragEnter(DropTargetDragEvent event){
		event.acceptDrag (DnDConstants.ACTION_MOVE);
	}

	/** Internally implemented, Do not override!*/
	public void dragExit(DropTargetEvent event){
	}

	/** Internally implemented, Do not override!*/
	public void dragOver(DropTargetDragEvent event){
	}

	/** Internally implemented, Do not override!*/
	public void drop(DropTargetDropEvent event){
		try {
			Transferable transferable = event.getTransferable();

			if (transferable.isDataFlavorSupported (DataFlavor.stringFlavor)){
				event.acceptDrop(DnDConstants.ACTION_MOVE);
				String s = (String)transferable.getTransferData ( DataFlavor.stringFlavor);
				Object occur=event.getSource();
				Point droppoint=event.getLocation();
				TreePath droppath=getClosestPathForLocation(droppoint.x,droppoint.y);
				dropnode=(DefaultMutableTreeNode)droppath.getLastPathComponent();
				event.getDropTargetContext().dropComplete(true);
			}
			else{
				event.rejectDrop();
			}
		}
		catch (IOException exception) {
			event.rejectDrop();
		}
		catch (UnsupportedFlavorException ufException ) {
			event.rejectDrop();
		}
	}

	/** Internally implemented, Do not override!*/
	public void dropActionChanged ( DropTargetDragEvent event ){
	}

	/** Internally implemented, Do not override!*/
	public void dragGestureRecognized( DragGestureEvent event){
		fromNode=null;
		dropnode=null;
		Object selected =getSelectionPath();
		TreePath treepath=(TreePath)selected;
		fromNode=(DefaultMutableTreeNode)treepath.getLastPathComponent();
		if ( selected != null ){
            Cursor cursor = selectCursor (event.getDragAction());
			StringSelection text = new StringSelection( selected.toString());
			dragSource.startDrag (event, cursor, text, this);
		}
		else{
		}
	}

    private Cursor selectCursor (int action) {
        return (action == DnDConstants.ACTION_MOVE) ?
        DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop;
    }

	/** Internally implemented, Do not override!.
	* throws IllegalArgumentException.
	*/
	public void dragDropEnd (DragSourceDropEvent event){
		if ( event.getDropSuccess()){
			try{
				if(dropnode.equals(fromNode)){
					System.out.println("drag==drop");
					throw new IllegalArgumentException("the source is the same as the destination");
				}
				else{
                    // 20040715, acg -
                    // Don't add node as a child. ... dropnode.add(fromNode);
                    // Instead insert node above
                    DefaultMutableTreeNode parent=(DefaultMutableTreeNode)dropnode.getParent();
                    int i=parent.getIndex(dropnode);
                    parent.insert(fromNode, i);
				}
			} catch(IllegalArgumentException iae){
				throw new IllegalArgumentException(iae.toString());
			}
			treemodel.reload();
        }
	}

	/** Internally implemented, Do not override!*/
	public void dragEnter (DragSourceDragEvent event){
	}

	/** Internally implemented, Do not override!*/
	public void dragExit (DragSourceEvent event){
	}

	/** Internally implemented, Do not override!*/
	public void dragOver (DragSourceDragEvent event){
	}

	/** Internally implemented, Do not override!*/
	public void dropActionChanged ( DragSourceDragEvent event){
	}
}



