/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui;

import java.awt.Component;
import java.awt.event.FocusListener;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;

/**
 *  Stub
 */

public class JACheckBox extends JCheckBox {
  /**
   * Creates an initially unselected check box button with no text, no icon.
   */
  public JACheckBox() {
    super();
    init();
  }

  /**
   * Creates an initially unselected check box with an icon.
   *
   * @param icon  the Icon image to display
   */
  public JACheckBox(Icon icon) {
    super(icon);
    init();
  }

  /**
   * Creates a check box with an icon and specifies whether
   * or not it is initially selected.
   *
   * @param icon  the Icon image to display
   * @param selected a boolean value indicating the initial selection
   *        state. If <code>true</code> the check box is selected
   */
  public JACheckBox(Icon icon, boolean selected) {
    super(icon, selected);
    init();
  }

  /**
   * Creates an initially unselected check box with text.
   *
   * @param text the text of the check box.
   */
  public JACheckBox(String text) {
    super(text);
    init();
  }

  /**
   * Creates an initially unselected check box with text.and a specified mnemonic
   *
   * @param text the text of the check box.
   */
  public JACheckBox(String text, char mnemonic) {
    super(text);
    init();
    setMnemonic(mnemonic);
  }

  /**
   * Creates a check box where properties are taken from the
   * Action supplied.
   *
   * @since 1.3
   */
  public JACheckBox(Action a) {
    super(a);
    init();
  }

  /**
   * Creates a check box with text and specifies whether
   * or not it is initially selected.
   *
   * @param text the text of the check box.
   * @param selected a boolean value indicating the initial selection
   *        state. If <code>true</code> the check box is selected
   */
  public JACheckBox(String text, boolean selected) {
    super(text, selected);
    init();
  }

  /**
   * Creates an initially unselected check box with
   * the specified text and icon.
   *
   * @param text the text of the check box.
   * @param icon  the Icon image to display
   */
  public JACheckBox(String text, Icon icon) {
    super(text, icon);
    init();
  }

  /**
   * Creates a check box with text and icon,
   * and specifies whether or not it is initially selected.
   *
   * @param text the text of the check box.
   * @param icon  the Icon image to display
   * @param selected a boolean value indicating the initial selection
   *        state. If <code>true</code> the check box is selected
   */
  public JACheckBox(String text, Icon icon, boolean selected) {
    super(text, icon, selected);
    init();
  }

  /**
   * internal initialization of the validation events stuff
   */
  private void init() {
  }

}


